/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.tcp;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.net.Socket;
import java.security.KeyStore;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.sasl.SaslException;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.SASLAuthentication;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.compression.XMPPInputOutputStream;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.parsing.ParsingExceptionCallback;
import org.jivesoftware.smack.tcp.PacketReader;
import org.jivesoftware.smack.tcp.PacketWriter;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.dns.HostAddress;

public class XMPPTCPConnection
extends XMPPConnection {
    private static final Logger LOGGER = Logger.getLogger(XMPPTCPConnection.class.getName());
    Socket socket;
    String connectionID = null;
    private String user = null;
    private boolean connected = false;
    private volatile boolean socketClosed = false;
    private boolean anonymous = false;
    private boolean usingTLS = false;
    private ParsingExceptionCallback parsingExceptionCallback = SmackConfiguration.getDefaultParsingExceptionCallback();
    PacketWriter packetWriter;
    PacketReader packetReader;
    private Collection<String> compressionMethods;
    private boolean serverAckdCompression = false;
    private final Object compressionLock = new Object();

    public XMPPTCPConnection(String serviceName, CallbackHandler callbackHandler) {
        super(new ConnectionConfiguration(serviceName));
        this.config.setCallbackHandler(callbackHandler);
    }

    public XMPPTCPConnection(String serviceName) {
        super(new ConnectionConfiguration(serviceName));
    }

    public XMPPTCPConnection(ConnectionConfiguration config) {
        super(config);
    }

    public XMPPTCPConnection(ConnectionConfiguration config, CallbackHandler callbackHandler) {
        super(config);
        config.setCallbackHandler(callbackHandler);
    }

    public String getConnectionID() {
        if (!this.isConnected()) {
            return null;
        }
        return this.connectionID;
    }

    public String getUser() {
        if (!this.isAuthenticated()) {
            return null;
        }
        return this.user;
    }

    public void setParsingExceptionCallback(ParsingExceptionCallback callback) {
        this.parsingExceptionCallback = callback;
    }

    public ParsingExceptionCallback getParsingExceptionCallback() {
        return this.parsingExceptionCallback;
    }

    public synchronized void login(String username, String password, String resource) throws XMPPException, SmackException, SaslException, IOException {
        String response;
        if (!this.isConnected()) {
            throw new SmackException.NotConnectedException();
        }
        if (this.authenticated) {
            throw new SmackException.AlreadyLoggedInException();
        }
        username = username.toLowerCase(Locale.US).trim();
        if (this.saslAuthentication.hasNonAnonymousAuthentication()) {
            if (password != null) {
                this.saslAuthentication.authenticate(username, password, resource);
            } else {
                this.saslAuthentication.authenticate(resource, this.config.getCallbackHandler());
            }
        } else {
            throw new SaslException("No non-anonymous SASL authentication mechanism available");
        }
        if (this.config.isCompressionEnabled()) {
            this.useCompression();
        }
        if ((response = this.bindResourceAndEstablishSession(resource)) != null) {
            this.user = response;
            this.setServiceName(StringUtils.parseServer((String)response));
        } else {
            this.user = username + "@" + this.getServiceName();
            if (resource != null) {
                this.user = this.user + "/" + resource;
            }
        }
        this.authenticated = true;
        this.anonymous = false;
        if (this.config.isSendPresence()) {
            this.sendPacket((Packet)new Presence(Presence.Type.available));
        }
        this.setLoginInfo(username, password, resource);
        if (this.config.isDebuggerEnabled() && this.debugger != null) {
            this.debugger.userHasLogged(this.user);
        }
        this.callConnectionAuthenticatedListener();
    }

    public synchronized void loginAnonymously() throws XMPPException, SmackException, SaslException, IOException {
        String response;
        if (!this.isConnected()) {
            throw new SmackException.NotConnectedException();
        }
        if (this.authenticated) {
            throw new SmackException.AlreadyLoggedInException();
        }
        if (!this.saslAuthentication.hasAnonymousAuthentication()) {
            throw new SaslException("No anonymous SASL authentication mechanism available");
        }
        this.saslAuthentication.authenticateAnonymously();
        this.user = response = this.bindResourceAndEstablishSession(null);
        this.setServiceName(StringUtils.parseServer((String)response));
        if (this.config.isCompressionEnabled()) {
            this.useCompression();
        }
        this.sendPacket((Packet)new Presence(Presence.Type.available));
        this.authenticated = true;
        this.anonymous = true;
        if (this.config.isDebuggerEnabled() && this.debugger != null) {
            this.debugger.userHasLogged(this.user);
        }
        this.callConnectionAuthenticatedListener();
    }

    public boolean isConnected() {
        return this.connected;
    }

    public boolean isSecureConnection() {
        return this.isUsingTLS();
    }

    public boolean isSocketClosed() {
        return this.socketClosed;
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    protected void shutdown() {
        if (this.packetReader != null) {
            this.packetReader.shutdown();
        }
        if (this.packetWriter != null) {
            this.packetWriter.shutdown();
        }
        this.socketClosed = true;
        try {
            this.socket.close();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "shutdown", e);
        }
        this.setWasAuthenticated(this.authenticated);
        this.authenticated = false;
        this.connected = false;
        this.usingTLS = false;
        this.reader = null;
        this.writer = null;
    }

    protected void sendPacketInternal(Packet packet) throws SmackException.NotConnectedException {
        this.packetWriter.sendPacket(packet);
    }

    private void connectUsingConfiguration(ConnectionConfiguration config) throws SmackException, IOException {
        Exception exception = null;
        try {
            this.maybeResolveDns();
        }
        catch (Exception e) {
            throw new SmackException((Throwable)e);
        }
        Iterator it = config.getHostAddresses().iterator();
        LinkedList<HostAddress> failedAddresses = new LinkedList<HostAddress>();
        while (it.hasNext()) {
            exception = null;
            HostAddress hostAddress = (HostAddress)it.next();
            String host = hostAddress.getFQDN();
            int port = hostAddress.getPort();
            try {
                this.socket = config.getSocketFactory() == null ? new Socket(host, port) : config.getSocketFactory().createSocket(host, port);
            }
            catch (Exception e) {
                exception = e;
            }
            if (exception == null) {
                host = hostAddress.getFQDN();
                port = hostAddress.getPort();
                break;
            }
            hostAddress.setException(exception);
            failedAddresses.add(hostAddress);
            if (it.hasNext()) continue;
            throw new SmackException.ConnectionException(failedAddresses);
        }
        this.socketClosed = false;
        this.initConnection();
    }

    private void initConnection() throws SmackException, IOException {
        boolean isFirstInitialization = this.packetReader == null || this.packetWriter == null;
        this.compressionHandler = null;
        this.serverAckdCompression = false;
        this.initReaderAndWriter();
        try {
            if (isFirstInitialization) {
                this.packetWriter = new PacketWriter(this);
                this.packetReader = new PacketReader(this);
                if (this.config.isDebuggerEnabled()) {
                    this.addPacketListener(this.debugger.getReaderListener(), null);
                    if (this.debugger.getWriterListener() != null) {
                        this.addPacketSendingListener(this.debugger.getWriterListener(), null);
                    }
                }
            } else {
                this.packetWriter.init();
                this.packetReader.init();
            }
            this.packetWriter.startup();
            this.packetReader.startup();
            this.connected = true;
            if (isFirstInitialization) {
                for (ConnectionCreationListener listener : XMPPTCPConnection.getConnectionCreationListeners()) {
                    listener.connectionCreated((XMPPConnection)this);
                }
            }
        }
        catch (SmackException ex) {
            this.shutdown();
            throw ex;
        }
    }

    private void initReaderAndWriter() throws IOException {
        try {
            if (this.compressionHandler == null) {
                this.reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), "UTF-8"));
                this.writer = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream(), "UTF-8"));
            } else {
                try {
                    OutputStream os = this.compressionHandler.getOutputStream(this.socket.getOutputStream());
                    this.writer = new BufferedWriter(new OutputStreamWriter(os, "UTF-8"));
                    InputStream is = this.compressionHandler.getInputStream(this.socket.getInputStream());
                    this.reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "initReaderAndWriter()", e);
                    this.compressionHandler = null;
                    this.reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), "UTF-8"));
                    this.writer = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream(), "UTF-8"));
                }
            }
        }
        catch (UnsupportedEncodingException ioe) {
            throw new IllegalStateException(ioe);
        }
        this.initDebugger();
    }

    public boolean isUsingTLS() {
        return this.usingTLS;
    }

    void startTLSReceived(boolean required) throws IOException {
        if (required && this.config.getSecurityMode() == ConnectionConfiguration.SecurityMode.disabled) {
            this.notifyConnectionError(new IllegalStateException("TLS required by server but not allowed by connection configuration"));
            return;
        }
        if (this.config.getSecurityMode() == ConnectionConfiguration.SecurityMode.disabled) {
            return;
        }
        this.writer.write("<starttls xmlns=\"urn:ietf:params:xml:ns:xmpp-tls\"/>");
        this.writer.flush();
    }

    void proceedTLSReceived() throws Exception {
        SSLContext context = this.config.getCustomSSLContext();
        KeyStore ks = null;
        KeyManager[] kms = null;
        PasswordCallback pcb = null;
        if (this.config.getCallbackHandler() == null) {
            ks = null;
        } else if (context == null) {
            if (this.config.getKeystoreType().equals("NONE")) {
                ks = null;
                pcb = null;
            } else if (this.config.getKeystoreType().equals("PKCS11")) {
                try {
                    Constructor<?> c = Class.forName("sun.security.pkcs11.SunPKCS11").getConstructor(InputStream.class);
                    String pkcs11Config = "name = SmartCard\nlibrary = " + this.config.getPKCS11Library();
                    ByteArrayInputStream config = new ByteArrayInputStream(pkcs11Config.getBytes());
                    Provider p = (Provider)c.newInstance(config);
                    Security.addProvider(p);
                    ks = KeyStore.getInstance("PKCS11", p);
                    pcb = new PasswordCallback("PKCS11 Password: ", false);
                    this.config.getCallbackHandler().handle(new Callback[]{pcb});
                    ks.load(null, pcb.getPassword());
                }
                catch (Exception e) {
                    ks = null;
                    pcb = null;
                }
            } else if (this.config.getKeystoreType().equals("Apple")) {
                ks = KeyStore.getInstance("KeychainStore", "Apple");
                ks.load(null, null);
            } else {
                ks = KeyStore.getInstance(this.config.getKeystoreType());
                try {
                    pcb = new PasswordCallback("Keystore Password: ", false);
                    this.config.getCallbackHandler().handle(new Callback[]{pcb});
                    ks.load(new FileInputStream(this.config.getKeystorePath()), pcb.getPassword());
                }
                catch (Exception e) {
                    ks = null;
                    pcb = null;
                }
            }
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            try {
                if (pcb == null) {
                    kmf.init(ks, null);
                } else {
                    kmf.init(ks, pcb.getPassword());
                    pcb.clearPassword();
                }
                kms = kmf.getKeyManagers();
            }
            catch (NullPointerException npe) {
                kms = null;
            }
        }
        if (context == null) {
            context = SSLContext.getInstance("TLS");
            context.init(kms, null, new SecureRandom());
        }
        Socket plain = this.socket;
        this.socket = context.getSocketFactory().createSocket(plain, plain.getInetAddress().getHostAddress(), plain.getPort(), true);
        this.initReaderAndWriter();
        try {
            ((SSLSocket)this.socket).startHandshake();
        }
        catch (IOException e) {
            this.setConnectionException(e);
            throw e;
        }
        this.usingTLS = true;
        this.packetWriter.setWriter(this.writer);
        this.packetWriter.openStream();
    }

    void setAvailableCompressionMethods(Collection<String> methods) {
        this.compressionMethods = methods;
    }

    private XMPPInputOutputStream maybeGetCompressionHandler() {
        if (this.compressionMethods != null) {
            for (XMPPInputOutputStream handler : SmackConfiguration.getCompresionHandlers()) {
                String method = handler.getCompressionMethod();
                if (!this.compressionMethods.contains(method)) continue;
                return handler;
            }
        }
        return null;
    }

    public boolean isUsingCompression() {
        return this.compressionHandler != null && this.serverAckdCompression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean useCompression() throws IOException {
        if (this.authenticated) {
            throw new IllegalStateException("Compression should be negotiated before authentication.");
        }
        this.compressionHandler = this.maybeGetCompressionHandler();
        if (this.compressionHandler != null) {
            Object object = this.compressionLock;
            synchronized (object) {
                this.requestStreamCompression(this.compressionHandler.getCompressionMethod());
                try {
                    this.compressionLock.wait(this.getPacketReplyTimeout());
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return this.isUsingCompression();
        }
        return false;
    }

    private void requestStreamCompression(String method) throws IOException {
        this.writer.write("<compress xmlns='http://jabber.org/protocol/compress'>");
        this.writer.write("<method>" + method + "</method></compress>");
        this.writer.flush();
    }

    void startStreamCompression() throws IOException {
        this.serverAckdCompression = true;
        this.initReaderAndWriter();
        this.packetWriter.setWriter(this.writer);
        this.packetWriter.openStream();
        this.streamCompressionNegotiationDone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void streamCompressionNegotiationDone() {
        Object object = this.compressionLock;
        synchronized (object) {
            this.compressionLock.notify();
        }
    }

    protected void connectInternal() throws SmackException, IOException, XMPPException {
        this.connectUsingConfiguration(this.config);
        if (this.connected) {
            this.callConnectionConnectedListener();
        }
        if (this.connected && this.wasAuthenticated) {
            if (this.isAnonymous()) {
                this.loginAnonymously();
            } else {
                this.login(this.config.getUsername(), this.config.getPassword(), this.config.getResource());
            }
            this.notifyReconnection();
        }
    }

    synchronized void notifyConnectionError(Exception e) {
        if ((this.packetReader == null || this.packetReader.done) && (this.packetWriter == null || this.packetWriter.done)) {
            return;
        }
        this.shutdown();
        this.callConnectionClosedOnErrorListener(e);
    }

    protected void processPacket(Packet packet) {
        super.processPacket(packet);
    }

    protected Reader getReader() {
        return super.getReader();
    }

    protected Writer getWriter() {
        return super.getWriter();
    }

    protected void throwConnectionExceptionOrNoResponse() throws IOException, SmackException.NoResponseException {
        super.throwConnectionExceptionOrNoResponse();
    }

    protected void setServiceName(String serviceName) {
        super.setServiceName(serviceName);
    }

    protected void serverRequiresBinding() {
        super.serverRequiresBinding();
    }

    protected void setServiceCapsNode(String node) {
        super.setServiceCapsNode(node);
    }

    protected void serverSupportsSession() {
        super.serverSupportsSession();
    }

    protected void setRosterVersioningSupported() {
        super.setRosterVersioningSupported();
    }

    protected void serverSupportsAccountCreation() {
        super.serverSupportsAccountCreation();
    }

    protected SASLAuthentication getSASLAuthentication() {
        return super.getSASLAuthentication();
    }

    protected ConnectionConfiguration getConfiguration() {
        return super.getConfiguration();
    }

    private void notifyReconnection() {
        for (ConnectionListener listener : this.getConnectionListeners()) {
            try {
                listener.reconnectionSuccessful();
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "notifyReconnection()", e);
            }
        }
    }
}

