/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.tcp.sm.predicates;

import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.tcp.XMPPTCPConnection;
import org.jivesoftware.smack.util.StringUtils;

public class OnceForThisStanza
implements PacketFilter {
    private final String id;
    private final XMPPTCPConnection connection;

    public static void setup(XMPPTCPConnection connection, Packet packet) {
        OnceForThisStanza packetFilter = new OnceForThisStanza(connection, packet);
        connection.addRequestAckPredicate(packetFilter);
    }

    private OnceForThisStanza(XMPPTCPConnection connection, Packet packet) {
        this.connection = connection;
        this.id = packet.getPacketID();
        if (StringUtils.isNullOrEmpty((CharSequence)this.id)) {
            throw new IllegalArgumentException("Stanza ID must be set");
        }
    }

    public boolean accept(Packet packet) {
        String otherId = packet.getPacketID();
        if (StringUtils.isNullOrEmpty((CharSequence)otherId)) {
            return false;
        }
        if (this.id.equals(otherId)) {
            this.connection.removeRequestAckPredicate(this);
            return true;
        }
        return false;
    }
}

