/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.tcp;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.SynchronizationPoint;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.compress.packet.Compress;
import org.jivesoftware.smack.compression.XMPPInputOutputStream;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Element;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PlainStreamElement;
import org.jivesoftware.smack.packet.StartTls;
import org.jivesoftware.smack.packet.StreamOpen;
import org.jivesoftware.smack.packet.TopLevelStreamElement;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.parsing.ParsingExceptionCallback;
import org.jivesoftware.smack.parsing.UnparsablePacket;
import org.jivesoftware.smack.sasl.packet.SaslStreamElements;
import org.jivesoftware.smack.tcp.sm.SMUtils;
import org.jivesoftware.smack.tcp.sm.StreamManagementException;
import org.jivesoftware.smack.tcp.sm.packet.StreamManagement;
import org.jivesoftware.smack.tcp.sm.predicates.Predicate;
import org.jivesoftware.smack.tcp.sm.provider.ParseStreamManagement;
import org.jivesoftware.smack.util.ArrayBlockingQueueWithShutdown;
import org.jivesoftware.smack.util.Async;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.TLSUtils;
import org.jivesoftware.smack.util.dns.HostAddress;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class XMPPTCPConnection
extends AbstractXMPPConnection {
    private static final int QUEUE_SIZE = 500;
    private static final Logger LOGGER = Logger.getLogger(XMPPTCPConnection.class.getName());
    private Socket socket;
    private String connectionID = null;
    private boolean disconnectedButResumeable = false;
    private volatile boolean socketClosed = false;
    private boolean usingTLS = false;
    private ParsingExceptionCallback parsingExceptionCallback = SmackConfiguration.getDefaultParsingExceptionCallback();
    protected PacketWriter packetWriter;
    protected PacketReader packetReader;
    private final SynchronizationPoint<Exception> initalOpenStreamSend = new SynchronizationPoint((AbstractXMPPConnection)this);
    private final SynchronizationPoint<XMPPException> maybeCompressFeaturesReceived = new SynchronizationPoint((AbstractXMPPConnection)this);
    private final SynchronizationPoint<XMPPException> compressSyncPoint = new SynchronizationPoint((AbstractXMPPConnection)this);
    private static boolean useSmDefault = false;
    private static boolean useSmResumptionDefault = true;
    private String smSessionId;
    private final SynchronizationPoint<XMPPException> smResumedSyncPoint = new SynchronizationPoint((AbstractXMPPConnection)this);
    private final SynchronizationPoint<XMPPException> smEnabledSyncPoint = new SynchronizationPoint((AbstractXMPPConnection)this);
    private int smClientMaxResumptionTime = -1;
    private int smServerMaxResumptimTime = -1;
    private boolean useSm = useSmDefault;
    private boolean useSmResumption = useSmResumptionDefault;
    private long serverHandledStanzasCount = 0L;
    private long clientHandledStanzasCount = 0L;
    private BlockingQueue<Packet> unacknowledgedStanzas;
    private boolean smWasEnabledAtLeastOnce = false;
    private final Collection<PacketListener> stanzaAcknowledgedListeners = new ConcurrentLinkedQueue<PacketListener>();
    private final Map<String, PacketListener> stanzaIdAcknowledgedListeners = new ConcurrentHashMap<String, PacketListener>();
    private final Set<PacketFilter> requestAckPredicates = new LinkedHashSet<PacketFilter>();

    public XMPPTCPConnection(String serviceName, CallbackHandler callbackHandler) {
        super(new ConnectionConfiguration(serviceName));
        this.config.setCallbackHandler(callbackHandler);
    }

    public XMPPTCPConnection(String serviceName) {
        super(new ConnectionConfiguration(serviceName));
    }

    public XMPPTCPConnection(ConnectionConfiguration config) {
        super(config);
    }

    public XMPPTCPConnection(ConnectionConfiguration config, CallbackHandler callbackHandler) {
        super(config);
        config.setCallbackHandler(callbackHandler);
    }

    public String getConnectionID() {
        if (!this.isConnected()) {
            return null;
        }
        return this.connectionID;
    }

    public void setParsingExceptionCallback(ParsingExceptionCallback callback) {
        this.parsingExceptionCallback = callback;
    }

    public ParsingExceptionCallback getParsingExceptionCallback() {
        return this.parsingExceptionCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void login(String username, String password, String resource) throws XMPPException, SmackException, IOException {
        if (!this.isConnected()) {
            throw new SmackException.NotConnectedException();
        }
        if (this.authenticated && !this.disconnectedButResumeable) {
            throw new SmackException.AlreadyLoggedInException();
        }
        if (username != null) {
            username = username.toLowerCase(Locale.US).trim();
        }
        if (this.saslAuthentication.hasNonAnonymousAuthentication()) {
            if (password != null) {
                this.saslAuthentication.authenticate(username, password, resource);
            } else {
                this.saslAuthentication.authenticate(resource, this.config.getCallbackHandler());
            }
        } else {
            throw new SmackException("No non-anonymous SASL authentication mechanism available");
        }
        if (this.config.isCompressionEnabled()) {
            this.useCompression();
        }
        if (this.isSmResumptionPossible()) {
            this.smResumedSyncPoint.sendAndWaitForResponse((TopLevelStreamElement)new StreamManagement.Resume(this.clientHandledStanzasCount, this.smSessionId));
            if (this.smResumedSyncPoint.wasSuccessful()) {
                this.afterSuccessfulLogin(false, true);
                return;
            }
            LOGGER.fine("Stream resumption failed, continuing with normal stream establishment process");
        }
        this.bindResourceAndEstablishSession(resource);
        LinkedList previouslyUnackedStanzas = new LinkedList();
        if (this.unacknowledgedStanzas != null) {
            this.unacknowledgedStanzas.drainTo(previouslyUnackedStanzas);
        }
        if (this.isSmAvailable() && this.useSm) {
            this.unacknowledgedStanzas = new ArrayBlockingQueue<Packet>(500);
            this.clientHandledStanzasCount = 0L;
            this.serverHandledStanzasCount = 0L;
            this.smEnabledSyncPoint.sendAndWaitForResponseOrThrow((PlainStreamElement)new StreamManagement.Enable(this.useSmResumption, this.smClientMaxResumptionTime));
            Set<PacketFilter> set = this.requestAckPredicates;
            synchronized (set) {
                if (this.requestAckPredicates.isEmpty()) {
                    this.requestAckPredicates.add(Predicate.forMessagesOrAfter5Stanzas());
                }
            }
        }
        for (Packet stanza : previouslyUnackedStanzas) {
            this.sendPacketInternal(stanza);
        }
        this.setLoginInfo(username, password, resource);
        this.afterSuccessfulLogin(false, false);
    }

    public synchronized void loginAnonymously() throws XMPPException, SmackException, IOException {
        if (!this.isConnected()) {
            throw new SmackException.NotConnectedException();
        }
        if (this.authenticated) {
            throw new SmackException.AlreadyLoggedInException();
        }
        this.saslFeatureReceived.checkIfSuccessOrWaitOrThrow();
        if (!this.saslAuthentication.hasAnonymousAuthentication()) {
            throw new SmackException("No anonymous SASL authentication mechanism available");
        }
        this.saslAuthentication.authenticateAnonymously();
        if (this.config.isCompressionEnabled()) {
            this.useCompression();
        }
        this.bindResourceAndEstablishSession(null);
        this.afterSuccessfulLogin(true, false);
    }

    public boolean isSecureConnection() {
        return this.usingTLS;
    }

    public boolean isSocketClosed() {
        return this.socketClosed;
    }

    protected void shutdown() {
        if (this.isSmEnabled()) {
            try {
                this.sendSmAcknowledgementInternal();
            }
            catch (SmackException.NotConnectedException e) {
                LOGGER.log(Level.FINE, "Can not send final SM ack as connection is not connected", e);
            }
        }
        this.shutdown(false);
    }

    public void instantShutdown() {
        this.shutdown(true);
    }

    private void shutdown(boolean instant) {
        if (this.packetReader != null) {
            this.packetReader.shutdown();
        }
        if (this.packetWriter != null) {
            this.packetWriter.shutdown(instant);
        }
        this.socketClosed = true;
        try {
            this.socket.close();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "shutdown", e);
        }
        this.setWasAuthenticated(this.authenticated);
        if (this.isSmResumptionPossible() && instant) {
            this.disconnectedButResumeable = true;
        } else {
            this.authenticated = false;
            this.connected = false;
            this.usingTLS = false;
            this.disconnectedButResumeable = false;
        }
        this.reader = null;
        this.writer = null;
        this.maybeCompressFeaturesReceived.init();
        this.compressSyncPoint.init();
        this.smResumedSyncPoint.init();
        this.smEnabledSyncPoint.init();
        this.initalOpenStreamSend.init();
    }

    public void send(PlainStreamElement element) throws SmackException.NotConnectedException {
        this.packetWriter.sendStreamElement((Element)element);
    }

    protected void sendPacketInternal(Packet packet) throws SmackException.NotConnectedException {
        this.packetWriter.sendStreamElement((Element)packet);
        if (this.isSmEnabled()) {
            for (PacketFilter requestAckPredicate : this.requestAckPredicates) {
                if (!requestAckPredicate.accept(packet)) continue;
                this.requestSmAcknowledgementInternal();
                break;
            }
        }
    }

    private void connectUsingConfiguration(ConnectionConfiguration config) throws SmackException, IOException {
        try {
            this.maybeResolveDns();
        }
        catch (Exception e) {
            throw new SmackException((Throwable)e);
        }
        Iterator it = config.getHostAddresses().iterator();
        LinkedList<HostAddress> failedAddresses = new LinkedList<HostAddress>();
        while (it.hasNext()) {
            Exception exception = null;
            HostAddress hostAddress = (HostAddress)it.next();
            String host = hostAddress.getFQDN();
            int port = hostAddress.getPort();
            try {
                this.socket = config.getSocketFactory() == null ? new Socket(host, port) : config.getSocketFactory().createSocket(host, port);
            }
            catch (Exception e) {
                exception = e;
            }
            if (exception == null) {
                this.host = host;
                this.port = port;
                break;
            }
            hostAddress.setException(exception);
            failedAddresses.add(hostAddress);
            if (it.hasNext()) continue;
            throw SmackException.ConnectionException.from(failedAddresses);
        }
        this.socketClosed = false;
        this.initConnection();
    }

    private void initConnection() throws SmackException, IOException {
        boolean isFirstInitialization = this.packetReader == null || this.packetWriter == null;
        this.compressionHandler = null;
        this.initReaderAndWriter();
        try {
            if (isFirstInitialization) {
                this.packetWriter = new PacketWriter();
                this.packetReader = new PacketReader();
                if (this.config.isDebuggerEnabled()) {
                    this.addPacketListener(this.debugger.getReaderListener(), null);
                    if (this.debugger.getWriterListener() != null) {
                        this.addPacketSendingListener(this.debugger.getWriterListener(), null);
                    }
                }
            }
            this.packetWriter.init();
            this.packetReader.init();
            if (isFirstInitialization) {
                for (ConnectionCreationListener listener : XMPPTCPConnection.getConnectionCreationListeners()) {
                    listener.connectionCreated((XMPPConnection)this);
                }
            }
        }
        catch (SmackException ex) {
            this.instantShutdown();
            throw ex;
        }
    }

    private void initReaderAndWriter() throws IOException, SmackException {
        try {
            InputStream is = this.socket.getInputStream();
            OutputStream os = this.socket.getOutputStream();
            if (this.compressionHandler != null) {
                is = this.compressionHandler.getInputStream(is);
                os = this.compressionHandler.getOutputStream(os);
            }
            this.writer = new OutputStreamWriter(os, "UTF-8");
            this.reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SmackException((Throwable)e);
        }
        this.initDebugger();
    }

    private void proceedTLSReceived() throws NoSuchAlgorithmException, CertificateException, IOException, KeyStoreException, NoSuchProviderException, UnrecoverableKeyException, KeyManagementException, SmackException {
        SSLContext context = this.config.getCustomSSLContext();
        KeyStore ks = null;
        KeyManager[] kms = null;
        PasswordCallback pcb = null;
        if (this.config.getCallbackHandler() == null) {
            ks = null;
        } else if (context == null) {
            if (this.config.getKeystoreType().equals("NONE")) {
                ks = null;
                pcb = null;
            } else if (this.config.getKeystoreType().equals("PKCS11")) {
                try {
                    Constructor<?> c = Class.forName("sun.security.pkcs11.SunPKCS11").getConstructor(InputStream.class);
                    String pkcs11Config = "name = SmartCard\nlibrary = " + this.config.getPKCS11Library();
                    ByteArrayInputStream config = new ByteArrayInputStream(pkcs11Config.getBytes());
                    Provider p = (Provider)c.newInstance(config);
                    Security.addProvider(p);
                    ks = KeyStore.getInstance("PKCS11", p);
                    pcb = new PasswordCallback("PKCS11 Password: ", false);
                    this.config.getCallbackHandler().handle(new Callback[]{pcb});
                    ks.load(null, pcb.getPassword());
                }
                catch (Exception e) {
                    ks = null;
                    pcb = null;
                }
            } else if (this.config.getKeystoreType().equals("Apple")) {
                ks = KeyStore.getInstance("KeychainStore", "Apple");
                ks.load(null, null);
            } else {
                ks = KeyStore.getInstance(this.config.getKeystoreType());
                try {
                    pcb = new PasswordCallback("Keystore Password: ", false);
                    this.config.getCallbackHandler().handle(new Callback[]{pcb});
                    ks.load(new FileInputStream(this.config.getKeystorePath()), pcb.getPassword());
                }
                catch (Exception e) {
                    ks = null;
                    pcb = null;
                }
            }
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            try {
                if (pcb == null) {
                    kmf.init(ks, null);
                } else {
                    kmf.init(ks, pcb.getPassword());
                    pcb.clearPassword();
                }
                kms = kmf.getKeyManagers();
            }
            catch (NullPointerException npe) {
                kms = null;
            }
        }
        if (context == null) {
            context = SSLContext.getInstance("TLS");
            context.init(kms, null, new SecureRandom());
        }
        Socket plain = this.socket;
        this.socket = context.getSocketFactory().createSocket(plain, plain.getInetAddress().getHostAddress(), plain.getPort(), true);
        this.initReaderAndWriter();
        SSLSocket sslSocket = (SSLSocket)this.socket;
        TLSUtils.setEnabledProtocolsAndCiphers((SSLSocket)sslSocket, (String[])this.config.getEnabledSSLProtocols(), (String[])this.config.getEnabledSSLCiphers());
        sslSocket.startHandshake();
        HostnameVerifier verifier = this.getConfiguration().getHostnameVerifier();
        if (verifier == null) {
            throw new IllegalStateException("No HostnameVerifier set. Use connectionConfiguration.setHostnameVerifier() to configure.");
        }
        if (!verifier.verify(this.getServiceName(), sslSocket.getSession())) {
            throw new CertificateException("Hostname verification of certificate failed. Certificate does not authenticate " + this.getServiceName());
        }
        this.usingTLS = true;
    }

    private XMPPInputOutputStream maybeGetCompressionHandler() {
        Compress.Feature compression = (Compress.Feature)this.getFeature("compression", "http://jabber.org/protocol/compress");
        if (compression == null) {
            return null;
        }
        for (XMPPInputOutputStream handler : SmackConfiguration.getCompresionHandlers()) {
            String method = handler.getCompressionMethod();
            if (!compression.getMethods().contains(method)) continue;
            return handler;
        }
        return null;
    }

    public boolean isUsingCompression() {
        return this.compressionHandler != null && this.compressSyncPoint.wasSuccessful();
    }

    private void useCompression() throws SmackException.NotConnectedException, SmackException.NoResponseException, XMPPException {
        this.maybeCompressFeaturesReceived.checkIfSuccessOrWait();
        this.compressionHandler = this.maybeGetCompressionHandler();
        if (this.compressionHandler != null) {
            this.compressSyncPoint.sendAndWaitForResponseOrThrow((PlainStreamElement)new Compress(this.compressionHandler.getCompressionMethod()));
        } else {
            LOGGER.warning("Could not enable compression because no matching handler/method pair was found");
        }
    }

    protected void connectInternal() throws SmackException, IOException, XMPPException {
        if (this.connected && !this.disconnectedButResumeable) {
            throw new SmackException.AlreadyConnectedException();
        }
        this.connectUsingConfiguration(this.config);
        this.saslFeatureReceived.checkIfSuccessOrWaitOrThrow();
        this.connected = true;
        this.callConnectionConnectedListener();
        if (this.wasAuthenticated) {
            if (this.isAnonymous()) {
                this.loginAnonymously();
            } else {
                this.login(this.config.getUsername(), this.config.getPassword(), this.config.getResource());
            }
            this.notifyReconnection();
        }
    }

    private synchronized void notifyConnectionError(Exception e) {
        if ((this.packetReader == null || this.packetReader.done) && (this.packetWriter == null || this.packetWriter.done())) {
            return;
        }
        this.instantShutdown();
        this.callConnectionClosedOnErrorListener(e);
    }

    private void notifyReconnection() {
        for (ConnectionListener listener : this.getConnectionListeners()) {
            try {
                listener.reconnectionSuccessful();
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "notifyReconnection()", e);
            }
        }
    }

    protected void setWriter(Writer writer) {
        this.writer = writer;
    }

    protected void afterFeaturesReceived() throws SmackException.SecurityRequiredException, SmackException.NotConnectedException {
        StartTls startTlsFeature = (StartTls)this.getFeature("starttls", "urn:ietf:params:xml:ns:xmpp-tls");
        if (startTlsFeature != null) {
            if (startTlsFeature.required() && this.config.getSecurityMode() == ConnectionConfiguration.SecurityMode.disabled) {
                this.notifyConnectionError((Exception)new SmackException.SecurityRequiredByServerException());
                return;
            }
            if (this.config.getSecurityMode() == ConnectionConfiguration.SecurityMode.disabled) {
                return;
            }
            this.send((PlainStreamElement)new StartTls());
        }
        if (!this.isSecureConnection() && startTlsFeature == null && this.getConfiguration().getSecurityMode() == ConnectionConfiguration.SecurityMode.required) {
            throw new SmackException.SecurityRequiredByClientException();
        }
        if (this.getSASLAuthentication().authenticationSuccessful()) {
            this.maybeCompressFeaturesReceived.reportSuccess();
        }
    }

    void openStream() throws SmackException {
        this.send((PlainStreamElement)new StreamOpen(this.getServiceName()));
        try {
            this.packetReader.parser = PacketParserUtils.newXmppParser((Reader)this.reader);
        }
        catch (XmlPullParserException e) {
            throw new SmackException((Throwable)e);
        }
    }

    public static void setUseStreamManagementDefault(boolean useSmDefault) {
        XMPPTCPConnection.useSmDefault = useSmDefault;
    }

    public static void setUseStreamManagementResumptiodDefault(boolean useSmResumptionDefault) {
        if (useSmResumptionDefault) {
            XMPPTCPConnection.setUseStreamManagementDefault(useSmResumptionDefault);
        }
        XMPPTCPConnection.useSmResumptionDefault = useSmResumptionDefault;
    }

    public void setUseStreamManagement(boolean useSm) {
        this.useSm = useSm;
    }

    public void setUseStreamManagementResumption(boolean useSmResumption) {
        if (useSmResumption) {
            this.setUseStreamManagement(useSmResumption);
        }
        this.useSmResumption = useSmResumption;
    }

    public void setPreferredResumptionTime(int resumptionTime) {
        this.smClientMaxResumptionTime = resumptionTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addRequestAckPredicate(PacketFilter predicate) {
        Set<PacketFilter> set = this.requestAckPredicates;
        synchronized (set) {
            return this.requestAckPredicates.add(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeRequestAckPredicate(PacketFilter predicate) {
        Set<PacketFilter> set = this.requestAckPredicates;
        synchronized (set) {
            return this.requestAckPredicates.remove(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllRequestAckPredicates() {
        Set<PacketFilter> set = this.requestAckPredicates;
        synchronized (set) {
            this.requestAckPredicates.clear();
        }
    }

    public void requestSmAcknowledgement() throws StreamManagementException.StreamManagementNotEnabledException, SmackException.NotConnectedException {
        if (!this.isSmEnabled()) {
            throw new StreamManagementException.StreamManagementNotEnabledException();
        }
        this.requestSmAcknowledgementInternal();
    }

    private void requestSmAcknowledgementInternal() throws SmackException.NotConnectedException {
        this.packetWriter.sendStreamElement((Element)StreamManagement.AckRequest.INSTANCE);
    }

    public void sendSmAcknowledgement() throws StreamManagementException.StreamManagementNotEnabledException, SmackException.NotConnectedException {
        if (!this.isSmEnabled()) {
            throw new StreamManagementException.StreamManagementNotEnabledException();
        }
        this.sendSmAcknowledgementInternal();
    }

    private void sendSmAcknowledgementInternal() throws SmackException.NotConnectedException {
        this.packetWriter.sendStreamElement((Element)new StreamManagement.AckAnswer(this.clientHandledStanzasCount));
    }

    public void addStanzaAcknowledgedListener(PacketListener listener) throws StreamManagementException.StreamManagementNotEnabledException {
        if (!this.smWasEnabledAtLeastOnce) {
            throw new StreamManagementException.StreamManagementNotEnabledException();
        }
        this.stanzaAcknowledgedListeners.add(listener);
    }

    public boolean removeStanzaAcknowledgedListener(PacketListener listener) {
        return this.stanzaAcknowledgedListeners.remove(listener);
    }

    public void removeAllStanzaAcknowledgedListeners() {
        this.stanzaAcknowledgedListeners.clear();
    }

    public PacketListener addStanzaIdAcknowledgedListener(String id, PacketListener listener) throws StreamManagementException.StreamManagementNotEnabledException {
        if (!this.smWasEnabledAtLeastOnce) {
            throw new StreamManagementException.StreamManagementNotEnabledException();
        }
        return this.stanzaIdAcknowledgedListeners.put(id, listener);
    }

    public PacketListener removeStanzaIdAcknowledgedListener(String id) {
        return this.stanzaIdAcknowledgedListeners.remove(id);
    }

    public void removeAllStanzaIdAcknowledgedListeners() {
        this.stanzaIdAcknowledgedListeners.clear();
    }

    public boolean isSmAvailable() {
        return this.hasFeature("sm", "urn:xmpp:sm:3");
    }

    public boolean isSmEnabled() {
        return this.smEnabledSyncPoint.wasSuccessful();
    }

    public boolean isDisconnectedButSmResumptionPossible() {
        return this.disconnectedButResumeable && this.isSmResumptionPossible();
    }

    public boolean isSmResumptionPossible() {
        if (this.smSessionId == null) {
            return false;
        }
        Long shutdownTimestamp = this.packetWriter.shutdownTimestamp;
        if (shutdownTimestamp == null) {
            return true;
        }
        long current = System.currentTimeMillis();
        int clientResumptionTime = this.smClientMaxResumptionTime > 0 ? this.smClientMaxResumptionTime : Integer.MAX_VALUE;
        int serverResumptionTime = this.smServerMaxResumptimTime > 0 ? this.smServerMaxResumptimTime : Integer.MAX_VALUE;
        long maxResumptionMillies = Math.max(clientResumptionTime, serverResumptionTime) * 1000;
        return shutdownTimestamp + maxResumptionMillies <= current;
    }

    private void processHandledCount(long handledCount) throws SmackException.NotConnectedException {
        long ackedStanzasCount = SMUtils.calculateDelta(handledCount, this.serverHandledStanzasCount);
        final ArrayList<Packet> ackedStanzas = new ArrayList<Packet>(handledCount <= Integer.MAX_VALUE ? (int)handledCount : Integer.MAX_VALUE);
        for (long i = 0L; i < ackedStanzasCount; ++i) {
            Packet ackedStanza = (Packet)this.unacknowledgedStanzas.poll();
            assert (ackedStanza != null);
            ackedStanzas.add(ackedStanza);
        }
        boolean atLeastOneStanzaIdAcknowledgedListener = false;
        for (Packet ackedStanza : ackedStanzas) {
            String id = ackedStanza.getPacketID();
            if (id == null || !this.stanzaAcknowledgedListeners.contains(id)) continue;
            atLeastOneStanzaIdAcknowledgedListener = true;
            break;
        }
        if (atLeastOneStanzaIdAcknowledgedListener || !this.stanzaAcknowledgedListeners.isEmpty()) {
            Async.go((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        for (Packet ackedStanza : ackedStanzas) {
                            PacketListener listener2;
                            for (PacketListener listener2 : XMPPTCPConnection.this.stanzaAcknowledgedListeners) {
                                listener2.processPacket(ackedStanza);
                            }
                            String id = ackedStanza.getPacketID();
                            if (id == null || (listener2 = (PacketListener)XMPPTCPConnection.this.stanzaIdAcknowledgedListeners.remove(id)) == null) continue;
                            listener2.processPacket(ackedStanza);
                        }
                    }
                    catch (SmackException.NotConnectedException e) {
                        LOGGER.log(Level.FINER, "Received not connected exception, aborting", e);
                    }
                }
            }, (String)("Stanza Acknowledged Listener Executor Thread " + handledCount + " (" + this.getConnectionCounter() + ')'));
        }
        this.serverHandledStanzasCount = handledCount;
    }

    protected class PacketWriter {
        public static final int QUEUE_SIZE = 500;
        private final ArrayBlockingQueueWithShutdown<Element> queue = new ArrayBlockingQueueWithShutdown(500, true);
        private Thread writerThread;
        protected SynchronizationPoint<SmackException.NoResponseException> shutdownDone = new SynchronizationPoint((AbstractXMPPConnection)XMPPTCPConnection.this);
        protected volatile Long shutdownTimestamp = null;
        private volatile boolean instantShutdown;

        protected PacketWriter() {
        }

        void init() {
            this.shutdownDone.init();
            this.shutdownTimestamp = null;
            if (XMPPTCPConnection.this.unacknowledgedStanzas != null) {
                this.drainWriterQueueToUnacknowledgedStanzas();
            }
            this.queue.start();
            this.writerThread = new Thread(){

                @Override
                public void run() {
                    PacketWriter.this.writePackets();
                }
            };
            this.writerThread.setName("Smack Packet Writer (" + XMPPTCPConnection.this.getConnectionCounter() + ")");
            this.writerThread.setDaemon(true);
            this.writerThread.start();
        }

        private boolean done() {
            return this.shutdownTimestamp != null;
        }

        private void throwNotConnectedExceptionIfDoneAndResumptionNotPossible() throws SmackException.NotConnectedException {
            if (this.done() && !XMPPTCPConnection.this.isSmResumptionPossible()) {
                throw new SmackException.NotConnectedException();
            }
        }

        protected void sendStreamElement(Element element) throws SmackException.NotConnectedException {
            this.throwNotConnectedExceptionIfDoneAndResumptionNotPossible();
            boolean enqueued = false;
            while (!enqueued) {
                try {
                    this.queue.put((Object)element);
                    enqueued = true;
                }
                catch (InterruptedException e) {
                    this.throwNotConnectedExceptionIfDoneAndResumptionNotPossible();
                    LOGGER.log(Level.FINE, "Spurious interrupt", e);
                }
            }
        }

        void shutdown(boolean instant) {
            this.instantShutdown = instant;
            this.shutdownTimestamp = System.currentTimeMillis();
            this.queue.shutdown();
            try {
                this.shutdownDone.checkIfSuccessOrWait();
            }
            catch (SmackException.NoResponseException e) {
                LOGGER.log(Level.WARNING, "NoResponseException", e);
            }
        }

        private Element nextStreamElement() {
            Element packet;
            block2: {
                packet = null;
                try {
                    packet = (Element)this.queue.take();
                }
                catch (InterruptedException e) {
                    if (this.queue.isShutdown()) break block2;
                    LOGGER.log(Level.FINER, "Spurious interrupt", e);
                }
            }
            return packet;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writePackets() {
            try {
                XMPPTCPConnection.this.openStream();
                XMPPTCPConnection.this.initalOpenStreamSend.reportSuccess();
                while (!this.done()) {
                    Element element = this.nextStreamElement();
                    if (element == null) continue;
                    Packet packet = null;
                    if (element instanceof Packet) {
                        packet = (Packet)element;
                    }
                    if (XMPPTCPConnection.this.isSmEnabled() && packet != null) {
                        if ((double)XMPPTCPConnection.this.unacknowledgedStanzas.size() == 400.0) {
                            XMPPTCPConnection.this.writer.write(StreamManagement.AckRequest.INSTANCE.toXML().toString());
                            XMPPTCPConnection.this.writer.flush();
                        }
                        try {
                            XMPPTCPConnection.this.unacknowledgedStanzas.put(packet);
                        }
                        catch (InterruptedException e) {
                            throw new IllegalStateException(e);
                        }
                    }
                    XMPPTCPConnection.this.writer.write(element.toXML().toString());
                    if (this.queue.isEmpty()) {
                        XMPPTCPConnection.this.writer.flush();
                    }
                    if (packet == null) continue;
                    XMPPTCPConnection.this.firePacketSendingListeners(packet);
                }
                if (!this.instantShutdown) {
                    try {
                        while (!this.queue.isEmpty()) {
                            Element packet = (Element)this.queue.remove();
                            XMPPTCPConnection.this.writer.write(packet.toXML().toString());
                        }
                        XMPPTCPConnection.this.writer.flush();
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.WARNING, "Exception flushing queue during shutdown, ignore and continue", e);
                    }
                    try {
                        XMPPTCPConnection.this.writer.write("</stream:stream>");
                        XMPPTCPConnection.this.writer.flush();
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.WARNING, "Exception writing closing stream element", e);
                    }
                    this.queue.clear();
                } else if (this.instantShutdown && XMPPTCPConnection.this.isSmEnabled()) {
                    this.drainWriterQueueToUnacknowledgedStanzas();
                }
                try {
                    XMPPTCPConnection.this.writer.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            catch (Exception e) {
                if (!this.done() && !XMPPTCPConnection.this.isSocketClosed()) {
                    XMPPTCPConnection.this.notifyConnectionError(e);
                } else {
                    LOGGER.log(Level.FINE, "Ignoring Exception in writePackets()", e);
                }
            }
            finally {
                this.shutdownDone.reportSuccess();
            }
        }

        private void drainWriterQueueToUnacknowledgedStanzas() {
            ArrayList elements = new ArrayList(this.queue.size());
            this.queue.drainTo(elements);
            for (Element element : elements) {
                if (!(element instanceof Packet)) continue;
                XMPPTCPConnection.this.unacknowledgedStanzas.add((Packet)element);
            }
        }
    }

    protected class PacketReader {
        private Thread readerThread;
        XmlPullParser parser;
        private volatile boolean done;

        protected PacketReader() {
        }

        void init() throws SmackException {
            this.done = false;
            this.readerThread = new Thread(){

                @Override
                public void run() {
                    PacketReader.this.parsePackets();
                }
            };
            this.readerThread.setName("Smack Packet Reader (" + XMPPTCPConnection.this.getConnectionCounter() + ")");
            this.readerThread.setDaemon(true);
            this.readerThread.start();
        }

        void shutdown() {
            this.done = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void parsePackets() {
            block70: {
                try {
                    XMPPTCPConnection.this.initalOpenStreamSend.checkIfSuccessOrWait();
                    int eventType = this.parser.getEventType();
                    block58: while (!this.done) {
                        block4 : switch (eventType) {
                            case 2: {
                                String name;
                                block27 : switch (name = this.parser.getName()) {
                                    case "message": 
                                    case "iq": 
                                    case "presence": {
                                        Packet packet;
                                        int parserDepth = this.parser.getDepth();
                                        try {
                                            packet = PacketParserUtils.parseStanza((XmlPullParser)this.parser, (XMPPConnection)XMPPTCPConnection.this);
                                        }
                                        catch (Exception e) {
                                            String callback = XMPPTCPConnection.this.getParsingExceptionCallback();
                                            CharSequence content = PacketParserUtils.parseContentDepth((XmlPullParser)this.parser, (int)parserDepth);
                                            UnparsablePacket message = new UnparsablePacket(content, e);
                                            if (callback != null) {
                                                callback.handleUnparsablePacket(message);
                                            }
                                            eventType = this.parser.next();
                                            continue block58;
                                        }
                                        finally {
                                            XMPPTCPConnection.this.clientHandledStanzasCount = SMUtils.incrementHeight(XMPPTCPConnection.this.clientHandledStanzasCount);
                                            XMPPTCPConnection.this.reportStanzaReceived();
                                            continue block58;
                                        }
                                        XMPPTCPConnection.this.processPacket(packet);
                                        break;
                                    }
                                    case "stream": {
                                        if (!"jabber:client".equals(this.parser.getNamespace(null))) break block4;
                                        for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
                                            if (this.parser.getAttributeName(i).equals("id")) {
                                                XMPPTCPConnection.this.connectionID = this.parser.getAttributeValue(i);
                                                continue;
                                            }
                                            if (!this.parser.getAttributeName(i).equals("from")) continue;
                                            XMPPTCPConnection.this.setServiceName(this.parser.getAttributeValue(i));
                                        }
                                        break block4;
                                    }
                                    case "error": {
                                        throw new XMPPException.StreamErrorException(PacketParserUtils.parseStreamError((XmlPullParser)this.parser));
                                    }
                                    case "features": {
                                        XMPPTCPConnection.this.parseFeatures(this.parser);
                                        break;
                                    }
                                    case "proceed": {
                                        try {
                                            XMPPTCPConnection.this.proceedTLSReceived();
                                            XMPPTCPConnection.this.openStream();
                                            break;
                                        }
                                        catch (Exception e) {
                                            XMPPTCPConnection.this.saslFeatureReceived.reportFailure((Exception)new SmackException((Throwable)e));
                                            throw e;
                                        }
                                    }
                                    case "failure": {
                                        String namespace;
                                        switch (namespace = this.parser.getNamespace(null)) {
                                            case "urn:ietf:params:xml:ns:xmpp-tls": {
                                                throw new XMPPException.XMPPErrorException("TLS negotiation has failed", null);
                                            }
                                            case "http://jabber.org/protocol/compress": {
                                                XMPPTCPConnection.this.compressSyncPoint.reportFailure((Exception)new XMPPException.XMPPErrorException("Could not establish compression", null));
                                                break block27;
                                            }
                                            case "urn:ietf:params:xml:ns:xmpp-sasl": {
                                                SaslStreamElements.SASLFailure failure = PacketParserUtils.parseSASLFailure((XmlPullParser)this.parser);
                                                XMPPTCPConnection.this.getSASLAuthentication().authenticationFailed(failure);
                                            }
                                        }
                                        break;
                                    }
                                    case "challenge": {
                                        String challengeData = this.parser.nextText();
                                        XMPPTCPConnection.this.getSASLAuthentication().challengeReceived(challengeData);
                                        break;
                                    }
                                    case "success": {
                                        SaslStreamElements.Success success = new SaslStreamElements.Success(this.parser.nextText());
                                        XMPPTCPConnection.this.openStream();
                                        XMPPTCPConnection.this.getSASLAuthentication().authenticated(success);
                                        break;
                                    }
                                    case "compressed": {
                                        XMPPTCPConnection.this.initReaderAndWriter();
                                        XMPPTCPConnection.this.openStream();
                                        XMPPTCPConnection.this.compressSyncPoint.reportSuccess();
                                        break;
                                    }
                                    case "enabled": {
                                        StreamManagement.Enabled enabled = ParseStreamManagement.enabled(this.parser);
                                        if (enabled.isResumeSet()) {
                                            XMPPTCPConnection.this.smSessionId = enabled.getId();
                                            if (StringUtils.isNullOrEmpty((CharSequence)XMPPTCPConnection.this.smSessionId)) {
                                                XMPPException.XMPPErrorException xmppException = new XMPPException.XMPPErrorException("Stream Management 'enabled' element with resume attribute but without session id received", new XMPPError(XMPPError.Condition.bad_request));
                                                XMPPTCPConnection.this.smEnabledSyncPoint.reportFailure((Exception)xmppException);
                                                throw xmppException;
                                            }
                                            XMPPTCPConnection.this.smServerMaxResumptimTime = enabled.getMaxResumptionTime();
                                        } else {
                                            XMPPTCPConnection.this.smSessionId = null;
                                        }
                                        XMPPTCPConnection.this.smEnabledSyncPoint.reportSuccess();
                                        XMPPTCPConnection.this.smWasEnabledAtLeastOnce = true;
                                        LOGGER.fine("Stream Management (XEP-198): succesfully enabled");
                                        break;
                                    }
                                    case "failed": {
                                        StreamManagement.Failed failed = ParseStreamManagement.failed(this.parser);
                                        XMPPError xmppError = failed.getXMPPError();
                                        XMPPException.XMPPErrorException xmppException = new XMPPException.XMPPErrorException("Stream Management failed", xmppError);
                                        if (XMPPTCPConnection.this.smResumedSyncPoint.requestSent()) {
                                            XMPPTCPConnection.this.smResumedSyncPoint.reportFailure((Exception)xmppException);
                                            break;
                                        }
                                        if (!XMPPTCPConnection.this.smEnabledSyncPoint.requestSent()) {
                                            throw new IllegalStateException("Failed element received but SM was not previously enabled");
                                        }
                                        XMPPTCPConnection.this.smEnabledSyncPoint.reportFailure((Exception)xmppException);
                                        XMPPTCPConnection.this.lastFeaturesReceived.reportSuccess();
                                        break;
                                    }
                                    case "resumed": {
                                        StreamManagement.Resumed resumed = ParseStreamManagement.resumed(this.parser);
                                        if (!XMPPTCPConnection.this.smSessionId.equals(resumed.getPrevId())) {
                                            throw new StreamManagementException.StreamIdDoesNotMatchException(XMPPTCPConnection.this.smSessionId, resumed.getPrevId());
                                        }
                                        XMPPTCPConnection.this.processHandledCount(resumed.getHandledCount());
                                        LinkedList stanzasToResend = new LinkedList();
                                        stanzasToResend.addAll(XMPPTCPConnection.this.unacknowledgedStanzas);
                                        for (Packet stanza : stanzasToResend) {
                                            XMPPTCPConnection.this.packetWriter.sendStreamElement((Element)stanza);
                                        }
                                        XMPPTCPConnection.this.smResumedSyncPoint.reportSuccess();
                                        XMPPTCPConnection.this.smEnabledSyncPoint.reportSuccess();
                                        LOGGER.fine("Stream Management (XEP-198): Stream resumed");
                                        break;
                                    }
                                    case "a": {
                                        StreamManagement.AckAnswer ackAnswer = ParseStreamManagement.ackAnswer(this.parser);
                                        XMPPTCPConnection.this.processHandledCount(ackAnswer.getHandledCount());
                                        break;
                                    }
                                    case "r": {
                                        ParseStreamManagement.ackRequest(this.parser);
                                        if (XMPPTCPConnection.this.smEnabledSyncPoint.wasSuccessful()) {
                                            XMPPTCPConnection.this.sendSmAcknowledgementInternal();
                                            break;
                                        }
                                        LOGGER.warning("SM Ack Request received while SM is not enabled");
                                        break;
                                    }
                                    default: {
                                        LOGGER.warning("Unkown top level stream element: " + name);
                                        break;
                                    }
                                }
                                break;
                            }
                            case 3: {
                                if (!this.parser.getName().equals("stream")) break;
                                XMPPTCPConnection.this.disconnect();
                                break;
                            }
                            case 1: {
                                LOGGER.warning("Got END_DOCUMENT, aborting parsing");
                                XMPPTCPConnection.this.disconnect();
                            }
                        }
                        eventType = this.parser.next();
                    }
                }
                catch (Exception e) {
                    if (this.done || XMPPTCPConnection.this.isSocketClosed()) break block70;
                    XMPPTCPConnection.this.notifyConnectionError(e);
                }
            }
        }
    }
}

