/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.tcp;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.PasswordCallback;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.SynchronizationPoint;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.compress.packet.Compress;
import org.jivesoftware.smack.compression.XMPPInputOutputStream;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Element;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PlainStreamElement;
import org.jivesoftware.smack.packet.StartTls;
import org.jivesoftware.smack.packet.StreamOpen;
import org.jivesoftware.smack.packet.TopLevelStreamElement;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.sasl.packet.SaslStreamElements;
import org.jivesoftware.smack.sm.SMUtils;
import org.jivesoftware.smack.sm.StreamManagementException;
import org.jivesoftware.smack.sm.packet.StreamManagement;
import org.jivesoftware.smack.sm.predicates.Predicate;
import org.jivesoftware.smack.sm.provider.ParseStreamManagement;
import org.jivesoftware.smack.tcp.XMPPTCPConnectionConfiguration;
import org.jivesoftware.smack.util.ArrayBlockingQueueWithShutdown;
import org.jivesoftware.smack.util.Async;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.TLSUtils;
import org.jivesoftware.smack.util.dns.HostAddress;
import org.jxmpp.util.XmppStringUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class XMPPTCPConnection
extends AbstractXMPPConnection {
    private static final int QUEUE_SIZE = 500;
    private static final Logger LOGGER = Logger.getLogger(XMPPTCPConnection.class.getName());
    private Socket socket;
    private boolean disconnectedButResumeable = false;
    private volatile boolean socketClosed = false;
    private boolean usingTLS = false;
    protected PacketWriter packetWriter;
    protected PacketReader packetReader;
    private final SynchronizationPoint<Exception> initalOpenStreamSend = new SynchronizationPoint((AbstractXMPPConnection)this);
    private final SynchronizationPoint<XMPPException> maybeCompressFeaturesReceived = new SynchronizationPoint((AbstractXMPPConnection)this);
    private final SynchronizationPoint<XMPPException> compressSyncPoint = new SynchronizationPoint((AbstractXMPPConnection)this);
    private static boolean useSmDefault = false;
    private static boolean useSmResumptionDefault = true;
    private String smSessionId;
    private final SynchronizationPoint<XMPPException> smResumedSyncPoint = new SynchronizationPoint((AbstractXMPPConnection)this);
    private final SynchronizationPoint<XMPPException> smEnabledSyncPoint = new SynchronizationPoint((AbstractXMPPConnection)this);
    private int smClientMaxResumptionTime = -1;
    private int smServerMaxResumptimTime = -1;
    private boolean useSm = useSmDefault;
    private boolean useSmResumption = useSmResumptionDefault;
    private long serverHandledStanzasCount = 0L;
    private long clientHandledStanzasCount = 0L;
    private BlockingQueue<Packet> unacknowledgedStanzas;
    private boolean smWasEnabledAtLeastOnce = false;
    private final Collection<PacketListener> stanzaAcknowledgedListeners = new ConcurrentLinkedQueue<PacketListener>();
    private final Map<String, PacketListener> stanzaIdAcknowledgedListeners = new ConcurrentHashMap<String, PacketListener>();
    private final Set<PacketFilter> requestAckPredicates = new LinkedHashSet<PacketFilter>();
    private final XMPPTCPConnectionConfiguration config;

    public XMPPTCPConnection(XMPPTCPConnectionConfiguration config) {
        super((ConnectionConfiguration)config);
        this.config = config;
    }

    public XMPPTCPConnection(CharSequence username, String password, String serviceName) {
        this(((XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)XMPPTCPConnectionConfiguration.builder().setUsernameAndPassword(username, password)).setServiceName(serviceName)).build());
    }

    protected void throwNotConnectedExceptionIfAppropriate() throws SmackException.NotConnectedException {
        if (this.packetWriter == null) {
            throw new SmackException.NotConnectedException();
        }
        this.packetWriter.throwNotConnectedExceptionIfDoneAndResumptionNotPossible();
    }

    protected void throwAlreadyConnectedExceptionIfAppropriate() throws SmackException.AlreadyConnectedException {
        if (this.isConnected() && !this.disconnectedButResumeable) {
            throw new SmackException.AlreadyConnectedException();
        }
    }

    protected void throwAlreadyLoggedInExceptionIfAppropriate() throws SmackException.AlreadyLoggedInException {
        if (this.isAuthenticated() && !this.disconnectedButResumeable) {
            throw new SmackException.AlreadyLoggedInException();
        }
    }

    protected void afterSuccessfulLogin(boolean resumed) throws SmackException.NotConnectedException {
        this.disconnectedButResumeable = false;
        super.afterSuccessfulLogin(resumed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void loginNonAnonymously(String username, String password, String resource) throws XMPPException, SmackException, IOException {
        if (this.saslAuthentication.hasNonAnonymousAuthentication()) {
            if (password != null) {
                this.saslAuthentication.authenticate(username, password, resource);
            } else {
                this.saslAuthentication.authenticate(resource, this.config.getCallbackHandler());
            }
        } else {
            throw new SmackException("No non-anonymous SASL authentication mechanism available");
        }
        if (this.config.isCompressionEnabled()) {
            this.useCompression();
        }
        if (this.isSmResumptionPossible()) {
            this.smResumedSyncPoint.sendAndWaitForResponse((TopLevelStreamElement)new StreamManagement.Resume(this.clientHandledStanzasCount, this.smSessionId));
            if (this.smResumedSyncPoint.wasSuccessful()) {
                this.afterSuccessfulLogin(true);
                return;
            }
            LOGGER.fine("Stream resumption failed, continuing with normal stream establishment process");
        }
        this.bindResourceAndEstablishSession(resource);
        LinkedList previouslyUnackedStanzas = new LinkedList();
        if (this.unacknowledgedStanzas != null) {
            this.unacknowledgedStanzas.drainTo(previouslyUnackedStanzas);
        }
        if (this.isSmAvailable() && this.useSm) {
            this.unacknowledgedStanzas = new ArrayBlockingQueue<Packet>(500);
            this.serverHandledStanzasCount = 0L;
            this.smEnabledSyncPoint.sendAndWaitForResponseOrThrow((PlainStreamElement)new StreamManagement.Enable(this.useSmResumption, this.smClientMaxResumptionTime));
            Set<PacketFilter> set = this.requestAckPredicates;
            synchronized (set) {
                if (this.requestAckPredicates.isEmpty()) {
                    this.requestAckPredicates.add(Predicate.forMessagesOrAfter5Stanzas());
                }
            }
        }
        for (Packet stanza : previouslyUnackedStanzas) {
            this.sendPacketInternal(stanza);
        }
        this.afterSuccessfulLogin(false);
    }

    public synchronized void loginAnonymously() throws XMPPException, SmackException, IOException {
        this.saslFeatureReceived.checkIfSuccessOrWaitOrThrow();
        if (!this.saslAuthentication.hasAnonymousAuthentication()) {
            throw new SmackException("No anonymous SASL authentication mechanism available");
        }
        this.saslAuthentication.authenticateAnonymously();
        if (this.config.isCompressionEnabled()) {
            this.useCompression();
        }
        this.bindResourceAndEstablishSession(null);
        this.afterSuccessfulLogin(false);
    }

    public boolean isSecureConnection() {
        return this.usingTLS;
    }

    public boolean isSocketClosed() {
        return this.socketClosed;
    }

    protected void shutdown() {
        if (this.isSmEnabled()) {
            try {
                this.sendSmAcknowledgementInternal();
            }
            catch (SmackException.NotConnectedException e) {
                LOGGER.log(Level.FINE, "Can not send final SM ack as connection is not connected", e);
            }
        }
        this.shutdown(false);
    }

    public synchronized void instantShutdown() {
        this.shutdown(true);
    }

    private void shutdown(boolean instant) {
        if (this.disconnectedButResumeable) {
            return;
        }
        if (this.packetReader != null) {
            this.packetReader.shutdown();
        }
        if (this.packetWriter != null) {
            this.packetWriter.shutdown(instant);
        }
        this.socketClosed = true;
        try {
            this.socket.close();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "shutdown", e);
        }
        this.setWasAuthenticated();
        this.disconnectedButResumeable = this.isSmResumptionPossible() && instant;
        this.authenticated = false;
        this.connected = false;
        this.usingTLS = false;
        this.reader = null;
        this.writer = null;
        this.maybeCompressFeaturesReceived.init();
        this.compressSyncPoint.init();
        this.smResumedSyncPoint.init();
        this.smEnabledSyncPoint.init();
        this.initalOpenStreamSend.init();
    }

    public void send(PlainStreamElement element) throws SmackException.NotConnectedException {
        this.packetWriter.sendStreamElement((Element)element);
    }

    protected void sendPacketInternal(Packet packet) throws SmackException.NotConnectedException {
        this.packetWriter.sendStreamElement((Element)packet);
        if (this.isSmEnabled()) {
            for (PacketFilter requestAckPredicate : this.requestAckPredicates) {
                if (!requestAckPredicate.accept(packet)) continue;
                this.requestSmAcknowledgementInternal();
                break;
            }
        }
    }

    private void connectUsingConfiguration() throws IOException, SmackException.ConnectionException {
        List failedAddresses = this.populateHostAddresses();
        SocketFactory socketFactory = this.config.getSocketFactory();
        if (socketFactory == null) {
            socketFactory = SocketFactory.getDefault();
        }
        for (HostAddress hostAddress : this.hostAddresses) {
            String host = hostAddress.getFQDN();
            int port = hostAddress.getPort();
            this.socket = socketFactory.createSocket();
            try {
                Iterator<InetAddress> inetAddresses = Arrays.asList(InetAddress.getAllByName(host)).iterator();
                if (!inetAddresses.hasNext()) {
                    LOGGER.warning("InetAddress.getAllByName() returned empty result array.");
                    throw new UnknownHostException(host);
                }
                while (inetAddresses.hasNext()) {
                    InetAddress inetAddress = inetAddresses.next();
                    String inetAddressAndPort = inetAddress + "at port " + port;
                    LOGGER.finer("Trying to establish TCP connection to " + inetAddressAndPort);
                    try {
                        this.socket.connect(new InetSocketAddress(inetAddress, port), this.config.getConnectTimeout());
                    }
                    catch (Exception e) {
                        if (inetAddresses.hasNext()) continue;
                        throw e;
                    }
                    LOGGER.finer("Established TCP connection to " + inetAddressAndPort);
                    this.host = host;
                    this.port = port;
                    return;
                }
            }
            catch (Exception e) {
                hostAddress.setException(e);
                failedAddresses.add(hostAddress);
            }
        }
        throw SmackException.ConnectionException.from((List)failedAddresses);
    }

    private void initConnection() throws IOException {
        boolean isFirstInitialization = this.packetReader == null || this.packetWriter == null;
        this.compressionHandler = null;
        this.initReaderAndWriter();
        if (isFirstInitialization) {
            this.packetWriter = new PacketWriter();
            this.packetReader = new PacketReader();
            if (this.config.isDebuggerEnabled()) {
                this.addAsyncPacketListener(this.debugger.getReaderListener(), null);
                if (this.debugger.getWriterListener() != null) {
                    this.addPacketSendingListener(this.debugger.getWriterListener(), null);
                }
            }
        }
        this.packetWriter.init();
        this.packetReader.init();
        if (isFirstInitialization) {
            for (ConnectionCreationListener listener : XMPPTCPConnection.getConnectionCreationListeners()) {
                listener.connectionCreated((XMPPConnection)this);
            }
        }
    }

    private void initReaderAndWriter() throws IOException {
        InputStream is = this.socket.getInputStream();
        OutputStream os = this.socket.getOutputStream();
        if (this.compressionHandler != null) {
            is = this.compressionHandler.getInputStream(is);
            os = this.compressionHandler.getOutputStream(os);
        }
        this.writer = new OutputStreamWriter(os, "UTF-8");
        this.reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        this.initDebugger();
    }

    private void proceedTLSReceived() throws NoSuchAlgorithmException, CertificateException, IOException, KeyStoreException, NoSuchProviderException, UnrecoverableKeyException, KeyManagementException, SmackException {
        SSLContext context = this.config.getCustomSSLContext();
        KeyStore ks = null;
        KeyManager[] kms = null;
        PasswordCallback pcb = null;
        if (this.config.getCallbackHandler() == null) {
            ks = null;
        } else if (context == null) {
            if (this.config.getKeystoreType().equals("NONE")) {
                ks = null;
                pcb = null;
            } else if (this.config.getKeystoreType().equals("PKCS11")) {
                try {
                    Constructor<?> c = Class.forName("sun.security.pkcs11.SunPKCS11").getConstructor(InputStream.class);
                    String pkcs11Config = "name = SmartCard\nlibrary = " + this.config.getPKCS11Library();
                    ByteArrayInputStream config = new ByteArrayInputStream(pkcs11Config.getBytes());
                    Provider p = (Provider)c.newInstance(config);
                    Security.addProvider(p);
                    ks = KeyStore.getInstance("PKCS11", p);
                    pcb = new PasswordCallback("PKCS11 Password: ", false);
                    this.config.getCallbackHandler().handle(new Callback[]{pcb});
                    ks.load(null, pcb.getPassword());
                }
                catch (Exception e) {
                    ks = null;
                    pcb = null;
                }
            } else if (this.config.getKeystoreType().equals("Apple")) {
                ks = KeyStore.getInstance("KeychainStore", "Apple");
                ks.load(null, null);
            } else {
                ks = KeyStore.getInstance(this.config.getKeystoreType());
                try {
                    pcb = new PasswordCallback("Keystore Password: ", false);
                    this.config.getCallbackHandler().handle(new Callback[]{pcb});
                    ks.load(new FileInputStream(this.config.getKeystorePath()), pcb.getPassword());
                }
                catch (Exception e) {
                    ks = null;
                    pcb = null;
                }
            }
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            try {
                if (pcb == null) {
                    kmf.init(ks, null);
                } else {
                    kmf.init(ks, pcb.getPassword());
                    pcb.clearPassword();
                }
                kms = kmf.getKeyManagers();
            }
            catch (NullPointerException npe) {
                kms = null;
            }
        }
        if (context == null) {
            context = SSLContext.getInstance("TLS");
            context.init(kms, null, new SecureRandom());
        }
        Socket plain = this.socket;
        this.socket = context.getSocketFactory().createSocket(plain, plain.getInetAddress().getHostAddress(), plain.getPort(), true);
        this.initReaderAndWriter();
        SSLSocket sslSocket = (SSLSocket)this.socket;
        TLSUtils.setEnabledProtocolsAndCiphers((SSLSocket)sslSocket, (String[])this.config.getEnabledSSLProtocols(), (String[])this.config.getEnabledSSLCiphers());
        sslSocket.startHandshake();
        HostnameVerifier verifier = this.getConfiguration().getHostnameVerifier();
        if (verifier == null) {
            throw new IllegalStateException("No HostnameVerifier set. Use connectionConfiguration.setHostnameVerifier() to configure.");
        }
        if (!verifier.verify(this.getServiceName(), sslSocket.getSession())) {
            throw new CertificateException("Hostname verification of certificate failed. Certificate does not authenticate " + this.getServiceName());
        }
        this.usingTLS = true;
    }

    private XMPPInputOutputStream maybeGetCompressionHandler() {
        Compress.Feature compression = (Compress.Feature)this.getFeature("compression", "http://jabber.org/protocol/compress");
        if (compression == null) {
            return null;
        }
        for (XMPPInputOutputStream handler : SmackConfiguration.getCompresionHandlers()) {
            String method = handler.getCompressionMethod();
            if (!compression.getMethods().contains(method)) continue;
            return handler;
        }
        return null;
    }

    public boolean isUsingCompression() {
        return this.compressionHandler != null && this.compressSyncPoint.wasSuccessful();
    }

    private void useCompression() throws SmackException.NotConnectedException, SmackException.NoResponseException, XMPPException {
        this.maybeCompressFeaturesReceived.checkIfSuccessOrWait();
        this.compressionHandler = this.maybeGetCompressionHandler();
        if (this.compressionHandler != null) {
            this.compressSyncPoint.sendAndWaitForResponseOrThrow((PlainStreamElement)new Compress(this.compressionHandler.getCompressionMethod()));
        } else {
            LOGGER.warning("Could not enable compression because no matching handler/method pair was found");
        }
    }

    protected void connectInternal() throws SmackException, IOException, XMPPException {
        this.connectUsingConfiguration();
        this.socketClosed = false;
        this.initConnection();
        this.saslFeatureReceived.checkIfSuccessOrWaitOrThrow();
        this.connected = true;
        this.callConnectionConnectedListener();
        if (this.wasAuthenticated) {
            this.login();
            this.notifyReconnection();
        }
    }

    private synchronized void notifyConnectionError(Exception e) {
        if ((this.packetReader == null || this.packetReader.done) && (this.packetWriter == null || this.packetWriter.done())) {
            return;
        }
        this.instantShutdown();
        this.callConnectionClosedOnErrorListener(e);
    }

    protected void setWriter(Writer writer) {
        this.writer = writer;
    }

    protected void afterFeaturesReceived() throws SmackException.SecurityRequiredException, SmackException.NotConnectedException {
        StartTls startTlsFeature = (StartTls)this.getFeature("starttls", "urn:ietf:params:xml:ns:xmpp-tls");
        if (startTlsFeature != null) {
            if (startTlsFeature.required() && this.config.getSecurityMode() == ConnectionConfiguration.SecurityMode.disabled) {
                this.notifyConnectionError((Exception)new SmackException.SecurityRequiredByServerException());
                return;
            }
            if (this.config.getSecurityMode() == ConnectionConfiguration.SecurityMode.disabled) {
                return;
            }
            this.send((PlainStreamElement)new StartTls());
        }
        if (!this.isSecureConnection() && startTlsFeature == null && this.getConfiguration().getSecurityMode() == ConnectionConfiguration.SecurityMode.required) {
            throw new SmackException.SecurityRequiredByClientException();
        }
        if (this.getSASLAuthentication().authenticationSuccessful()) {
            this.maybeCompressFeaturesReceived.reportSuccess();
        }
    }

    void openStream() throws SmackException {
        String to = this.getServiceName();
        String from = null;
        CharSequence localpart = this.config.getUsername();
        if (localpart != null) {
            from = XmppStringUtils.completeJidFrom((CharSequence)localpart, (CharSequence)to);
        }
        String id = this.getStreamId();
        this.send((PlainStreamElement)new StreamOpen((CharSequence)to, (CharSequence)from, id));
        try {
            this.packetReader.parser = PacketParserUtils.newXmppParser((Reader)this.reader);
        }
        catch (XmlPullParserException e) {
            throw new SmackException((Throwable)e);
        }
    }

    public static void setUseStreamManagementDefault(boolean useSmDefault) {
        XMPPTCPConnection.useSmDefault = useSmDefault;
    }

    public static void setUseStreamManagementResumptiodDefault(boolean useSmResumptionDefault) {
        if (useSmResumptionDefault) {
            XMPPTCPConnection.setUseStreamManagementDefault(useSmResumptionDefault);
        }
        XMPPTCPConnection.useSmResumptionDefault = useSmResumptionDefault;
    }

    public void setUseStreamManagement(boolean useSm) {
        this.useSm = useSm;
    }

    public void setUseStreamManagementResumption(boolean useSmResumption) {
        if (useSmResumption) {
            this.setUseStreamManagement(useSmResumption);
        }
        this.useSmResumption = useSmResumption;
    }

    public void setPreferredResumptionTime(int resumptionTime) {
        this.smClientMaxResumptionTime = resumptionTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addRequestAckPredicate(PacketFilter predicate) {
        Set<PacketFilter> set = this.requestAckPredicates;
        synchronized (set) {
            return this.requestAckPredicates.add(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeRequestAckPredicate(PacketFilter predicate) {
        Set<PacketFilter> set = this.requestAckPredicates;
        synchronized (set) {
            return this.requestAckPredicates.remove(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllRequestAckPredicates() {
        Set<PacketFilter> set = this.requestAckPredicates;
        synchronized (set) {
            this.requestAckPredicates.clear();
        }
    }

    public void requestSmAcknowledgement() throws StreamManagementException.StreamManagementNotEnabledException, SmackException.NotConnectedException {
        if (!this.isSmEnabled()) {
            throw new StreamManagementException.StreamManagementNotEnabledException();
        }
        this.requestSmAcknowledgementInternal();
    }

    private void requestSmAcknowledgementInternal() throws SmackException.NotConnectedException {
        this.packetWriter.sendStreamElement((Element)StreamManagement.AckRequest.INSTANCE);
    }

    public void sendSmAcknowledgement() throws StreamManagementException.StreamManagementNotEnabledException, SmackException.NotConnectedException {
        if (!this.isSmEnabled()) {
            throw new StreamManagementException.StreamManagementNotEnabledException();
        }
        this.sendSmAcknowledgementInternal();
    }

    private void sendSmAcknowledgementInternal() throws SmackException.NotConnectedException {
        this.packetWriter.sendStreamElement((Element)new StreamManagement.AckAnswer(this.clientHandledStanzasCount));
    }

    public void addStanzaAcknowledgedListener(PacketListener listener) {
        this.stanzaAcknowledgedListeners.add(listener);
    }

    public boolean removeStanzaAcknowledgedListener(PacketListener listener) {
        return this.stanzaAcknowledgedListeners.remove(listener);
    }

    public void removeAllStanzaAcknowledgedListeners() {
        this.stanzaAcknowledgedListeners.clear();
    }

    public PacketListener addStanzaIdAcknowledgedListener(final String id, PacketListener listener) throws StreamManagementException.StreamManagementNotEnabledException {
        if (!this.smWasEnabledAtLeastOnce) {
            throw new StreamManagementException.StreamManagementNotEnabledException();
        }
        int removeAfterSeconds = Math.min(this.getMaxSmResumptionTime() + 60, 43200);
        this.schedule(new Runnable(){

            @Override
            public void run() {
                XMPPTCPConnection.this.stanzaIdAcknowledgedListeners.remove(id);
            }
        }, removeAfterSeconds, TimeUnit.SECONDS);
        return this.stanzaIdAcknowledgedListeners.put(id, listener);
    }

    public PacketListener removeStanzaIdAcknowledgedListener(String id) {
        return this.stanzaIdAcknowledgedListeners.remove(id);
    }

    public void removeAllStanzaIdAcknowledgedListeners() {
        this.stanzaIdAcknowledgedListeners.clear();
    }

    public boolean isSmAvailable() {
        return this.hasFeature("sm", "urn:xmpp:sm:3");
    }

    public boolean isSmEnabled() {
        return this.smEnabledSyncPoint.wasSuccessful();
    }

    public boolean streamWasResumed() {
        return this.smResumedSyncPoint.wasSuccessful();
    }

    public boolean isDisconnectedButSmResumptionPossible() {
        return this.disconnectedButResumeable && this.isSmResumptionPossible();
    }

    public boolean isSmResumptionPossible() {
        if (this.smSessionId == null) {
            return false;
        }
        Long shutdownTimestamp = this.packetWriter.shutdownTimestamp;
        if (shutdownTimestamp == null) {
            return true;
        }
        long current = System.currentTimeMillis();
        long maxResumptionMillies = this.getMaxSmResumptionTime() * 1000;
        return shutdownTimestamp + maxResumptionMillies <= current;
    }

    public int getMaxSmResumptionTime() {
        int clientResumptionTime = this.smClientMaxResumptionTime > 0 ? this.smClientMaxResumptionTime : Integer.MAX_VALUE;
        int serverResumptionTime = this.smServerMaxResumptimTime > 0 ? this.smServerMaxResumptimTime : Integer.MAX_VALUE;
        return Math.min(clientResumptionTime, serverResumptionTime);
    }

    private void processHandledCount(long handledCount) throws SmackException.NotConnectedException {
        long ackedStanzasCount = SMUtils.calculateDelta(handledCount, this.serverHandledStanzasCount);
        final ArrayList<Packet> ackedStanzas = new ArrayList<Packet>(handledCount <= Integer.MAX_VALUE ? (int)handledCount : Integer.MAX_VALUE);
        for (long i = 0L; i < ackedStanzasCount; ++i) {
            Packet ackedStanza = (Packet)this.unacknowledgedStanzas.poll();
            assert (ackedStanza != null);
            ackedStanzas.add(ackedStanza);
        }
        boolean atLeastOneStanzaAcknowledgedListener = false;
        if (!this.stanzaAcknowledgedListeners.isEmpty()) {
            atLeastOneStanzaAcknowledgedListener = true;
        } else {
            for (Packet ackedStanza : ackedStanzas) {
                String id = ackedStanza.getPacketID();
                if (id == null || !this.stanzaIdAcknowledgedListeners.containsKey(id)) continue;
                atLeastOneStanzaAcknowledgedListener = true;
                break;
            }
        }
        if (atLeastOneStanzaAcknowledgedListener) {
            this.asyncGo(new Runnable(){

                @Override
                public void run() {
                    for (Packet ackedStanza : ackedStanzas) {
                        PacketListener listener2;
                        for (PacketListener listener2 : XMPPTCPConnection.this.stanzaAcknowledgedListeners) {
                            try {
                                listener2.processPacket(ackedStanza);
                            }
                            catch (SmackException.NotConnectedException e) {
                                LOGGER.log(Level.FINER, "Received not connected exception", e);
                            }
                        }
                        String id = ackedStanza.getPacketID();
                        if (StringUtils.isNullOrEmpty((CharSequence)id)) {
                            return;
                        }
                        listener2 = (PacketListener)XMPPTCPConnection.this.stanzaIdAcknowledgedListeners.remove(id);
                        if (listener2 == null) continue;
                        try {
                            listener2.processPacket(ackedStanza);
                        }
                        catch (SmackException.NotConnectedException e) {
                            LOGGER.log(Level.FINER, "Received not connected exception", e);
                        }
                    }
                }
            });
        }
        this.serverHandledStanzasCount = handledCount;
    }

    protected class PacketWriter {
        public static final int QUEUE_SIZE = 500;
        private final ArrayBlockingQueueWithShutdown<Element> queue = new ArrayBlockingQueueWithShutdown(500, true);
        protected SynchronizationPoint<SmackException.NoResponseException> shutdownDone = new SynchronizationPoint((AbstractXMPPConnection)XMPPTCPConnection.this);
        protected volatile Long shutdownTimestamp = null;
        private volatile boolean instantShutdown;

        protected PacketWriter() {
        }

        void init() {
            this.shutdownDone.init();
            this.shutdownTimestamp = null;
            if (XMPPTCPConnection.this.unacknowledgedStanzas != null) {
                this.drainWriterQueueToUnacknowledgedStanzas();
            }
            this.queue.start();
            Async.go((Runnable)new Runnable(){

                @Override
                public void run() {
                    PacketWriter.this.writePackets();
                }
            }, (String)("Smack Packet Writer (" + XMPPTCPConnection.this.getConnectionCounter() + ")"));
        }

        private boolean done() {
            return this.shutdownTimestamp != null;
        }

        protected void throwNotConnectedExceptionIfDoneAndResumptionNotPossible() throws SmackException.NotConnectedException {
            if (this.done() && !XMPPTCPConnection.this.isSmResumptionPossible()) {
                throw new SmackException.NotConnectedException();
            }
        }

        protected void sendStreamElement(Element element) throws SmackException.NotConnectedException {
            this.throwNotConnectedExceptionIfDoneAndResumptionNotPossible();
            boolean enqueued = false;
            while (!enqueued) {
                try {
                    this.queue.put((Object)element);
                    enqueued = true;
                }
                catch (InterruptedException e) {
                    this.throwNotConnectedExceptionIfDoneAndResumptionNotPossible();
                    LOGGER.log(Level.WARNING, "Sending thread was interrupted", e);
                }
            }
        }

        void shutdown(boolean instant) {
            this.instantShutdown = instant;
            this.shutdownTimestamp = System.currentTimeMillis();
            this.queue.shutdown();
            try {
                this.shutdownDone.checkIfSuccessOrWait();
            }
            catch (SmackException.NoResponseException e) {
                LOGGER.log(Level.WARNING, "NoResponseException", e);
            }
        }

        private Element nextStreamElement() {
            Element packet;
            block2: {
                packet = null;
                try {
                    packet = (Element)this.queue.take();
                }
                catch (InterruptedException e) {
                    if (this.queue.isShutdown()) break block2;
                    LOGGER.log(Level.WARNING, "Packet writer thread was interrupted. Don't do that. Use disconnect() instead.", e);
                }
            }
            return packet;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writePackets() {
            try {
                XMPPTCPConnection.this.openStream();
                XMPPTCPConnection.this.initalOpenStreamSend.reportSuccess();
                while (!this.done()) {
                    Element element = this.nextStreamElement();
                    if (element == null) continue;
                    Packet packet = null;
                    if (element instanceof Packet) {
                        packet = (Packet)element;
                    }
                    if (XMPPTCPConnection.this.isSmEnabled() && packet != null) {
                        if ((double)XMPPTCPConnection.this.unacknowledgedStanzas.size() == 400.0) {
                            XMPPTCPConnection.this.writer.write(StreamManagement.AckRequest.INSTANCE.toXML().toString());
                            XMPPTCPConnection.this.writer.flush();
                        }
                        try {
                            XMPPTCPConnection.this.unacknowledgedStanzas.put(packet);
                        }
                        catch (InterruptedException e) {
                            throw new IllegalStateException(e);
                        }
                    }
                    XMPPTCPConnection.this.writer.write(element.toXML().toString());
                    if (this.queue.isEmpty()) {
                        XMPPTCPConnection.this.writer.flush();
                    }
                    if (packet == null) continue;
                    XMPPTCPConnection.this.firePacketSendingListeners(packet);
                }
                if (!this.instantShutdown) {
                    try {
                        while (!this.queue.isEmpty()) {
                            Element packet = (Element)this.queue.remove();
                            XMPPTCPConnection.this.writer.write(packet.toXML().toString());
                        }
                        XMPPTCPConnection.this.writer.flush();
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.WARNING, "Exception flushing queue during shutdown, ignore and continue", e);
                    }
                    try {
                        XMPPTCPConnection.this.writer.write("</stream:stream>");
                        XMPPTCPConnection.this.writer.flush();
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.WARNING, "Exception writing closing stream element", e);
                    }
                    this.queue.clear();
                } else if (this.instantShutdown && XMPPTCPConnection.this.isSmEnabled()) {
                    this.drainWriterQueueToUnacknowledgedStanzas();
                }
                try {
                    XMPPTCPConnection.this.writer.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            catch (Exception e) {
                if (!this.done() && !XMPPTCPConnection.this.isSocketClosed()) {
                    XMPPTCPConnection.this.notifyConnectionError(e);
                } else {
                    LOGGER.log(Level.FINE, "Ignoring Exception in writePackets()", e);
                }
            }
            finally {
                this.shutdownDone.reportSuccess();
            }
        }

        private void drainWriterQueueToUnacknowledgedStanzas() {
            ArrayList elements = new ArrayList(this.queue.size());
            this.queue.drainTo(elements);
            for (Element element : elements) {
                if (!(element instanceof Packet)) continue;
                XMPPTCPConnection.this.unacknowledgedStanzas.add((Packet)element);
            }
        }
    }

    protected class PacketReader {
        XmlPullParser parser;
        private volatile boolean done;

        protected PacketReader() {
        }

        void init() {
            this.done = false;
            Async.go((Runnable)new Runnable(){

                @Override
                public void run() {
                    PacketReader.this.parsePackets();
                }
            }, (String)("Smack Packet Reader (" + XMPPTCPConnection.this.getConnectionCounter() + ")"));
        }

        void shutdown() {
            this.done = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void parsePackets() {
            block66: {
                try {
                    XMPPTCPConnection.this.initalOpenStreamSend.checkIfSuccessOrWait();
                    int eventType = this.parser.getEventType();
                    while (!this.done) {
                        block3 : switch (eventType) {
                            case 2: {
                                String name;
                                block26 : switch (name = this.parser.getName()) {
                                    case "message": 
                                    case "iq": 
                                    case "presence": {
                                        try {
                                            XMPPTCPConnection.this.parseAndProcessStanza(this.parser);
                                            break block3;
                                        }
                                        finally {
                                            XMPPTCPConnection.this.clientHandledStanzasCount = SMUtils.incrementHeight(XMPPTCPConnection.this.clientHandledStanzasCount);
                                        }
                                    }
                                    case "stream": {
                                        if (!"jabber:client".equals(this.parser.getNamespace(null))) break block3;
                                        XMPPTCPConnection.this.streamId = this.parser.getAttributeValue("", "id");
                                        String reportedServiceName = this.parser.getAttributeValue("", "from");
                                        assert (reportedServiceName.equals(XMPPTCPConnection.this.config.getServiceName()));
                                        break block3;
                                    }
                                    case "error": {
                                        throw new XMPPException.StreamErrorException(PacketParserUtils.parseStreamError((XmlPullParser)this.parser));
                                    }
                                    case "features": {
                                        XMPPTCPConnection.this.parseFeatures(this.parser);
                                        break;
                                    }
                                    case "proceed": {
                                        try {
                                            XMPPTCPConnection.this.proceedTLSReceived();
                                            XMPPTCPConnection.this.openStream();
                                            break;
                                        }
                                        catch (Exception e) {
                                            XMPPTCPConnection.this.saslFeatureReceived.reportFailure((Exception)new SmackException((Throwable)e));
                                            throw e;
                                        }
                                    }
                                    case "failure": {
                                        String namespace;
                                        switch (namespace = this.parser.getNamespace(null)) {
                                            case "urn:ietf:params:xml:ns:xmpp-tls": {
                                                throw new XMPPException.XMPPErrorException("TLS negotiation has failed", null);
                                            }
                                            case "http://jabber.org/protocol/compress": {
                                                XMPPTCPConnection.this.compressSyncPoint.reportFailure((Exception)new XMPPException.XMPPErrorException("Could not establish compression", null));
                                                break block26;
                                            }
                                            case "urn:ietf:params:xml:ns:xmpp-sasl": {
                                                SaslStreamElements.SASLFailure failure = PacketParserUtils.parseSASLFailure((XmlPullParser)this.parser);
                                                XMPPTCPConnection.this.getSASLAuthentication().authenticationFailed(failure);
                                            }
                                        }
                                        break;
                                    }
                                    case "challenge": {
                                        String challengeData = this.parser.nextText();
                                        XMPPTCPConnection.this.getSASLAuthentication().challengeReceived(challengeData);
                                        break;
                                    }
                                    case "success": {
                                        SaslStreamElements.Success success = new SaslStreamElements.Success(this.parser.nextText());
                                        XMPPTCPConnection.this.openStream();
                                        XMPPTCPConnection.this.getSASLAuthentication().authenticated(success);
                                        break;
                                    }
                                    case "compressed": {
                                        XMPPTCPConnection.this.initReaderAndWriter();
                                        XMPPTCPConnection.this.openStream();
                                        XMPPTCPConnection.this.compressSyncPoint.reportSuccess();
                                        break;
                                    }
                                    case "enabled": {
                                        StreamManagement.Enabled enabled = ParseStreamManagement.enabled(this.parser);
                                        if (enabled.isResumeSet()) {
                                            XMPPTCPConnection.this.smSessionId = enabled.getId();
                                            if (StringUtils.isNullOrEmpty((CharSequence)XMPPTCPConnection.this.smSessionId)) {
                                                XMPPException.XMPPErrorException xmppException = new XMPPException.XMPPErrorException("Stream Management 'enabled' element with resume attribute but without session id received", new XMPPError(XMPPError.Condition.bad_request));
                                                XMPPTCPConnection.this.smEnabledSyncPoint.reportFailure((Exception)xmppException);
                                                throw xmppException;
                                            }
                                            XMPPTCPConnection.this.smServerMaxResumptimTime = enabled.getMaxResumptionTime();
                                        } else {
                                            XMPPTCPConnection.this.smSessionId = null;
                                        }
                                        XMPPTCPConnection.this.clientHandledStanzasCount = 0L;
                                        XMPPTCPConnection.this.smWasEnabledAtLeastOnce = true;
                                        XMPPTCPConnection.this.smEnabledSyncPoint.reportSuccess();
                                        LOGGER.fine("Stream Management (XEP-198): succesfully enabled");
                                        break;
                                    }
                                    case "failed": {
                                        StreamManagement.Failed failed = ParseStreamManagement.failed(this.parser);
                                        XMPPError xmppError = new XMPPError(failed.getXMPPErrorCondition());
                                        XMPPException.XMPPErrorException xmppException = new XMPPException.XMPPErrorException("Stream Management failed", xmppError);
                                        if (XMPPTCPConnection.this.smResumedSyncPoint.requestSent()) {
                                            XMPPTCPConnection.this.smResumedSyncPoint.reportFailure((Exception)xmppException);
                                            break;
                                        }
                                        if (!XMPPTCPConnection.this.smEnabledSyncPoint.requestSent()) {
                                            throw new IllegalStateException("Failed element received but SM was not previously enabled");
                                        }
                                        XMPPTCPConnection.this.smEnabledSyncPoint.reportFailure((Exception)xmppException);
                                        XMPPTCPConnection.this.lastFeaturesReceived.reportSuccess();
                                        break;
                                    }
                                    case "resumed": {
                                        StreamManagement.Resumed resumed = ParseStreamManagement.resumed(this.parser);
                                        if (!XMPPTCPConnection.this.smSessionId.equals(resumed.getPrevId())) {
                                            throw new StreamManagementException.StreamIdDoesNotMatchException(XMPPTCPConnection.this.smSessionId, resumed.getPrevId());
                                        }
                                        XMPPTCPConnection.this.processHandledCount(resumed.getHandledCount());
                                        LinkedList stanzasToResend = new LinkedList();
                                        stanzasToResend.addAll(XMPPTCPConnection.this.unacknowledgedStanzas);
                                        for (Packet stanza : stanzasToResend) {
                                            XMPPTCPConnection.this.packetWriter.sendStreamElement((Element)stanza);
                                        }
                                        XMPPTCPConnection.this.smResumedSyncPoint.reportSuccess();
                                        XMPPTCPConnection.this.smEnabledSyncPoint.reportSuccess();
                                        LOGGER.fine("Stream Management (XEP-198): Stream resumed");
                                        break;
                                    }
                                    case "a": {
                                        StreamManagement.AckAnswer ackAnswer = ParseStreamManagement.ackAnswer(this.parser);
                                        XMPPTCPConnection.this.processHandledCount(ackAnswer.getHandledCount());
                                        break;
                                    }
                                    case "r": {
                                        ParseStreamManagement.ackRequest(this.parser);
                                        if (XMPPTCPConnection.this.smEnabledSyncPoint.wasSuccessful()) {
                                            XMPPTCPConnection.this.sendSmAcknowledgementInternal();
                                            break;
                                        }
                                        LOGGER.warning("SM Ack Request received while SM is not enabled");
                                        break;
                                    }
                                    default: {
                                        LOGGER.warning("Unknown top level stream element: " + name);
                                        break;
                                    }
                                }
                                break;
                            }
                            case 3: {
                                if (!this.parser.getName().equals("stream")) break;
                                XMPPTCPConnection.this.disconnect();
                                break;
                            }
                            case 1: {
                                throw new SmackException("Parser got END_DOCUMENT event. This could happen e.g. if the server closed the connection without sending a closing stream element");
                            }
                        }
                        eventType = this.parser.next();
                    }
                }
                catch (Exception e) {
                    if (this.done || XMPPTCPConnection.this.isSocketClosed()) break block66;
                    XMPPTCPConnection.this.notifyConnectionError(e);
                }
            }
        }
    }
}

