/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.tcp;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import org.jivesoftware.smack.AbstractConnectionListener;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.SynchronizationPoint;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.compress.packet.Compress;
import org.jivesoftware.smack.compression.XMPPInputOutputStream;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.packet.Element;
import org.jivesoftware.smack.packet.Nonza;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StartTls;
import org.jivesoftware.smack.packet.StreamOpen;
import org.jivesoftware.smack.packet.TopLevelStreamElement;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.proxy.ProxyInfo;
import org.jivesoftware.smack.sasl.packet.SaslStreamElements;
import org.jivesoftware.smack.sm.SMUtils;
import org.jivesoftware.smack.sm.StreamManagementException;
import org.jivesoftware.smack.sm.packet.StreamManagement;
import org.jivesoftware.smack.sm.predicates.Predicate;
import org.jivesoftware.smack.sm.provider.ParseStreamManagement;
import org.jivesoftware.smack.tcp.BundleAndDefer;
import org.jivesoftware.smack.tcp.BundleAndDeferCallback;
import org.jivesoftware.smack.tcp.XMPPTCPConnectionConfiguration;
import org.jivesoftware.smack.util.ArrayBlockingQueueWithShutdown;
import org.jivesoftware.smack.util.Async;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.TLSUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smack.util.dns.HostAddress;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.jid.parts.Resourcepart;
import org.jxmpp.stringprep.XmppStringprepException;
import org.jxmpp.util.XmppStringUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class XMPPTCPConnection
extends AbstractXMPPConnection {
    private static final int QUEUE_SIZE = 500;
    private static final Logger LOGGER = Logger.getLogger(XMPPTCPConnection.class.getName());
    private Socket socket;
    private boolean disconnectedButResumeable = false;
    private boolean usingTLS = false;
    protected PacketWriter packetWriter;
    protected PacketReader packetReader;
    private final SynchronizationPoint<Exception> initalOpenStreamSend = new SynchronizationPoint((AbstractXMPPConnection)this, "initial open stream element send to server");
    private final SynchronizationPoint<XMPPException> maybeCompressFeaturesReceived = new SynchronizationPoint((AbstractXMPPConnection)this, "stream compression feature");
    private final SynchronizationPoint<SmackException> compressSyncPoint = new SynchronizationPoint((AbstractXMPPConnection)this, "stream compression");
    private final SynchronizationPoint<Exception> closingStreamReceived = new SynchronizationPoint((AbstractXMPPConnection)this, "stream closing element received");
    private static BundleAndDeferCallback defaultBundleAndDeferCallback;
    private BundleAndDeferCallback bundleAndDeferCallback = defaultBundleAndDeferCallback;
    private static boolean useSmDefault;
    private static boolean useSmResumptionDefault;
    private String smSessionId;
    private final SynchronizationPoint<XMPPException> smResumedSyncPoint = new SynchronizationPoint((AbstractXMPPConnection)this, "stream resumed element");
    private final SynchronizationPoint<XMPPException> smEnabledSyncPoint = new SynchronizationPoint((AbstractXMPPConnection)this, "stream enabled element");
    private int smClientMaxResumptionTime = -1;
    private int smServerMaxResumptimTime = -1;
    private boolean useSm = useSmDefault;
    private boolean useSmResumption = useSmResumptionDefault;
    private long serverHandledStanzasCount = 0L;
    private long clientHandledStanzasCount = 0L;
    private BlockingQueue<Stanza> unacknowledgedStanzas;
    private boolean smWasEnabledAtLeastOnce = false;
    private final Collection<StanzaListener> stanzaAcknowledgedListeners = new ConcurrentLinkedQueue<StanzaListener>();
    private final Map<String, StanzaListener> stanzaIdAcknowledgedListeners = new ConcurrentHashMap<String, StanzaListener>();
    private final Set<StanzaFilter> requestAckPredicates = new LinkedHashSet<StanzaFilter>();
    private final XMPPTCPConnectionConfiguration config;

    public XMPPTCPConnection(XMPPTCPConnectionConfiguration config) {
        super((ConnectionConfiguration)config);
        this.config = config;
        this.addConnectionListener((ConnectionListener)new AbstractConnectionListener(){

            public void connectionClosedOnError(Exception e) {
                if (e instanceof XMPPException.StreamErrorException) {
                    XMPPTCPConnection.this.dropSmState();
                }
            }
        });
    }

    public XMPPTCPConnection(CharSequence jid, String password) throws XmppStringprepException {
        this(XmppStringUtils.parseLocalpart((String)jid.toString()), password, XmppStringUtils.parseDomain((String)jid.toString()));
    }

    public XMPPTCPConnection(CharSequence username, String password, String serviceName) throws XmppStringprepException {
        this(((XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)XMPPTCPConnectionConfiguration.builder().setUsernameAndPassword(username, password)).setXmppDomain(JidCreate.domainBareFrom((String)serviceName))).build());
    }

    protected void throwNotConnectedExceptionIfAppropriate() throws SmackException.NotConnectedException {
        if (this.packetWriter == null) {
            throw new SmackException.NotConnectedException();
        }
        this.packetWriter.throwNotConnectedExceptionIfDoneAndResumptionNotPossible();
    }

    protected void throwAlreadyConnectedExceptionIfAppropriate() throws SmackException.AlreadyConnectedException {
        if (this.isConnected() && !this.disconnectedButResumeable) {
            throw new SmackException.AlreadyConnectedException();
        }
    }

    protected void throwAlreadyLoggedInExceptionIfAppropriate() throws SmackException.AlreadyLoggedInException {
        if (this.isAuthenticated() && !this.disconnectedButResumeable) {
            throw new SmackException.AlreadyLoggedInException();
        }
    }

    protected void afterSuccessfulLogin(boolean resumed) throws SmackException.NotConnectedException, InterruptedException {
        this.disconnectedButResumeable = false;
        super.afterSuccessfulLogin(resumed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void loginInternal(String username, String password, Resourcepart resource) throws XMPPException, SmackException, IOException, InterruptedException {
        this.saslAuthentication.authenticate(username, password, this.config.getAuthzid());
        this.maybeEnableCompression();
        if (this.isSmResumptionPossible()) {
            this.smResumedSyncPoint.sendAndWaitForResponse((TopLevelStreamElement)new StreamManagement.Resume(this.clientHandledStanzasCount, this.smSessionId));
            if (this.smResumedSyncPoint.wasSuccessful()) {
                this.afterSuccessfulLogin(true);
                return;
            }
            LOGGER.fine("Stream resumption failed, continuing with normal stream establishment process");
        }
        LinkedList previouslyUnackedStanzas = new LinkedList();
        if (this.unacknowledgedStanzas != null) {
            this.unacknowledgedStanzas.drainTo(previouslyUnackedStanzas);
            this.dropSmState();
        }
        this.bindResourceAndEstablishSession(resource);
        if (this.isSmAvailable() && this.useSm) {
            this.serverHandledStanzasCount = 0L;
            this.smEnabledSyncPoint.sendAndWaitForResponseOrThrow((Nonza)new StreamManagement.Enable(this.useSmResumption, this.smClientMaxResumptionTime));
            Set<StanzaFilter> set = this.requestAckPredicates;
            synchronized (set) {
                if (this.requestAckPredicates.isEmpty()) {
                    this.requestAckPredicates.add(Predicate.forMessagesOrAfter5Stanzas());
                }
            }
        }
        for (Stanza stanza : previouslyUnackedStanzas) {
            this.sendStanzaInternal(stanza);
        }
        this.afterSuccessfulLogin(false);
    }

    public boolean isSecureConnection() {
        return this.usingTLS;
    }

    protected void shutdown() {
        if (this.isSmEnabled()) {
            try {
                this.sendSmAcknowledgementInternal();
            }
            catch (InterruptedException | SmackException.NotConnectedException e) {
                LOGGER.log(Level.FINE, "Can not send final SM ack as connection is not connected", e);
            }
        }
        this.shutdown(false);
    }

    public synchronized void instantShutdown() {
        this.shutdown(true);
    }

    private void shutdown(boolean instant) {
        if (this.disconnectedButResumeable) {
            return;
        }
        if (this.packetWriter != null) {
            this.packetWriter.shutdown(instant);
        }
        try {
            Exception res = this.closingStreamReceived.checkIfSuccessOrWait();
            LOGGER.info("closingstream " + res);
        }
        catch (InterruptedException | SmackException.NoResponseException e) {
            LOGGER.log(Level.INFO, "Exception while waiting for closing stream element from the server " + (Object)((Object)this), e);
        }
        if (this.packetReader != null) {
            this.packetReader.shutdown();
        }
        try {
            this.socket.close();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "shutdown", e);
        }
        this.setWasAuthenticated();
        if (this.isSmResumptionPossible() && instant) {
            this.disconnectedButResumeable = true;
        } else {
            this.disconnectedButResumeable = false;
            this.smSessionId = null;
        }
        this.authenticated = false;
        this.connected = false;
        this.usingTLS = false;
        this.reader = null;
        this.writer = null;
        this.maybeCompressFeaturesReceived.init();
        this.compressSyncPoint.init();
        this.smResumedSyncPoint.init();
        this.smEnabledSyncPoint.init();
        this.initalOpenStreamSend.init();
    }

    public void sendNonza(Nonza element) throws SmackException.NotConnectedException, InterruptedException {
        this.packetWriter.sendStreamElement((Element)element);
    }

    protected void sendStanzaInternal(Stanza packet) throws SmackException.NotConnectedException, InterruptedException {
        this.packetWriter.sendStreamElement((Element)packet);
        if (this.isSmEnabled()) {
            for (StanzaFilter requestAckPredicate : this.requestAckPredicates) {
                if (!requestAckPredicate.accept(packet)) continue;
                this.requestSmAcknowledgementInternal();
                break;
            }
        }
    }

    private void connectUsingConfiguration() throws SmackException.ConnectionException, IOException {
        List failedAddresses = this.populateHostAddresses();
        SocketFactory socketFactory = this.config.getSocketFactory();
        ProxyInfo proxyInfo = this.config.getProxyInfo();
        int timeout = this.config.getConnectTimeout();
        if (socketFactory == null) {
            socketFactory = SocketFactory.getDefault();
        }
        this.socket = socketFactory.createSocket();
        for (HostAddress hostAddress : this.hostAddresses) {
            Iterator<InetAddress> inetAddresses = null;
            String host = hostAddress.getFQDN();
            int port = hostAddress.getPort();
            try {
                inetAddresses = Arrays.asList(InetAddress.getAllByName(host)).iterator();
                if (!inetAddresses.hasNext()) {
                    LOGGER.warning("InetAddress.getAllByName() returned empty result array.");
                    throw new UnknownHostException(host);
                }
            }
            catch (UnknownHostException e) {
                hostAddress.setException((Exception)e);
                List emptyInetAddresses = Collections.emptyList();
                inetAddresses = emptyInetAddresses.iterator();
                continue;
            }
            while (inetAddresses.hasNext()) {
                InetAddress inetAddress = inetAddresses.next();
                String inetAddressAndPort = inetAddress + " at port " + port;
                LOGGER.finer("Trying to establish TCP connection to " + inetAddressAndPort);
                try {
                    if (proxyInfo == null) {
                        this.socket.connect(new InetSocketAddress(inetAddress, port), timeout);
                    } else {
                        proxyInfo.getProxySocketConnection().connect(this.socket, inetAddress, port, timeout);
                    }
                }
                catch (Exception e) {
                    hostAddress.setException(inetAddress, e);
                    if (!inetAddresses.hasNext()) break;
                    continue;
                }
                LOGGER.finer("Established TCP connection to " + inetAddressAndPort);
                this.host = host;
                this.port = port;
                return;
            }
            failedAddresses.add(hostAddress);
        }
        throw SmackException.ConnectionException.from((List)failedAddresses);
    }

    private void initConnection() throws IOException {
        boolean isFirstInitialization = this.packetReader == null || this.packetWriter == null;
        this.compressionHandler = null;
        this.initReaderAndWriter();
        if (isFirstInitialization) {
            this.packetWriter = new PacketWriter();
            this.packetReader = new PacketReader();
            if (this.config.isDebuggerEnabled()) {
                this.addAsyncStanzaListener(this.debugger.getReaderListener(), null);
                if (this.debugger.getWriterListener() != null) {
                    this.addPacketSendingListener(this.debugger.getWriterListener(), null);
                }
            }
        }
        this.packetWriter.init();
        this.packetReader.init();
    }

    private void initReaderAndWriter() throws IOException {
        InputStream is = this.socket.getInputStream();
        OutputStream os = this.socket.getOutputStream();
        if (this.compressionHandler != null) {
            is = this.compressionHandler.getInputStream(is);
            os = this.compressionHandler.getOutputStream(os);
        }
        this.writer = new OutputStreamWriter(os, "UTF-8");
        this.reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        this.initDebugger();
    }

    private void proceedTLSReceived() throws NoSuchAlgorithmException, CertificateException, IOException, KeyStoreException, NoSuchProviderException, UnrecoverableKeyException, KeyManagementException, SmackException {
        SSLContext context = this.config.getCustomSSLContext();
        KeyStore ks = null;
        KeyManager[] kms = null;
        PasswordCallback pcb = null;
        if (context == null) {
            String keyStoreType = this.config.getKeystoreType();
            CallbackHandler callbackHandler = this.config.getCallbackHandler();
            String keystorePath = this.config.getKeystorePath();
            if ("PKCS11".equals(keyStoreType)) {
                try {
                    Constructor<?> c = Class.forName("sun.security.pkcs11.SunPKCS11").getConstructor(InputStream.class);
                    String pkcs11Config = "name = SmartCard\nlibrary = " + this.config.getPKCS11Library();
                    ByteArrayInputStream config = new ByteArrayInputStream(pkcs11Config.getBytes());
                    Provider p = (Provider)c.newInstance(config);
                    Security.addProvider(p);
                    ks = KeyStore.getInstance("PKCS11", p);
                    pcb = new PasswordCallback("PKCS11 Password: ", false);
                    callbackHandler.handle(new Callback[]{pcb});
                    ks.load(null, pcb.getPassword());
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Exception", e);
                    ks = null;
                }
            } else if ("Apple".equals(keyStoreType)) {
                ks = KeyStore.getInstance("KeychainStore", "Apple");
                ks.load(null, null);
            } else if (keyStoreType != null) {
                ks = KeyStore.getInstance(keyStoreType);
                if (callbackHandler != null && StringUtils.isNotEmpty((CharSequence)keystorePath)) {
                    try {
                        pcb = new PasswordCallback("Keystore Password: ", false);
                        callbackHandler.handle(new Callback[]{pcb});
                        ks.load(new FileInputStream(keystorePath), pcb.getPassword());
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.WARNING, "Exception", e);
                        ks = null;
                    }
                }
            }
            if (ks != null) {
                KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
                try {
                    if (pcb == null) {
                        kmf.init(ks, null);
                    } else {
                        kmf.init(ks, pcb.getPassword());
                        pcb.clearPassword();
                    }
                    kms = kmf.getKeyManagers();
                }
                catch (NullPointerException npe) {
                    LOGGER.log(Level.WARNING, "NullPointerException", npe);
                }
            }
            context = SSLContext.getInstance("TLS");
            context.init(kms, null, new SecureRandom());
        }
        Socket plain = this.socket;
        this.socket = context.getSocketFactory().createSocket(plain, this.host, plain.getPort(), true);
        this.initReaderAndWriter();
        SSLSocket sslSocket = (SSLSocket)this.socket;
        TLSUtils.setEnabledProtocolsAndCiphers((SSLSocket)sslSocket, (String[])this.config.getEnabledSSLProtocols(), (String[])this.config.getEnabledSSLCiphers());
        sslSocket.startHandshake();
        HostnameVerifier verifier = this.getConfiguration().getHostnameVerifier();
        if (verifier == null) {
            throw new IllegalStateException("No HostnameVerifier set. Use connectionConfiguration.setHostnameVerifier() to configure.");
        }
        if (!verifier.verify(this.getXMPPServiceDomain().toString(), sslSocket.getSession())) {
            throw new CertificateException("Hostname verification of certificate failed. Certificate does not authenticate " + this.getXMPPServiceDomain());
        }
        this.usingTLS = true;
    }

    private static XMPPInputOutputStream maybeGetCompressionHandler(Compress.Feature compression) {
        for (XMPPInputOutputStream handler : SmackConfiguration.getCompresionHandlers()) {
            String method = handler.getCompressionMethod();
            if (!compression.getMethods().contains(method)) continue;
            return handler;
        }
        return null;
    }

    public boolean isUsingCompression() {
        return this.compressionHandler != null && this.compressSyncPoint.wasSuccessful();
    }

    private void maybeEnableCompression() throws SmackException.NotConnectedException, SmackException.NoResponseException, SmackException, InterruptedException {
        if (!this.config.isCompressionEnabled()) {
            return;
        }
        this.maybeCompressFeaturesReceived.checkIfSuccessOrWait();
        Compress.Feature compression = (Compress.Feature)this.getFeature("compression", "http://jabber.org/protocol/compress");
        if (compression == null) {
            return;
        }
        this.compressionHandler = XMPPTCPConnection.maybeGetCompressionHandler(compression);
        if (this.compressionHandler != null) {
            this.compressSyncPoint.sendAndWaitForResponseOrThrow((Nonza)new Compress(this.compressionHandler.getCompressionMethod()));
        } else {
            LOGGER.warning("Could not enable compression because no matching handler/method pair was found");
        }
    }

    protected void connectInternal() throws SmackException, IOException, XMPPException, InterruptedException {
        this.closingStreamReceived.init();
        this.connectUsingConfiguration();
        this.initConnection();
        this.saslFeatureReceived.checkIfSuccessOrWaitOrThrow();
        this.connected = true;
        this.callConnectionConnectedListener();
    }

    private synchronized void notifyConnectionError(Exception e) {
        if ((this.packetReader == null || this.packetReader.done) && (this.packetWriter == null || this.packetWriter.done())) {
            return;
        }
        this.instantShutdown();
        this.callConnectionClosedOnErrorListener(e);
    }

    protected void setWriter(Writer writer) {
        this.writer = writer;
    }

    protected void afterFeaturesReceived() throws SmackException.SecurityRequiredException, SmackException.NotConnectedException, InterruptedException {
        StartTls startTlsFeature = (StartTls)this.getFeature("starttls", "urn:ietf:params:xml:ns:xmpp-tls");
        if (startTlsFeature != null) {
            if (startTlsFeature.required() && this.config.getSecurityMode() == ConnectionConfiguration.SecurityMode.disabled) {
                this.notifyConnectionError((Exception)new SmackException.SecurityRequiredByServerException());
                return;
            }
            if (this.config.getSecurityMode() != ConnectionConfiguration.SecurityMode.disabled) {
                this.sendNonza((Nonza)new StartTls());
            }
        }
        if (!this.isSecureConnection() && startTlsFeature == null && this.getConfiguration().getSecurityMode() == ConnectionConfiguration.SecurityMode.required) {
            throw new SmackException.SecurityRequiredByClientException();
        }
        if (this.getSASLAuthentication().authenticationSuccessful()) {
            this.maybeCompressFeaturesReceived.reportSuccess();
        }
    }

    void openStream() throws SmackException, InterruptedException {
        DomainBareJid to = this.getXMPPServiceDomain();
        String from = null;
        CharSequence localpart = this.config.getUsername();
        if (localpart != null) {
            from = XmppStringUtils.completeJidFrom((CharSequence)localpart, (CharSequence)to);
        }
        String id = this.getStreamId();
        this.sendNonza((Nonza)new StreamOpen((CharSequence)to, (CharSequence)from, id));
        try {
            this.packetReader.parser = PacketParserUtils.newXmppParser((Reader)this.reader);
        }
        catch (XmlPullParserException e) {
            throw new SmackException((Throwable)e);
        }
    }

    public static void setUseStreamManagementDefault(boolean useSmDefault) {
        XMPPTCPConnection.useSmDefault = useSmDefault;
    }

    @Deprecated
    public static void setUseStreamManagementResumptiodDefault(boolean useSmResumptionDefault) {
        XMPPTCPConnection.setUseStreamManagementResumptionDefault(useSmResumptionDefault);
    }

    public static void setUseStreamManagementResumptionDefault(boolean useSmResumptionDefault) {
        if (useSmResumptionDefault) {
            XMPPTCPConnection.setUseStreamManagementDefault(useSmResumptionDefault);
        }
        XMPPTCPConnection.useSmResumptionDefault = useSmResumptionDefault;
    }

    public void setUseStreamManagement(boolean useSm) {
        this.useSm = useSm;
    }

    public void setUseStreamManagementResumption(boolean useSmResumption) {
        if (useSmResumption) {
            this.setUseStreamManagement(useSmResumption);
        }
        this.useSmResumption = useSmResumption;
    }

    public void setPreferredResumptionTime(int resumptionTime) {
        this.smClientMaxResumptionTime = resumptionTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addRequestAckPredicate(StanzaFilter predicate) {
        Set<StanzaFilter> set = this.requestAckPredicates;
        synchronized (set) {
            return this.requestAckPredicates.add(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeRequestAckPredicate(StanzaFilter predicate) {
        Set<StanzaFilter> set = this.requestAckPredicates;
        synchronized (set) {
            return this.requestAckPredicates.remove(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllRequestAckPredicates() {
        Set<StanzaFilter> set = this.requestAckPredicates;
        synchronized (set) {
            this.requestAckPredicates.clear();
        }
    }

    public void requestSmAcknowledgement() throws StreamManagementException.StreamManagementNotEnabledException, SmackException.NotConnectedException, InterruptedException {
        if (!this.isSmEnabled()) {
            throw new StreamManagementException.StreamManagementNotEnabledException();
        }
        this.requestSmAcknowledgementInternal();
    }

    private void requestSmAcknowledgementInternal() throws SmackException.NotConnectedException, InterruptedException {
        this.packetWriter.sendStreamElement((Element)StreamManagement.AckRequest.INSTANCE);
    }

    public void sendSmAcknowledgement() throws StreamManagementException.StreamManagementNotEnabledException, SmackException.NotConnectedException, InterruptedException {
        if (!this.isSmEnabled()) {
            throw new StreamManagementException.StreamManagementNotEnabledException();
        }
        this.sendSmAcknowledgementInternal();
    }

    private void sendSmAcknowledgementInternal() throws SmackException.NotConnectedException, InterruptedException {
        this.packetWriter.sendStreamElement((Element)new StreamManagement.AckAnswer(this.clientHandledStanzasCount));
    }

    public void addStanzaAcknowledgedListener(StanzaListener listener) {
        this.stanzaAcknowledgedListeners.add(listener);
    }

    public boolean removeStanzaAcknowledgedListener(StanzaListener listener) {
        return this.stanzaAcknowledgedListeners.remove(listener);
    }

    public void removeAllStanzaAcknowledgedListeners() {
        this.stanzaAcknowledgedListeners.clear();
    }

    public StanzaListener addStanzaIdAcknowledgedListener(final String id, StanzaListener listener) throws StreamManagementException.StreamManagementNotEnabledException {
        if (!this.smWasEnabledAtLeastOnce) {
            throw new StreamManagementException.StreamManagementNotEnabledException();
        }
        int removeAfterSeconds = Math.min(this.getMaxSmResumptionTime(), 43200);
        this.schedule(new Runnable(){

            @Override
            public void run() {
                XMPPTCPConnection.this.stanzaIdAcknowledgedListeners.remove(id);
            }
        }, removeAfterSeconds, TimeUnit.SECONDS);
        return this.stanzaIdAcknowledgedListeners.put(id, listener);
    }

    public StanzaListener removeStanzaIdAcknowledgedListener(String id) {
        return this.stanzaIdAcknowledgedListeners.remove(id);
    }

    public void removeAllStanzaIdAcknowledgedListeners() {
        this.stanzaIdAcknowledgedListeners.clear();
    }

    public boolean isSmAvailable() {
        return this.hasFeature("sm", "urn:xmpp:sm:3");
    }

    public boolean isSmEnabled() {
        return this.smEnabledSyncPoint.wasSuccessful();
    }

    public boolean streamWasResumed() {
        return this.smResumedSyncPoint.wasSuccessful();
    }

    public boolean isDisconnectedButSmResumptionPossible() {
        return this.disconnectedButResumeable && this.isSmResumptionPossible();
    }

    public boolean isSmResumptionPossible() {
        if (this.smSessionId == null) {
            return false;
        }
        Long shutdownTimestamp = this.packetWriter.shutdownTimestamp;
        if (shutdownTimestamp == null) {
            return true;
        }
        long current = System.currentTimeMillis();
        long maxResumptionMillies = (long)this.getMaxSmResumptionTime() * 1000L;
        return current <= shutdownTimestamp + maxResumptionMillies;
    }

    private void dropSmState() {
        this.smSessionId = null;
        this.unacknowledgedStanzas = null;
    }

    public int getMaxSmResumptionTime() {
        int clientResumptionTime = this.smClientMaxResumptionTime > 0 ? this.smClientMaxResumptionTime : Integer.MAX_VALUE;
        int serverResumptionTime = this.smServerMaxResumptimTime > 0 ? this.smServerMaxResumptimTime : Integer.MAX_VALUE;
        return Math.min(clientResumptionTime, serverResumptionTime);
    }

    private void processHandledCount(long handledCount) throws StreamManagementException.StreamManagementCounterError {
        long ackedStanzasCount = SMUtils.calculateDelta(handledCount, this.serverHandledStanzasCount);
        final ArrayList<Stanza> ackedStanzas = new ArrayList<Stanza>(ackedStanzasCount <= Integer.MAX_VALUE ? (int)ackedStanzasCount : Integer.MAX_VALUE);
        for (long i = 0L; i < ackedStanzasCount; ++i) {
            Stanza ackedStanza = (Stanza)this.unacknowledgedStanzas.poll();
            if (ackedStanza == null) {
                throw new StreamManagementException.StreamManagementCounterError(handledCount, this.serverHandledStanzasCount, ackedStanzasCount, ackedStanzas);
            }
            ackedStanzas.add(ackedStanza);
        }
        boolean atLeastOneStanzaAcknowledgedListener = false;
        if (!this.stanzaAcknowledgedListeners.isEmpty()) {
            atLeastOneStanzaAcknowledgedListener = true;
        } else {
            for (Stanza ackedStanza : ackedStanzas) {
                String id = ackedStanza.getStanzaId();
                if (id == null || !this.stanzaIdAcknowledgedListeners.containsKey(id)) continue;
                atLeastOneStanzaAcknowledgedListener = true;
                break;
            }
        }
        if (atLeastOneStanzaAcknowledgedListener) {
            this.asyncGo(new Runnable(){

                @Override
                public void run() {
                    for (Stanza ackedStanza : ackedStanzas) {
                        StanzaListener listener2;
                        for (StanzaListener listener2 : XMPPTCPConnection.this.stanzaAcknowledgedListeners) {
                            try {
                                listener2.processPacket(ackedStanza);
                            }
                            catch (InterruptedException | SmackException.NotConnectedException e) {
                                LOGGER.log(Level.FINER, "Received exception", e);
                            }
                        }
                        String id = ackedStanza.getStanzaId();
                        if (StringUtils.isNullOrEmpty((CharSequence)id) || (listener2 = (StanzaListener)XMPPTCPConnection.this.stanzaIdAcknowledgedListeners.remove(id)) == null) continue;
                        try {
                            listener2.processPacket(ackedStanza);
                        }
                        catch (InterruptedException | SmackException.NotConnectedException e) {
                            LOGGER.log(Level.FINER, "Received exception", e);
                        }
                    }
                }
            });
        }
        this.serverHandledStanzasCount = handledCount;
    }

    public static void setDefaultBundleAndDeferCallback(BundleAndDeferCallback defaultBundleAndDeferCallback) {
        XMPPTCPConnection.defaultBundleAndDeferCallback = defaultBundleAndDeferCallback;
    }

    public void setBundleandDeferCallback(BundleAndDeferCallback bundleAndDeferCallback) {
        this.bundleAndDeferCallback = bundleAndDeferCallback;
    }

    static {
        useSmDefault = true;
        useSmResumptionDefault = true;
    }

    protected class PacketWriter {
        public static final int QUEUE_SIZE = 500;
        private final ArrayBlockingQueueWithShutdown<Element> queue = new ArrayBlockingQueueWithShutdown(500, true);
        protected SynchronizationPoint<SmackException.NoResponseException> shutdownDone = new SynchronizationPoint((AbstractXMPPConnection)XMPPTCPConnection.this, "shutdown completed");
        protected volatile Long shutdownTimestamp = null;
        private volatile boolean instantShutdown;
        private boolean shouldBundleAndDefer;

        protected PacketWriter() {
        }

        void init() {
            this.shutdownDone.init();
            this.shutdownTimestamp = null;
            if (XMPPTCPConnection.this.unacknowledgedStanzas != null) {
                this.drainWriterQueueToUnacknowledgedStanzas();
            }
            this.queue.start();
            Async.go((Runnable)new Runnable(){

                @Override
                public void run() {
                    PacketWriter.this.writePackets();
                }
            }, (String)("Smack Packet Writer (" + XMPPTCPConnection.this.getConnectionCounter() + ")"));
        }

        private boolean done() {
            return this.shutdownTimestamp != null;
        }

        protected void throwNotConnectedExceptionIfDoneAndResumptionNotPossible() throws SmackException.NotConnectedException {
            boolean smResumptionPossbile;
            boolean done = this.done();
            if (done && !(smResumptionPossbile = XMPPTCPConnection.this.isSmResumptionPossible())) {
                throw new SmackException.NotConnectedException((XMPPConnection)XMPPTCPConnection.this, "done=" + done + " smResumptionPossible=" + smResumptionPossbile);
            }
        }

        protected void sendStreamElement(Element element) throws SmackException.NotConnectedException, InterruptedException {
            this.throwNotConnectedExceptionIfDoneAndResumptionNotPossible();
            try {
                this.queue.put((Object)element);
            }
            catch (InterruptedException e) {
                this.throwNotConnectedExceptionIfDoneAndResumptionNotPossible();
                throw e;
            }
        }

        void shutdown(boolean instant) {
            this.instantShutdown = instant;
            this.queue.shutdown();
            this.shutdownTimestamp = System.currentTimeMillis();
            try {
                this.shutdownDone.checkIfSuccessOrWait();
            }
            catch (InterruptedException | SmackException.NoResponseException e) {
                LOGGER.log(Level.WARNING, "shutdownDone was not marked as successful by the writer thread", e);
            }
        }

        private Element nextStreamElement() {
            Element packet;
            block3: {
                if (this.queue.isEmpty()) {
                    this.shouldBundleAndDefer = true;
                }
                packet = null;
                try {
                    packet = (Element)this.queue.take();
                }
                catch (InterruptedException e) {
                    if (this.queue.isShutdown()) break block3;
                    LOGGER.log(Level.WARNING, "Packet writer thread was interrupted. Don't do that. Use disconnect() instead.", e);
                }
            }
            return packet;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writePackets() {
            block31: {
                try {
                    XMPPTCPConnection.this.openStream();
                    XMPPTCPConnection.this.initalOpenStreamSend.reportSuccess();
                    while (!this.done()) {
                        CharSequence elementXml;
                        Element element = this.nextStreamElement();
                        if (element == null) continue;
                        BundleAndDeferCallback localBundleAndDeferCallback = XMPPTCPConnection.this.bundleAndDeferCallback;
                        if (localBundleAndDeferCallback != null && XMPPTCPConnection.this.isAuthenticated() && this.shouldBundleAndDefer) {
                            this.shouldBundleAndDefer = false;
                            AtomicBoolean bundlingAndDeferringStopped = new AtomicBoolean();
                            int bundleAndDeferMillis = localBundleAndDeferCallback.getBundleAndDeferMillis(new BundleAndDefer(bundlingAndDeferringStopped));
                            if (bundleAndDeferMillis > 0) {
                                long remainingWait = bundleAndDeferMillis;
                                long waitStart = System.currentTimeMillis();
                                AtomicBoolean atomicBoolean = bundlingAndDeferringStopped;
                                synchronized (atomicBoolean) {
                                    while (!bundlingAndDeferringStopped.get() && remainingWait > 0L) {
                                        bundlingAndDeferringStopped.wait(remainingWait);
                                        remainingWait = (long)bundleAndDeferMillis - (System.currentTimeMillis() - waitStart);
                                    }
                                }
                            }
                        }
                        Stanza packet = null;
                        if (element instanceof Stanza) {
                            packet = (Stanza)element;
                        } else if (element instanceof StreamManagement.Enable) {
                            XMPPTCPConnection.this.unacknowledgedStanzas = new ArrayBlockingQueue(500);
                        }
                        if (XMPPTCPConnection.this.unacknowledgedStanzas != null && packet != null) {
                            if ((double)XMPPTCPConnection.this.unacknowledgedStanzas.size() == 400.0) {
                                XMPPTCPConnection.this.writer.write(StreamManagement.AckRequest.INSTANCE.toXML().toString());
                                XMPPTCPConnection.this.writer.flush();
                            }
                            try {
                                XMPPTCPConnection.this.unacknowledgedStanzas.put(packet);
                            }
                            catch (InterruptedException e) {
                                throw new IllegalStateException(e);
                            }
                        }
                        if ((elementXml = element.toXML()) instanceof XmlStringBuilder) {
                            ((XmlStringBuilder)elementXml).write(XMPPTCPConnection.this.writer);
                        } else {
                            XMPPTCPConnection.this.writer.write(elementXml.toString());
                        }
                        if (this.queue.isEmpty()) {
                            XMPPTCPConnection.this.writer.flush();
                        }
                        if (packet == null) continue;
                        XMPPTCPConnection.this.firePacketSendingListeners(packet);
                    }
                    if (!this.instantShutdown) {
                        try {
                            while (!this.queue.isEmpty()) {
                                Element packet = (Element)this.queue.remove();
                                XMPPTCPConnection.this.writer.write(packet.toXML().toString());
                            }
                            XMPPTCPConnection.this.writer.flush();
                        }
                        catch (Exception e) {
                            LOGGER.log(Level.WARNING, "Exception flushing queue during shutdown, ignore and continue", e);
                        }
                        try {
                            XMPPTCPConnection.this.writer.write("</stream:stream>");
                            XMPPTCPConnection.this.writer.flush();
                        }
                        catch (Exception e) {
                            LOGGER.log(Level.WARNING, "Exception writing closing stream element", e);
                        }
                        this.queue.clear();
                        break block31;
                    }
                    if (this.instantShutdown && XMPPTCPConnection.this.isSmEnabled()) {
                        this.drainWriterQueueToUnacknowledgedStanzas();
                    }
                }
                catch (Exception e) {
                    if (!this.done() && !this.queue.isShutdown()) {
                        XMPPTCPConnection.this.notifyConnectionError(e);
                    } else {
                        LOGGER.log(Level.FINE, "Ignoring Exception in writePackets()", e);
                    }
                }
                finally {
                    LOGGER.fine("Reporting shutdownDone success in writer thread");
                    this.shutdownDone.reportSuccess();
                }
            }
        }

        private void drainWriterQueueToUnacknowledgedStanzas() {
            ArrayList elements = new ArrayList(this.queue.size());
            this.queue.drainTo(elements);
            for (Element element : elements) {
                if (!(element instanceof Stanza)) continue;
                XMPPTCPConnection.this.unacknowledgedStanzas.add((Stanza)element);
            }
        }
    }

    protected class PacketReader {
        XmlPullParser parser;
        private volatile boolean done;

        protected PacketReader() {
        }

        void init() {
            this.done = false;
            Async.go((Runnable)new Runnable(){

                @Override
                public void run() {
                    PacketReader.this.parsePackets();
                }
            }, (String)("Smack Packet Reader (" + XMPPTCPConnection.this.getConnectionCounter() + ")"));
        }

        void shutdown() {
            this.done = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void parsePackets() {
            block69: {
                try {
                    XMPPTCPConnection.this.initalOpenStreamSend.checkIfSuccessOrWait();
                    int eventType = this.parser.getEventType();
                    while (!this.done) {
                        block3 : switch (eventType) {
                            case 2: {
                                String name;
                                block26 : switch (name = this.parser.getName()) {
                                    case "message": 
                                    case "iq": 
                                    case "presence": {
                                        try {
                                            XMPPTCPConnection.this.parseAndProcessStanza(this.parser);
                                            break block3;
                                        }
                                        finally {
                                            XMPPTCPConnection.this.clientHandledStanzasCount = SMUtils.incrementHeight(XMPPTCPConnection.this.clientHandledStanzasCount);
                                        }
                                    }
                                    case "stream": {
                                        if (!"jabber:client".equals(this.parser.getNamespace(null))) break block3;
                                        XMPPTCPConnection.this.streamId = this.parser.getAttributeValue("", "id");
                                        String reportedServerDomain = this.parser.getAttributeValue("", "from");
                                        assert (XMPPTCPConnection.this.config.getXMPPServiceDomain().equals(reportedServerDomain));
                                        break block3;
                                    }
                                    case "error": {
                                        throw new XMPPException.StreamErrorException(PacketParserUtils.parseStreamError((XmlPullParser)this.parser));
                                    }
                                    case "features": {
                                        XMPPTCPConnection.this.parseFeatures(this.parser);
                                        break;
                                    }
                                    case "proceed": {
                                        try {
                                            XMPPTCPConnection.this.proceedTLSReceived();
                                            XMPPTCPConnection.this.openStream();
                                            break;
                                        }
                                        catch (Exception e) {
                                            XMPPTCPConnection.this.saslFeatureReceived.reportFailure((Exception)new SmackException((Throwable)e));
                                            throw e;
                                        }
                                    }
                                    case "failure": {
                                        String namespace;
                                        switch (namespace = this.parser.getNamespace(null)) {
                                            case "urn:ietf:params:xml:ns:xmpp-tls": {
                                                throw new SmackException("TLS negotiation has failed");
                                            }
                                            case "http://jabber.org/protocol/compress": {
                                                XMPPTCPConnection.this.compressSyncPoint.reportFailure((Exception)new SmackException("Could not establish compression"));
                                                break block26;
                                            }
                                            case "urn:ietf:params:xml:ns:xmpp-sasl": {
                                                SaslStreamElements.SASLFailure failure = PacketParserUtils.parseSASLFailure((XmlPullParser)this.parser);
                                                XMPPTCPConnection.this.getSASLAuthentication().authenticationFailed(failure);
                                            }
                                        }
                                        break;
                                    }
                                    case "challenge": {
                                        String challengeData = this.parser.nextText();
                                        XMPPTCPConnection.this.getSASLAuthentication().challengeReceived(challengeData);
                                        break;
                                    }
                                    case "success": {
                                        SaslStreamElements.Success success = new SaslStreamElements.Success(this.parser.nextText());
                                        XMPPTCPConnection.this.openStream();
                                        XMPPTCPConnection.this.getSASLAuthentication().authenticated(success);
                                        break;
                                    }
                                    case "compressed": {
                                        XMPPTCPConnection.this.initReaderAndWriter();
                                        XMPPTCPConnection.this.openStream();
                                        XMPPTCPConnection.this.compressSyncPoint.reportSuccess();
                                        break;
                                    }
                                    case "enabled": {
                                        StreamManagement.Enabled enabled = ParseStreamManagement.enabled(this.parser);
                                        if (enabled.isResumeSet()) {
                                            XMPPTCPConnection.this.smSessionId = enabled.getId();
                                            if (StringUtils.isNullOrEmpty((CharSequence)XMPPTCPConnection.this.smSessionId)) {
                                                XMPPError.Builder builder = XMPPError.getBuilder((XMPPError.Condition)XMPPError.Condition.bad_request);
                                                builder.setDescriptiveEnText("Stream Management 'enabled' element with resume attribute but without session id received");
                                                XMPPException.XMPPErrorException xmppException = new XMPPException.XMPPErrorException(builder);
                                                XMPPTCPConnection.this.smEnabledSyncPoint.reportFailure((Exception)xmppException);
                                                throw xmppException;
                                            }
                                            XMPPTCPConnection.this.smServerMaxResumptimTime = enabled.getMaxResumptionTime();
                                        } else {
                                            XMPPTCPConnection.this.smSessionId = null;
                                        }
                                        XMPPTCPConnection.this.clientHandledStanzasCount = 0L;
                                        XMPPTCPConnection.this.smWasEnabledAtLeastOnce = true;
                                        XMPPTCPConnection.this.smEnabledSyncPoint.reportSuccess();
                                        LOGGER.fine("Stream Management (XEP-198): succesfully enabled");
                                        break;
                                    }
                                    case "failed": {
                                        StreamManagement.Failed failed = ParseStreamManagement.failed(this.parser);
                                        XMPPError.Builder xmppError = XMPPError.getBuilder((XMPPError.Condition)failed.getXMPPErrorCondition());
                                        XMPPException.XMPPErrorException xmppException = new XMPPException.XMPPErrorException(xmppError);
                                        if (XMPPTCPConnection.this.smResumedSyncPoint.requestSent()) {
                                            XMPPTCPConnection.this.smResumedSyncPoint.reportFailure((Exception)xmppException);
                                            break;
                                        }
                                        if (!XMPPTCPConnection.this.smEnabledSyncPoint.requestSent()) {
                                            throw new IllegalStateException("Failed element received but SM was not previously enabled");
                                        }
                                        XMPPTCPConnection.this.smEnabledSyncPoint.reportFailure((Exception)xmppException);
                                        XMPPTCPConnection.this.lastFeaturesReceived.reportSuccess();
                                        break;
                                    }
                                    case "resumed": {
                                        StreamManagement.Resumed resumed = ParseStreamManagement.resumed(this.parser);
                                        if (!XMPPTCPConnection.this.smSessionId.equals(resumed.getPrevId())) {
                                            throw new StreamManagementException.StreamIdDoesNotMatchException(XMPPTCPConnection.this.smSessionId, resumed.getPrevId());
                                        }
                                        XMPPTCPConnection.this.smResumedSyncPoint.reportSuccess();
                                        XMPPTCPConnection.this.smEnabledSyncPoint.reportSuccess();
                                        XMPPTCPConnection.this.processHandledCount(resumed.getHandledCount());
                                        ArrayList stanzasToResend = new ArrayList(XMPPTCPConnection.this.unacknowledgedStanzas.size());
                                        XMPPTCPConnection.this.unacknowledgedStanzas.drainTo(stanzasToResend);
                                        for (Stanza stanza : stanzasToResend) {
                                            XMPPTCPConnection.this.sendStanzaInternal(stanza);
                                        }
                                        if (!stanzasToResend.isEmpty()) {
                                            XMPPTCPConnection.this.requestSmAcknowledgementInternal();
                                        }
                                        LOGGER.fine("Stream Management (XEP-198): Stream resumed");
                                        break;
                                    }
                                    case "a": {
                                        StreamManagement.AckAnswer ackAnswer = ParseStreamManagement.ackAnswer(this.parser);
                                        XMPPTCPConnection.this.processHandledCount(ackAnswer.getHandledCount());
                                        break;
                                    }
                                    case "r": {
                                        ParseStreamManagement.ackRequest(this.parser);
                                        if (XMPPTCPConnection.this.smEnabledSyncPoint.wasSuccessful()) {
                                            XMPPTCPConnection.this.sendSmAcknowledgementInternal();
                                            break;
                                        }
                                        LOGGER.warning("SM Ack Request received while SM is not enabled");
                                        break;
                                    }
                                    default: {
                                        LOGGER.warning("Unknown top level stream element: " + name);
                                        break;
                                    }
                                }
                                break;
                            }
                            case 3: {
                                if (!this.parser.getName().equals("stream")) break;
                                if (!this.parser.getNamespace().equals("http://etherx.jabber.org/streams")) {
                                    LOGGER.warning((Object)((Object)XMPPTCPConnection.this) + " </stream> but different namespace " + this.parser.getNamespace());
                                    break;
                                }
                                boolean queueWasShutdown = XMPPTCPConnection.this.packetWriter.queue.isShutdown();
                                XMPPTCPConnection.this.closingStreamReceived.reportSuccess();
                                if (queueWasShutdown) {
                                    return;
                                }
                                LOGGER.info((Object)((Object)XMPPTCPConnection.this) + " received closing </stream> element." + " Server wants to terminate the connection, calling disconnect()");
                                XMPPTCPConnection.this.disconnect();
                                break;
                            }
                            case 1: {
                                throw new SmackException("Parser got END_DOCUMENT event. This could happen e.g. if the server closed the connection without sending a closing stream element");
                            }
                        }
                        eventType = this.parser.next();
                    }
                }
                catch (Exception e) {
                    XMPPTCPConnection.this.closingStreamReceived.reportFailure(e);
                    if (this.done || XMPPTCPConnection.this.packetWriter.queue.isShutdown()) break block69;
                    XMPPTCPConnection.this.notifyConnectionError(e);
                }
            }
        }
    }
}

