/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.sm.provider;

import com.jamesmurty.utils.XMLBuilder;
import java.io.IOException;
import java.util.Properties;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.sm.packet.StreamManagement;
import org.jivesoftware.smack.sm.provider.ParseStreamManagement;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.junit.Assert;
import org.junit.Test;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ParseStreamManagementTest {
    private static final Properties outputProperties = ParseStreamManagementTest.initOutputProperties();

    @Test
    public void testParseEnabled() throws Exception {
        String stanzaID = "zid615d9";
        boolean resume = true;
        String location = "test";
        int max = 42;
        String enabledStanza = XMLBuilder.create((String)"enabled").a("xmlns", "urn:xmpp:sm:3").a("id", "zid615d9").a("resume", String.valueOf(resume)).a("location", location).a("max", String.valueOf(max)).asString(outputProperties);
        StreamManagement.Enabled enabledPacket = ParseStreamManagement.enabled((XmlPullParser)PacketParserUtils.getParserFor((String)enabledStanza));
        Assert.assertThat((Object)enabledPacket, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)enabledPacket.getId(), (Matcher)CoreMatchers.equalTo((Object)stanzaID));
        Assert.assertThat((Object)enabledPacket.getLocation(), (Matcher)CoreMatchers.equalTo((Object)location));
        Assert.assertThat((Object)enabledPacket.isResumeSet(), (Matcher)CoreMatchers.equalTo((Object)resume));
        Assert.assertThat((Object)enabledPacket.getMaxResumptionTime(), (Matcher)CoreMatchers.equalTo((Object)max));
    }

    @Test
    public void testParseEnabledInvariant() throws XmlPullParserException, IOException {
        String enabledString = new StreamManagement.Enabled("stream-id", false).toXML().toString();
        XmlPullParser parser = PacketParserUtils.getParserFor((String)enabledString);
        StreamManagement.Enabled enabled = ParseStreamManagement.enabled((XmlPullParser)parser);
        Assert.assertEquals((Object)enabledString, (Object)enabled.toXML().toString());
    }

    @Test
    public void testParseFailed() throws Exception {
        String failedStanza = XMLBuilder.create((String)"failed").a("xmlns", "urn:xmpp:sm:3").asString(outputProperties);
        StreamManagement.Failed failedPacket = ParseStreamManagement.failed((XmlPullParser)PacketParserUtils.getParserFor((String)failedStanza));
        Assert.assertThat((Object)failedPacket, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertTrue((failedPacket.getXMPPErrorCondition() == null ? 1 : 0) != 0);
    }

    @Test
    public void testParseFailedError() throws Exception {
        XMPPError.Condition errorCondition = XMPPError.Condition.unexpected_request;
        String failedStanza = XMLBuilder.create((String)"failed").a("xmlns", "urn:xmpp:sm:3").element(errorCondition.toString(), "urn:ietf:params:xml:ns:xmpp-stanzas").asString(outputProperties);
        StreamManagement.Failed failedPacket = ParseStreamManagement.failed((XmlPullParser)PacketParserUtils.getParserFor((String)failedStanza));
        Assert.assertThat((Object)failedPacket, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertTrue((failedPacket.getXMPPErrorCondition() == errorCondition ? 1 : 0) != 0);
    }

    @Test
    public void testParseResumed() throws Exception {
        long handledPackets = 42L;
        String previousID = "zid615d9";
        String resumedStanza = XMLBuilder.create((String)"resumed").a("xmlns", "urn:xmpp:sm:3").a("h", String.valueOf(handledPackets)).a("previd", previousID).asString(outputProperties);
        StreamManagement.Resumed resumedPacket = ParseStreamManagement.resumed((XmlPullParser)PacketParserUtils.getParserFor((String)resumedStanza));
        Assert.assertThat((Object)resumedPacket, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)resumedPacket.getHandledCount(), (Matcher)CoreMatchers.equalTo((Object)handledPackets));
        Assert.assertThat((Object)resumedPacket.getPrevId(), (Matcher)CoreMatchers.equalTo((Object)previousID));
    }

    @Test
    public void testParseAckAnswer() throws Exception {
        long handledPackets = 84L;
        String ackStanza = XMLBuilder.create((String)"a").a("xmlns", "urn:xmpp:sm:3").a("h", String.valueOf(handledPackets)).asString(outputProperties);
        StreamManagement.AckAnswer acknowledgementPacket = ParseStreamManagement.ackAnswer((XmlPullParser)PacketParserUtils.getParserFor((String)ackStanza));
        Assert.assertThat((Object)acknowledgementPacket, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)acknowledgementPacket.getHandledCount(), (Matcher)CoreMatchers.equalTo((Object)handledPackets));
    }

    private static Properties initOutputProperties() {
        Properties properties = new Properties();
        properties.put("omit-xml-declaration", "yes");
        return properties;
    }
}

