/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.tcp;

import java.io.IOException;
import java.io.Writer;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.packet.Element;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.tcp.XMPPTCPConnection;
import org.junit.Assert;
import org.junit.Test;
import org.jxmpp.stringprep.XmppStringprepException;

public class PacketWriterTest {
    private volatile boolean shutdown;
    private volatile boolean prematureUnblocked;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldBlockAndUnblockTest() throws InterruptedException, BrokenBarrierException, SmackException.NotConnectedException, XmppStringprepException {
        XMPPTCPConnection.PacketWriter pw;
        XMPPTCPConnection connection = new XMPPTCPConnection((CharSequence)"user", "pass", "example.org");
        connection.packetWriter = pw = new XMPPTCPConnection.PacketWriter(connection);
        connection.packetReader = new XMPPTCPConnection.PacketReader(connection);
        connection.setWriter((Writer)new BlockingStringWriter());
        pw.init();
        for (int i = 0; i < 500; ++i) {
            pw.sendStreamElement((Element)new Message());
        }
        final CyclicBarrier barrier = new CyclicBarrier(2);
        this.shutdown = false;
        this.prematureUnblocked = false;
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    barrier.await();
                    pw.sendStreamElement((Element)new Message());
                    if (!PacketWriterTest.this.shutdown) {
                        PacketWriterTest.this.prematureUnblocked = true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    barrier.await();
                }
                catch (InterruptedException | BrokenBarrierException exception) {
                    // empty catch block
                }
            }
        });
        t.start();
        barrier.await();
        Thread.sleep(250L);
        pw.shutdownDone.reportSuccess();
        pw.shutdown(false);
        this.shutdown = true;
        barrier.await();
        if (this.prematureUnblocked) {
            Assert.fail((String)"Should not unblock before the thread got shutdown");
        }
        Thread thread = t;
        synchronized (thread) {
            t.notify();
        }
    }

    public class BlockingStringWriter
    extends Writer {
        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }
    }
}

