/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.tcp.rce;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.datatypes.UInt16;
import org.jivesoftware.smack.tcp.rce.IpTcpRemoteConnectionEndpoint;
import org.jivesoftware.smack.tcp.rce.RemoteXmppTcpConnectionEndpoints;
import org.jivesoftware.smack.util.rce.RemoteConnectionException;
import org.jivesoftware.smack.util.rce.SingleAddressRemoteConnectionEndpoint;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.minidns.record.A;
import org.minidns.record.InternetAddressRR;

public class RemoteXmppTcpConnectionEndpointsTest {
    @Test
    public void simpleDomainTypeTest() {
        RemoteXmppTcpConnectionEndpoints.DomainType client = RemoteXmppTcpConnectionEndpoints.DomainType.client;
        Assertions.assertEquals((Object)"_xmpp-client._tcp", (Object)client.srvPrefix.ace);
        RemoteXmppTcpConnectionEndpoints.DomainType server = RemoteXmppTcpConnectionEndpoints.DomainType.server;
        Assertions.assertEquals((Object)"_xmpp-server._tcp", (Object)server.srvPrefix.ace);
    }

    @Test
    public void testConnectionException() {
        ArrayList<RemoteConnectionException> connectionExceptions = new ArrayList<RemoteConnectionException>();
        A aRr = new A((CharSequence)"1.2.3.4");
        UInt16 port = UInt16.from((int)1234);
        String host = "example.org";
        IpTcpRemoteConnectionEndpoint remoteConnectionEndpoint = new IpTcpRemoteConnectionEndpoint((CharSequence)host, port, (InternetAddressRR)aRr);
        Exception exception = new Exception("Failed for some reason");
        RemoteConnectionException remoteConnectionException = RemoteConnectionException.from((SingleAddressRemoteConnectionEndpoint)remoteConnectionEndpoint, (Exception)exception);
        connectionExceptions.add(remoteConnectionException);
        aRr = new A((CharSequence)"1.3.3.7");
        port = UInt16.from((int)5678);
        host = "other.example.org";
        remoteConnectionEndpoint = new IpTcpRemoteConnectionEndpoint((CharSequence)host, port, (InternetAddressRR)aRr);
        exception = new Exception("Failed for some other reason");
        remoteConnectionException = RemoteConnectionException.from((SingleAddressRemoteConnectionEndpoint)remoteConnectionEndpoint, (Exception)exception);
        connectionExceptions.add(remoteConnectionException);
        List lookupFailures = Collections.emptyList();
        SmackException.EndpointConnectionException endpointConnectionException = SmackException.EndpointConnectionException.from(lookupFailures, connectionExceptions);
        String message = endpointConnectionException.getMessage();
        Assertions.assertEquals((Object)"The following addresses failed: 'RFC 6120 A/AAAA Endpoint + [example.org:1234] (/1.2.3.4:1234)' failed because: java.lang.Exception: Failed for some reason, 'RFC 6120 A/AAAA Endpoint + [other.example.org:5678] (/1.3.3.7:5678)' failed because: java.lang.Exception: Failed for some other reason", (Object)message);
    }
}

