/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.tcp;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.atomic.AtomicReference;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.packet.Element;
import org.jivesoftware.smack.packet.StanzaBuilder;
import org.jivesoftware.smack.tcp.XMPPTCPConnection;
import org.jivesoftware.smack.util.ExceptionUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.jxmpp.stringprep.XmppStringprepException;

public class PacketWriterTest {
    private static final Reader DUMMY_READER = new StringReader("");
    private volatile boolean shutdown;
    private volatile boolean prematureUnblocked;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldBlockAndUnblockTest() throws InterruptedException, BrokenBarrierException, SmackException.NotConnectedException, XmppStringprepException, NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        XMPPTCPConnection connection = new XMPPTCPConnection((CharSequence)"user", "pass", "example.org");
        Field readerField = AbstractXMPPConnection.class.getDeclaredField("reader");
        readerField.setAccessible(true);
        readerField.set(connection, DUMMY_READER);
        final XMPPTCPConnection.PacketWriter pw = connection.packetWriter;
        BlockingStringWriter blockingStringWriter = new BlockingStringWriter();
        connection.setWriter((Writer)blockingStringWriter);
        connection.packetWriter.init();
        for (int i = 0; i < 501; ++i) {
            pw.sendStreamElement((Element)StanzaBuilder.buildMessage().build());
        }
        final CyclicBarrier barrier = new CyclicBarrier(2);
        final AtomicReference unexpectedThreadExceptionReference = new AtomicReference();
        final AtomicReference expectedThreadExceptionReference = new AtomicReference();
        this.shutdown = false;
        this.prematureUnblocked = false;
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    barrier.await();
                    pw.sendStreamElement((Element)StanzaBuilder.buildMessage().build());
                    if (!PacketWriterTest.this.shutdown) {
                        PacketWriterTest.this.prematureUnblocked = true;
                    }
                }
                catch (InterruptedException | SmackException.NotConnectedException e) {
                    expectedThreadExceptionReference.set(e);
                }
                catch (BrokenBarrierException e) {
                    unexpectedThreadExceptionReference.set(e);
                }
                try {
                    barrier.await();
                }
                catch (InterruptedException | BrokenBarrierException e) {
                    unexpectedThreadExceptionReference.set(e);
                }
            }
        });
        t.start();
        barrier.await();
        Thread.sleep(250L);
        pw.shutdown(false);
        this.shutdown = true;
        barrier.await();
        t.join(60000L);
        Exception unexpectedThreadException = (Exception)unexpectedThreadExceptionReference.get();
        try {
            if (this.prematureUnblocked) {
                Object failureMessage = "Should not unblock before the thread got shutdown.";
                if (unexpectedThreadException != null) {
                    String stacktrace = ExceptionUtil.getStackTrace((Throwable)unexpectedThreadException);
                    failureMessage = (String)failureMessage + " Unexpected thread exception thrown: " + unexpectedThreadException + "\n" + stacktrace;
                }
                Assertions.fail((String)failureMessage);
            } else if (unexpectedThreadException != null) {
                String stacktrace = ExceptionUtil.getStackTrace((Throwable)unexpectedThreadException);
                Assertions.fail((String)("Unexpected thread exception: " + unexpectedThreadException + "\n" + stacktrace));
            }
            Assertions.assertNotNull(expectedThreadExceptionReference.get(), (String)"Did not encounter expected exception on sendStreamElement()");
        }
        finally {
            blockingStringWriter.unblock();
        }
    }

    public static class BlockingStringWriter
    extends Writer {
        private boolean blocked = true;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            BlockingStringWriter blockingStringWriter = this;
            synchronized (blockingStringWriter) {
                while (this.blocked) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        throw new AssertionError((Object)e);
                    }
                }
            }
        }

        public synchronized void unblock() {
            this.blocked = false;
            this.notify();
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }
    }
}

