/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.tcp;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.SmackFuture;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.compress.packet.Compress;
import org.jivesoftware.smack.compression.XMPPInputOutputStream;
import org.jivesoftware.smack.datatypes.UInt16;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.internal.SmackTlsContext;
import org.jivesoftware.smack.packet.Element;
import org.jivesoftware.smack.packet.Nonza;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StartTls;
import org.jivesoftware.smack.packet.StreamError;
import org.jivesoftware.smack.packet.TopLevelStreamElement;
import org.jivesoftware.smack.proxy.ProxyInfo;
import org.jivesoftware.smack.sasl.packet.SaslNonza;
import org.jivesoftware.smack.sm.SMUtils;
import org.jivesoftware.smack.sm.StreamManagementException;
import org.jivesoftware.smack.sm.packet.StreamManagement;
import org.jivesoftware.smack.sm.predicates.Predicate;
import org.jivesoftware.smack.sm.provider.ParseStreamManagement;
import org.jivesoftware.smack.tcp.BundleAndDefer;
import org.jivesoftware.smack.tcp.BundleAndDeferCallback;
import org.jivesoftware.smack.tcp.XMPPTCPConnectionConfiguration;
import org.jivesoftware.smack.tcp.rce.RemoteXmppTcpConnectionEndpoints;
import org.jivesoftware.smack.tcp.rce.Rfc6120TcpRemoteConnectionEndpoint;
import org.jivesoftware.smack.util.ArrayBlockingQueueWithShutdown;
import org.jivesoftware.smack.util.Async;
import org.jivesoftware.smack.util.CloseableUtil;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.TLSUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smack.util.rce.RemoteConnectionEndpoint;
import org.jivesoftware.smack.util.rce.RemoteConnectionException;
import org.jivesoftware.smack.xml.SmackXmlParser;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.jid.parts.Resourcepart;
import org.jxmpp.stringprep.XmppStringprepException;
import org.minidns.dnsname.DnsName;

public class XMPPTCPConnection
extends AbstractXMPPConnection {
    private static final int QUEUE_SIZE = 500;
    private static final Logger LOGGER = Logger.getLogger(XMPPTCPConnection.class.getName());
    private Socket socket;
    private boolean disconnectedButResumeable = false;
    private SSLSocket secureSocket;
    protected final PacketWriter packetWriter = new PacketWriter();
    protected final PacketReader packetReader = new PacketReader();
    private boolean streamFeaturesAfterAuthenticationReceived;
    private boolean compressSyncPoint;
    private static BundleAndDeferCallback defaultBundleAndDeferCallback;
    private BundleAndDeferCallback bundleAndDeferCallback = defaultBundleAndDeferCallback;
    private static boolean useSmDefault;
    private static boolean useSmResumptionDefault;
    private String smSessionId;
    private volatile AbstractXMPPConnection.SyncPointState smResumedSyncPoint;
    private StreamManagement.Failed smResumptionFailed;
    private volatile boolean smEnabledSyncPoint;
    private int smClientMaxResumptionTime = -1;
    private int smServerMaxResumptionTime = -1;
    private boolean useSm = useSmDefault;
    private boolean useSmResumption = useSmResumptionDefault;
    private long serverHandledStanzasCount = 0L;
    private long clientHandledStanzasCount = 0L;
    private BlockingQueue<Stanza> unacknowledgedStanzas;
    private boolean smWasEnabledAtLeastOnce = false;
    private final Collection<StanzaListener> stanzaAcknowledgedListeners = new ConcurrentLinkedQueue<StanzaListener>();
    private final Collection<StanzaListener> stanzaDroppedListeners = new ConcurrentLinkedQueue<StanzaListener>();
    private final Map<String, StanzaListener> stanzaIdAcknowledgedListeners = new ConcurrentHashMap<String, StanzaListener>();
    private final Set<StanzaFilter> requestAckPredicates = new LinkedHashSet<StanzaFilter>();
    private final XMPPTCPConnectionConfiguration config;

    public XMPPTCPConnection(XMPPTCPConnectionConfiguration config) {
        super((ConnectionConfiguration)config);
        this.config = config;
        this.addConnectionListener(new ConnectionListener(){

            public void connectionClosedOnError(Exception e) {
                if (e instanceof XMPPException.StreamErrorException || e instanceof StreamManagementException) {
                    XMPPTCPConnection.this.dropSmState();
                }
            }
        });
        this.buildNonzaCallback().listenFor(SaslNonza.Success.class, s -> this.resetParser()).install();
    }

    public XMPPTCPConnection(CharSequence jid, String password) throws XmppStringprepException {
        this(((XMPPTCPConnectionConfiguration.Builder)XMPPTCPConnectionConfiguration.builder().setXmppAddressAndPassword(jid, password)).build());
    }

    public XMPPTCPConnection(CharSequence username, String password, String serviceName) throws XmppStringprepException {
        this(((XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)XMPPTCPConnectionConfiguration.builder().setUsernameAndPassword(username, password)).setXmppDomain(JidCreate.domainBareFrom((String)serviceName))).build());
    }

    protected void throwNotConnectedExceptionIfAppropriate() throws SmackException.NotConnectedException {
        if (this.packetWriter == null) {
            throw new SmackException.NotConnectedException();
        }
        this.packetWriter.throwNotConnectedExceptionIfDoneAndResumptionNotPossible();
    }

    protected void throwAlreadyConnectedExceptionIfAppropriate() throws SmackException.AlreadyConnectedException {
        if (this.isConnected() && !this.disconnectedButResumeable) {
            throw new SmackException.AlreadyConnectedException();
        }
    }

    protected void throwAlreadyLoggedInExceptionIfAppropriate() throws SmackException.AlreadyLoggedInException {
        if (this.isAuthenticated() && !this.disconnectedButResumeable) {
            throw new SmackException.AlreadyLoggedInException();
        }
    }

    protected void afterSuccessfulLogin(boolean resumed) throws SmackException.NotConnectedException, InterruptedException {
        this.disconnectedButResumeable = false;
        super.afterSuccessfulLogin(resumed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void loginInternal(String username, String password, Resourcepart resource) throws XMPPException, SmackException, IOException, InterruptedException {
        SSLSession sslSession = this.secureSocket != null ? this.secureSocket.getSession() : null;
        this.streamFeaturesAfterAuthenticationReceived = false;
        this.authenticate(username, password, this.config.getAuthzid(), sslSession);
        this.waitForConditionOrThrowConnectionException(() -> this.streamFeaturesAfterAuthenticationReceived, "compress features from server");
        this.maybeEnableCompression();
        this.smResumedSyncPoint = AbstractXMPPConnection.SyncPointState.initial;
        this.smResumptionFailed = null;
        if (this.isSmResumptionPossible()) {
            this.smResumedSyncPoint = AbstractXMPPConnection.SyncPointState.request_sent;
            this.sendNonza((Nonza)new StreamManagement.Resume(this.clientHandledStanzasCount, this.smSessionId));
            this.waitForConditionOrThrowConnectionException(() -> this.smResumedSyncPoint == AbstractXMPPConnection.SyncPointState.successful || this.smResumptionFailed != null, "resume previous stream");
            if (this.smResumedSyncPoint == AbstractXMPPConnection.SyncPointState.successful) {
                this.afterSuccessfulLogin(true);
                return;
            }
            assert (this.smResumptionFailed != null);
            LOGGER.fine("Stream resumption failed, continuing with normal stream establishment process: " + String.valueOf(this.smResumptionFailed));
        }
        this.smEnabledSyncPoint = false;
        ArrayList previouslyUnackedStanzas = new ArrayList();
        if (this.unacknowledgedStanzas != null) {
            this.unacknowledgedStanzas.drainTo(previouslyUnackedStanzas);
            this.dropSmState();
        }
        this.bindResourceAndEstablishSession(resource);
        if (this.isSmAvailable() && this.useSm) {
            this.serverHandledStanzasCount = 0L;
            this.sendNonza((Nonza)new StreamManagement.Enable(this.useSmResumption, this.smClientMaxResumptionTime));
            this.waitForConditionOrThrowConnectionException(() -> this.smEnabledSyncPoint, "enabling stream mangement");
            Set<StanzaFilter> set = this.requestAckPredicates;
            synchronized (set) {
                if (this.requestAckPredicates.isEmpty()) {
                    this.requestAckPredicates.add(Predicate.forMessagesOrAfter5Stanzas());
                }
            }
        }
        if (!this.stanzaDroppedListeners.isEmpty()) {
            for (Stanza stanza : previouslyUnackedStanzas) {
                for (StanzaListener listener : this.stanzaDroppedListeners) {
                    try {
                        listener.processStanza(stanza);
                    }
                    catch (InterruptedException | SmackException.NotConnectedException | SmackException.NotLoggedInException e) {
                        LOGGER.log(Level.FINER, "StanzaDroppedListener received exception", e);
                    }
                }
            }
        } else {
            for (Stanza stanza : previouslyUnackedStanzas) {
                this.sendInternal((TopLevelStreamElement)stanza);
            }
        }
        this.afterSuccessfulLogin(false);
    }

    public boolean isSecureConnection() {
        return this.secureSocket != null;
    }

    protected void shutdown() {
        if (this.isSmEnabled()) {
            try {
                this.sendSmAcknowledgementInternal();
            }
            catch (InterruptedException | SmackException.NotConnectedException e) {
                LOGGER.log(Level.FINE, "Can not send final SM ack as connection is not connected", e);
            }
        }
        this.shutdown(false);
    }

    public synchronized void instantShutdown() {
        this.shutdown(true);
    }

    private void shutdown(boolean instant) {
        if (!this.packetWriter.done()) {
            LOGGER.finer(this.packetWriter.threadName + " shutdown()");
            this.packetWriter.shutdown(instant);
            LOGGER.finer(this.packetWriter.threadName + " shutdown() returned");
            if (!instant) {
                this.waitForClosingStreamTagFromServer();
            }
        }
        LOGGER.finer(this.packetReader.threadName + " shutdown()");
        this.packetReader.shutdown();
        LOGGER.finer(this.packetReader.threadName + " shutdown() returned");
        CloseableUtil.maybeClose((Closeable)this.socket, (Logger)LOGGER);
        this.setWasAuthenticated();
        try {
            boolean readerAndWriterThreadsTermianted = this.waitFor(() -> !this.packetWriter.running && !this.packetReader.running);
            if (!readerAndWriterThreadsTermianted) {
                LOGGER.severe("Reader and/or writer threads did not terminate timely. Writer running: " + this.packetWriter.running + ", Reader running: " + this.packetReader.running);
            } else {
                LOGGER.fine("Reader and writer threads terminated");
            }
        }
        catch (InterruptedException e) {
            LOGGER.log(Level.FINE, "Interrupted while waiting for reader and writer threads to terminate", e);
        }
        if (this.disconnectedButResumeable) {
            return;
        }
        if (instant) {
            this.disconnectedButResumeable = this.isSmResumptionPossible();
            if (!this.disconnectedButResumeable) {
                this.smSessionId = null;
            }
        } else {
            this.disconnectedButResumeable = false;
            this.dropSmState();
        }
        this.authenticated = false;
        this.connected = false;
        this.secureSocket = null;
        this.reader = null;
        this.writer = null;
        this.initState();
    }

    private <E extends Exception> void requestSmAckIfNecessary(TopLevelStreamElement element, SmAckAction<E> smAckAction) throws SmackException.NotConnectedException, E {
        if (!this.isSmEnabled()) {
            return;
        }
        if (element instanceof Stanza) {
            Stanza stanza = (Stanza)element;
            for (StanzaFilter requestAckPredicate : this.requestAckPredicates) {
                if (!requestAckPredicate.accept(stanza)) continue;
                smAckAction.run();
                break;
            }
        }
    }

    protected void sendInternal(TopLevelStreamElement element) throws SmackException.NotConnectedException, InterruptedException {
        this.packetWriter.sendStreamElement((Element)element);
        this.requestSmAckIfNecessary(element, () -> this.requestSmAcknowledgementInternal());
    }

    protected void sendNonBlockingInternal(TopLevelStreamElement element) throws SmackException.NotConnectedException, SmackException.OutgoingQueueFullException {
        this.packetWriter.sendNonBlocking((Element)element);
        this.requestSmAckIfNecessary(element, () -> this.requestSmAcknowledgementNonBlockingInternal());
    }

    private void connectUsingConfiguration() throws SmackException.ConnectionException, IOException, InterruptedException {
        RemoteXmppTcpConnectionEndpoints.Result<Rfc6120TcpRemoteConnectionEndpoint> result = RemoteXmppTcpConnectionEndpoints.lookup(this.config);
        ArrayList<RemoteConnectionException> connectionExceptions = new ArrayList<RemoteConnectionException>();
        SocketFactory socketFactory = this.config.getSocketFactory();
        ProxyInfo proxyInfo = this.config.getProxyInfo();
        int timeout = this.config.getConnectTimeout();
        if (socketFactory == null) {
            socketFactory = SocketFactory.getDefault();
        }
        block4: for (Rfc6120TcpRemoteConnectionEndpoint endpoint : result.discoveredRemoteConnectionEndpoints) {
            String host = endpoint.getHost().toString();
            UInt16 portUint16 = endpoint.getPort();
            int port = portUint16.intValue();
            if (proxyInfo == null) {
                Iterator inetAddresses = endpoint.getInetAddresses().iterator();
                assert (inetAddresses.hasNext());
                while (inetAddresses.hasNext()) {
                    SmackFuture.SocketFuture socketFuture = new SmackFuture.SocketFuture(socketFactory);
                    InetAddress inetAddress = (InetAddress)inetAddresses.next();
                    InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, port);
                    LOGGER.finer("Trying to establish TCP connection to " + String.valueOf(inetSocketAddress));
                    socketFuture.connectAsync((SocketAddress)inetSocketAddress, timeout);
                    try {
                        this.socket = (Socket)socketFuture.getOrThrow();
                    }
                    catch (IOException e) {
                        RemoteConnectionException rce = new RemoteConnectionException((RemoteConnectionEndpoint)endpoint, inetAddress, (Exception)e);
                        connectionExceptions.add(rce);
                        if (!inetAddresses.hasNext()) continue block4;
                        continue;
                    }
                    LOGGER.finer("Established TCP connection to " + String.valueOf(inetSocketAddress));
                    this.host = host;
                    this.port = portUint16;
                    return;
                }
                continue;
            }
            this.socket = socketFactory.createSocket();
            StringUtils.requireNotNullNorEmpty((CharSequence)host, (String)("Host of endpoint " + String.valueOf(endpoint) + " must not be null when using a Proxy"));
            String hostAndPort = host + " at port " + port;
            LOGGER.finer("Trying to establish TCP connection via Proxy to " + hostAndPort);
            try {
                proxyInfo.getProxySocketConnection().connect(this.socket, host, port, timeout);
            }
            catch (IOException e) {
                CloseableUtil.maybeClose((Closeable)this.socket, (Logger)LOGGER);
                RemoteConnectionException rce = new RemoteConnectionException((RemoteConnectionEndpoint)endpoint, null, (Exception)e);
                connectionExceptions.add(rce);
                continue;
            }
            LOGGER.finer("Established TCP connection to " + hostAndPort);
            this.host = host;
            this.port = portUint16;
            return;
        }
        throw SmackException.EndpointConnectionException.from(result.lookupFailures, connectionExceptions);
    }

    private void initConnection() throws IOException, InterruptedException {
        this.compressionHandler = null;
        this.initReaderAndWriter();
        this.packetWriter.init();
        this.packetReader.init();
    }

    private void initReaderAndWriter() throws IOException {
        InputStream is = this.socket.getInputStream();
        OutputStream os = this.socket.getOutputStream();
        if (this.compressionHandler != null) {
            is = this.compressionHandler.getInputStream(is);
            os = this.compressionHandler.getOutputStream(os);
        }
        this.writer = new OutputStreamWriter(os, "UTF-8");
        this.reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        this.initDebugger();
    }

    private void proceedTLSReceived() throws IOException, SmackException.SecurityNotPossibleException, CertificateException {
        String verifierHostname;
        HostnameVerifier verifier;
        SmackTlsContext smackTlsContext = this.getSmackTlsContext();
        Socket plain = this.socket;
        int port = plain.getPort();
        String xmppServiceDomainString = this.config.getXMPPServiceDomain().toString();
        SSLSocketFactory sslSocketFactory = smackTlsContext.sslContext.getSocketFactory();
        this.socket = sslSocketFactory.createSocket(plain, xmppServiceDomainString, port, true);
        SSLSocket sslSocket = (SSLSocket)this.socket;
        TLSUtils.setEnabledProtocolsAndCiphers((SSLSocket)sslSocket, (String[])this.config.getEnabledSSLProtocols(), (String[])this.config.getEnabledSSLCiphers());
        this.initReaderAndWriter();
        sslSocket.startHandshake();
        if (smackTlsContext.daneVerifier != null) {
            smackTlsContext.daneVerifier.finish(sslSocket.getSession());
        }
        if ((verifier = this.getConfiguration().getHostnameVerifier()) == null) {
            throw new IllegalStateException("No HostnameVerifier set. Use connectionConfiguration.setHostnameVerifier() to configure.");
        }
        DnsName xmppServiceDomainDnsName = this.getConfiguration().getXmppServiceDomainAsDnsNameIfPossible();
        if (xmppServiceDomainDnsName != null) {
            verifierHostname = xmppServiceDomainDnsName.ace;
        } else {
            LOGGER.log(Level.WARNING, "XMPP service domain name '" + String.valueOf(this.getXMPPServiceDomain()) + "' can not be represented as DNS name. TLS X.509 certificate validiation may fail.");
            verifierHostname = this.getXMPPServiceDomain().toString();
        }
        boolean verificationSuccessful = verifier.verify(verifierHostname, sslSocket.getSession());
        if (!verificationSuccessful) {
            throw new CertificateException("Hostname verification of certificate failed. Certificate does not authenticate " + String.valueOf(this.getXMPPServiceDomain()));
        }
        this.secureSocket = sslSocket;
    }

    private static XMPPInputOutputStream maybeGetCompressionHandler(Compress.Feature compression) {
        for (XMPPInputOutputStream handler : SmackConfiguration.getCompressionHandlers()) {
            String method = handler.getCompressionMethod();
            if (!compression.getMethods().contains(method)) continue;
            return handler;
        }
        return null;
    }

    public boolean isUsingCompression() {
        return this.compressionHandler != null && this.compressSyncPoint;
    }

    private void maybeEnableCompression() throws SmackException, InterruptedException, XMPPException {
        if (!this.config.isCompressionEnabled()) {
            return;
        }
        Compress.Feature compression = (Compress.Feature)this.getFeature(Compress.Feature.class);
        if (compression == null) {
            return;
        }
        this.compressionHandler = XMPPTCPConnection.maybeGetCompressionHandler(compression);
        if (this.compressionHandler != null) {
            this.compressSyncPoint = false;
            this.sendNonza((Nonza)new Compress(this.compressionHandler.getCompressionMethod()));
            this.waitForConditionOrThrowConnectionException(() -> this.compressSyncPoint, "establishing stream compression");
        } else {
            LOGGER.warning("Could not enable compression because no matching handler/method pair was found");
        }
    }

    protected void connectInternal() throws SmackException, IOException, XMPPException, InterruptedException {
        this.connectUsingConfiguration();
        this.connected = true;
        this.initConnection();
        this.waitForConditionOrThrowConnectionException(() -> this.tlsHandled, "establishing TLS");
        this.waitForConditionOrThrowConnectionException(() -> this.saslFeatureReceived, "SASL mechanisms stream feature from server");
    }

    protected void setWriter(Writer writer) {
        this.writer = writer;
    }

    protected void afterFeaturesReceived() throws SmackException.NotConnectedException, InterruptedException, SmackException.SecurityRequiredByServerException {
        StartTls startTlsFeature = (StartTls)this.getFeature(StartTls.class);
        if (startTlsFeature != null) {
            if (startTlsFeature.required() && this.config.getSecurityMode() == ConnectionConfiguration.SecurityMode.disabled) {
                SmackException.SecurityRequiredByServerException smackException = new SmackException.SecurityRequiredByServerException();
                this.setCurrentConnectionExceptionAndNotify((Exception)smackException);
                throw smackException;
            }
            if (this.config.getSecurityMode() != ConnectionConfiguration.SecurityMode.disabled) {
                this.sendNonza((Nonza)new StartTls());
            } else {
                this.tlsHandled = true;
                this.notifyWaitingThreads();
            }
        } else {
            this.tlsHandled = true;
            this.notifyWaitingThreads();
        }
        if (this.isSaslAuthenticated()) {
            this.streamFeaturesAfterAuthenticationReceived = true;
            this.notifyWaitingThreads();
        }
    }

    private void resetParser() throws IOException {
        try {
            this.packetReader.parser = SmackXmlParser.newXmlParser((Reader)this.reader);
        }
        catch (XmlPullParserException e) {
            throw new IOException(e);
        }
    }

    private void openStreamAndResetParser() throws IOException, SmackException.NotConnectedException, InterruptedException {
        this.sendStreamOpen();
        this.resetParser();
    }

    public static void setUseStreamManagementDefault(boolean useSmDefault) {
        XMPPTCPConnection.useSmDefault = useSmDefault;
    }

    @Deprecated
    public static void setUseStreamManagementResumptiodDefault(boolean useSmResumptionDefault) {
        XMPPTCPConnection.setUseStreamManagementResumptionDefault(useSmResumptionDefault);
    }

    public static void setUseStreamManagementResumptionDefault(boolean useSmResumptionDefault) {
        if (useSmResumptionDefault) {
            XMPPTCPConnection.setUseStreamManagementDefault(useSmResumptionDefault);
        }
        XMPPTCPConnection.useSmResumptionDefault = useSmResumptionDefault;
    }

    public void setUseStreamManagement(boolean useSm) {
        this.useSm = useSm;
    }

    public void setUseStreamManagementResumption(boolean useSmResumption) {
        if (useSmResumption) {
            this.setUseStreamManagement(useSmResumption);
        }
        this.useSmResumption = useSmResumption;
    }

    public void setPreferredResumptionTime(int resumptionTime) {
        this.smClientMaxResumptionTime = resumptionTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addRequestAckPredicate(StanzaFilter predicate) {
        Set<StanzaFilter> set = this.requestAckPredicates;
        synchronized (set) {
            return this.requestAckPredicates.add(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeRequestAckPredicate(StanzaFilter predicate) {
        Set<StanzaFilter> set = this.requestAckPredicates;
        synchronized (set) {
            return this.requestAckPredicates.remove(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllRequestAckPredicates() {
        Set<StanzaFilter> set = this.requestAckPredicates;
        synchronized (set) {
            this.requestAckPredicates.clear();
        }
    }

    public void requestSmAcknowledgement() throws StreamManagementException.StreamManagementNotEnabledException, SmackException.NotConnectedException, InterruptedException {
        if (!this.isSmEnabled()) {
            throw new StreamManagementException.StreamManagementNotEnabledException();
        }
        this.requestSmAcknowledgementInternal();
    }

    private void requestSmAcknowledgementInternal() throws SmackException.NotConnectedException, InterruptedException {
        this.packetWriter.sendStreamElement((Element)StreamManagement.AckRequest.INSTANCE);
    }

    private void requestSmAcknowledgementNonBlockingInternal() throws SmackException.NotConnectedException, SmackException.OutgoingQueueFullException {
        this.packetWriter.sendNonBlocking((Element)StreamManagement.AckRequest.INSTANCE);
    }

    public void sendSmAcknowledgement() throws StreamManagementException.StreamManagementNotEnabledException, SmackException.NotConnectedException, InterruptedException {
        if (!this.isSmEnabled()) {
            throw new StreamManagementException.StreamManagementNotEnabledException();
        }
        this.sendSmAcknowledgementInternal();
    }

    private void sendSmAcknowledgementInternal() throws SmackException.NotConnectedException, InterruptedException {
        StreamManagement.AckAnswer ackAnswer = new StreamManagement.AckAnswer(this.clientHandledStanzasCount);
        this.packetWriter.queue.putIfNotShutdown((Object)ackAnswer);
    }

    public void addStanzaAcknowledgedListener(StanzaListener listener) {
        this.stanzaAcknowledgedListeners.add(listener);
    }

    public boolean removeStanzaAcknowledgedListener(StanzaListener listener) {
        return this.stanzaAcknowledgedListeners.remove(listener);
    }

    public void removeAllStanzaAcknowledgedListeners() {
        this.stanzaAcknowledgedListeners.clear();
    }

    public void addStanzaDroppedListener(StanzaListener listener) {
        this.stanzaDroppedListeners.add(listener);
    }

    public boolean removeStanzaDroppedListener(StanzaListener listener) {
        return this.stanzaDroppedListeners.remove(listener);
    }

    public StanzaListener addStanzaIdAcknowledgedListener(final String id, StanzaListener listener) throws StreamManagementException.StreamManagementNotEnabledException {
        if (!this.smWasEnabledAtLeastOnce) {
            throw new StreamManagementException.StreamManagementNotEnabledException();
        }
        int removeAfterSeconds = Math.min(this.getMaxSmResumptionTime(), 10800);
        XMPPTCPConnection.schedule((Runnable)new Runnable(){

            @Override
            public void run() {
                XMPPTCPConnection.this.stanzaIdAcknowledgedListeners.remove(id);
            }
        }, (long)removeAfterSeconds, (TimeUnit)TimeUnit.SECONDS);
        return this.stanzaIdAcknowledgedListeners.put(id, listener);
    }

    public StanzaListener removeStanzaIdAcknowledgedListener(String id) {
        return this.stanzaIdAcknowledgedListeners.remove(id);
    }

    public void removeAllStanzaIdAcknowledgedListeners() {
        this.stanzaIdAcknowledgedListeners.clear();
    }

    public boolean isSmAvailable() {
        return this.hasFeature("sm", "urn:xmpp:sm:3");
    }

    public boolean isSmEnabled() {
        return this.smEnabledSyncPoint;
    }

    public boolean streamWasResumed() {
        return this.smResumedSyncPoint == AbstractXMPPConnection.SyncPointState.successful;
    }

    public boolean isDisconnectedButSmResumptionPossible() {
        return this.disconnectedButResumeable && this.isSmResumptionPossible();
    }

    public boolean isSmResumptionPossible() {
        if (this.smSessionId == null) {
            return false;
        }
        if (!this.packetWriter.instantShutdown) {
            return false;
        }
        Long shutdownTimestamp = this.packetWriter.shutdownTimestamp;
        if (shutdownTimestamp == null) {
            return true;
        }
        long current = System.currentTimeMillis();
        long maxResumptionMillies = (long)this.getMaxSmResumptionTime() * 1000L;
        return current <= shutdownTimestamp + maxResumptionMillies;
    }

    private void dropSmState() {
        this.smSessionId = null;
        this.unacknowledgedStanzas = null;
    }

    public int getMaxSmResumptionTime() {
        int clientResumptionTime = this.smClientMaxResumptionTime > 0 ? this.smClientMaxResumptionTime : Integer.MAX_VALUE;
        int serverResumptionTime = this.smServerMaxResumptionTime > 0 ? this.smServerMaxResumptionTime : Integer.MAX_VALUE;
        return Math.min(clientResumptionTime, serverResumptionTime);
    }

    private void processHandledCount(long handledCount) throws StreamManagementException.StreamManagementCounterError {
        long ackedStanzasCount = SMUtils.calculateDelta((long)handledCount, (long)this.serverHandledStanzasCount);
        final ArrayList<Stanza> ackedStanzas = new ArrayList<Stanza>(ackedStanzasCount <= Integer.MAX_VALUE ? (int)ackedStanzasCount : Integer.MAX_VALUE);
        for (long i = 0L; i < ackedStanzasCount; ++i) {
            Stanza ackedStanza = (Stanza)this.unacknowledgedStanzas.poll();
            if (ackedStanza == null) {
                throw new StreamManagementException.StreamManagementCounterError(handledCount, this.serverHandledStanzasCount, ackedStanzasCount, ackedStanzas);
            }
            ackedStanzas.add(ackedStanza);
        }
        boolean atLeastOneStanzaAcknowledgedListener = false;
        if (!this.stanzaAcknowledgedListeners.isEmpty()) {
            atLeastOneStanzaAcknowledgedListener = true;
        } else {
            for (Stanza ackedStanza : ackedStanzas) {
                String id = ackedStanza.getStanzaId();
                if (id == null || !this.stanzaIdAcknowledgedListeners.containsKey(id)) continue;
                atLeastOneStanzaAcknowledgedListener = true;
                break;
            }
        }
        if (atLeastOneStanzaAcknowledgedListener) {
            XMPPTCPConnection.asyncGo((Runnable)new Runnable(){

                @Override
                public void run() {
                    for (Stanza ackedStanza : ackedStanzas) {
                        StanzaListener listener2;
                        for (StanzaListener listener2 : XMPPTCPConnection.this.stanzaAcknowledgedListeners) {
                            try {
                                listener2.processStanza(ackedStanza);
                            }
                            catch (InterruptedException | SmackException.NotConnectedException | SmackException.NotLoggedInException e) {
                                LOGGER.log(Level.FINER, "Received exception", e);
                            }
                        }
                        String id = ackedStanza.getStanzaId();
                        if (StringUtils.isNullOrEmpty((CharSequence)id) || (listener2 = XMPPTCPConnection.this.stanzaIdAcknowledgedListeners.remove(id)) == null) continue;
                        try {
                            listener2.processStanza(ackedStanza);
                        }
                        catch (InterruptedException | SmackException.NotConnectedException | SmackException.NotLoggedInException e) {
                            LOGGER.log(Level.FINER, "Received exception", e);
                        }
                    }
                }
            });
        }
        this.serverHandledStanzasCount = handledCount;
    }

    public static void setDefaultBundleAndDeferCallback(BundleAndDeferCallback defaultBundleAndDeferCallback) {
        XMPPTCPConnection.defaultBundleAndDeferCallback = defaultBundleAndDeferCallback;
    }

    public void setBundleandDeferCallback(BundleAndDeferCallback bundleAndDeferCallback) {
        this.bundleAndDeferCallback = bundleAndDeferCallback;
    }

    public InetAddress getLocalAddress() {
        Socket socket = this.socket;
        if (socket == null) {
            return null;
        }
        InetAddress localAddress = socket.getLocalAddress();
        if (localAddress.isAnyLocalAddress()) {
            return null;
        }
        return localAddress;
    }

    static {
        useSmDefault = true;
        useSmResumptionDefault = true;
    }

    protected class PacketWriter {
        public static final int QUEUE_SIZE = 500;
        public static final int UNACKKNOWLEDGED_STANZAS_QUEUE_SIZE = 1024;
        public static final int UNACKKNOWLEDGED_STANZAS_QUEUE_SIZE_HIGH_WATER_MARK = 307;
        private final String threadName;
        private final ArrayBlockingQueueWithShutdown<Element> queue;
        protected volatile Long shutdownTimestamp;
        private volatile boolean instantShutdown;
        private boolean shouldBundleAndDefer;
        private boolean running;

        protected PacketWriter() {
            this.threadName = "Smack Writer (" + XMPPTCPConnection.this.getConnectionCounter() + ")";
            this.queue = new ArrayBlockingQueueWithShutdown(500, true);
            this.shutdownTimestamp = null;
        }

        void init() {
            this.shutdownTimestamp = null;
            if (XMPPTCPConnection.this.unacknowledgedStanzas != null) {
                this.drainWriterQueueToUnacknowledgedStanzas();
            }
            this.queue.start();
            this.running = true;
            Async.go((Runnable)new Runnable(){

                @Override
                public void run() {
                    LOGGER.finer(PacketWriter.this.threadName + " start");
                    try {
                        PacketWriter.this.writePackets();
                    }
                    finally {
                        LOGGER.finer(PacketWriter.this.threadName + " exit");
                        PacketWriter.this.running = false;
                        XMPPTCPConnection.this.notifyWaitingThreads();
                    }
                }
            }, (String)this.threadName);
        }

        private boolean done() {
            return this.shutdownTimestamp != null;
        }

        protected void throwNotConnectedExceptionIfDoneAndResumptionNotPossible() throws SmackException.NotConnectedException {
            boolean smResumptionPossible;
            boolean done = this.done();
            if (done && !(smResumptionPossible = XMPPTCPConnection.this.isSmResumptionPossible())) {
                throw new SmackException.NotConnectedException((XMPPConnection)XMPPTCPConnection.this, "done=true smResumptionPossible=false");
            }
        }

        protected void sendStreamElement(Element element) throws SmackException.NotConnectedException, InterruptedException {
            this.throwNotConnectedExceptionIfDoneAndResumptionNotPossible();
            try {
                this.queue.put((Object)element);
            }
            catch (InterruptedException e) {
                this.throwNotConnectedExceptionIfDoneAndResumptionNotPossible();
                throw e;
            }
        }

        protected void sendNonBlocking(Element element) throws SmackException.NotConnectedException, SmackException.OutgoingQueueFullException {
            this.throwNotConnectedExceptionIfDoneAndResumptionNotPossible();
            boolean enqueued = this.queue.offer((Object)element);
            if (!enqueued) {
                this.throwNotConnectedExceptionIfDoneAndResumptionNotPossible();
                throw new SmackException.OutgoingQueueFullException();
            }
        }

        void shutdown(boolean instant) {
            this.instantShutdown = instant;
            this.shutdownTimestamp = System.currentTimeMillis();
            this.queue.shutdown();
        }

        private Element nextStreamElement() {
            Element packet;
            block3: {
                if (this.queue.isEmpty()) {
                    this.shouldBundleAndDefer = true;
                }
                packet = null;
                try {
                    packet = (Element)this.queue.take();
                }
                catch (InterruptedException e) {
                    if (this.queue.isShutdown()) break block3;
                    LOGGER.log(Level.WARNING, "Writer thread was interrupted. Don't do that. Use disconnect() instead.", e);
                }
            }
            return packet;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writePackets() {
            block26: {
                try {
                    while (!this.done()) {
                        Element element = this.nextStreamElement();
                        if (element == null) continue;
                        BundleAndDeferCallback localBundleAndDeferCallback = XMPPTCPConnection.this.bundleAndDeferCallback;
                        if (localBundleAndDeferCallback != null && XMPPTCPConnection.this.isAuthenticated() && this.shouldBundleAndDefer) {
                            this.shouldBundleAndDefer = false;
                            AtomicBoolean bundlingAndDeferringStopped = new AtomicBoolean();
                            int bundleAndDeferMillis = localBundleAndDeferCallback.getBundleAndDeferMillis(new BundleAndDefer(bundlingAndDeferringStopped));
                            if (bundleAndDeferMillis > 0) {
                                long remainingWait = bundleAndDeferMillis;
                                long waitStart = System.currentTimeMillis();
                                AtomicBoolean atomicBoolean = bundlingAndDeferringStopped;
                                synchronized (atomicBoolean) {
                                    while (!bundlingAndDeferringStopped.get() && remainingWait > 0L) {
                                        bundlingAndDeferringStopped.wait(remainingWait);
                                        remainingWait = (long)bundleAndDeferMillis - (System.currentTimeMillis() - waitStart);
                                    }
                                }
                            }
                        }
                        Stanza packet = null;
                        if (element instanceof Stanza) {
                            packet = (Stanza)element;
                        } else if (element instanceof StreamManagement.Enable) {
                            XMPPTCPConnection.this.unacknowledgedStanzas = new ArrayBlockingQueue<Stanza>(1024);
                        }
                        this.maybeAddToUnacknowledgedStanzas(packet);
                        CharSequence elementXml = element.toXML(XMPPTCPConnection.this.outgoingStreamXmlEnvironment);
                        if (elementXml instanceof XmlStringBuilder) {
                            try {
                                ((XmlStringBuilder)elementXml).write(XMPPTCPConnection.this.writer, XMPPTCPConnection.this.outgoingStreamXmlEnvironment);
                            }
                            catch (NullPointerException npe) {
                                LOGGER.log(Level.FINE, "NPE in XmlStringBuilder of " + String.valueOf(element.getClass()) + ": " + String.valueOf(element), npe);
                                throw npe;
                            }
                        } else {
                            XMPPTCPConnection.this.writer.write(elementXml.toString());
                        }
                        if (this.queue.isEmpty()) {
                            XMPPTCPConnection.this.writer.flush();
                        }
                        if (packet == null) continue;
                        XMPPTCPConnection.this.firePacketSendingListeners((TopLevelStreamElement)packet);
                    }
                    if (!this.instantShutdown) {
                        try {
                            while (!this.queue.isEmpty()) {
                                Element packet = (Element)this.queue.remove();
                                if (packet instanceof Stanza) {
                                    Stanza stanza = (Stanza)packet;
                                    this.maybeAddToUnacknowledgedStanzas(stanza);
                                }
                                XMPPTCPConnection.this.writer.write(packet.toXML().toString());
                            }
                        }
                        catch (Exception e) {
                            LOGGER.log(Level.WARNING, "Exception flushing queue during shutdown, ignore and continue", e);
                        }
                        try {
                            XMPPTCPConnection.this.writer.write("</stream:stream>");
                            XMPPTCPConnection.this.writer.flush();
                        }
                        catch (Exception e) {
                            LOGGER.log(Level.WARNING, "Exception writing closing stream element", e);
                        }
                        this.queue.clear();
                        break block26;
                    }
                    if (this.instantShutdown && XMPPTCPConnection.this.isSmEnabled()) {
                        this.drainWriterQueueToUnacknowledgedStanzas();
                    }
                }
                catch (Exception e) {
                    if (!this.done() && !this.queue.isShutdown()) {
                        this.running = false;
                        XMPPTCPConnection.this.notifyConnectionError(e);
                    }
                    LOGGER.log(Level.FINE, "Ignoring Exception in writePackets()", e);
                }
            }
        }

        private void drainWriterQueueToUnacknowledgedStanzas() {
            ArrayList elements = new ArrayList(this.queue.size());
            this.queue.drainTo(elements);
            for (int i = 0; i < elements.size(); ++i) {
                Element element = (Element)elements.get(i);
                if (XMPPTCPConnection.this.unacknowledgedStanzas.remainingCapacity() == 0) {
                    StreamManagementException.UnacknowledgedQueueFullException exception = StreamManagementException.UnacknowledgedQueueFullException.newWith((int)i, elements, XMPPTCPConnection.this.unacknowledgedStanzas);
                    LOGGER.log(Level.WARNING, "Some stanzas may be lost as not all could be drained to the unacknowledged stanzas queue", (Throwable)exception);
                    return;
                }
                if (!(element instanceof Stanza)) continue;
                XMPPTCPConnection.this.unacknowledgedStanzas.add((Stanza)element);
            }
        }

        private void maybeAddToUnacknowledgedStanzas(Stanza stanza) throws IOException {
            if (XMPPTCPConnection.this.unacknowledgedStanzas != null && stanza != null) {
                if (XMPPTCPConnection.this.unacknowledgedStanzas.size() == 307) {
                    XMPPTCPConnection.this.writer.write(StreamManagement.AckRequest.INSTANCE.toXML().toString());
                }
                try {
                    XMPPTCPConnection.this.unacknowledgedStanzas.put(stanza);
                }
                catch (InterruptedException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
    }

    protected class PacketReader {
        private final String threadName;
        XmlPullParser parser;
        private volatile boolean done;
        private boolean running;

        protected PacketReader() {
            this.threadName = "Smack Reader (" + XMPPTCPConnection.this.getConnectionCounter() + ")";
        }

        void init() {
            this.done = false;
            this.running = true;
            Async.go((Runnable)new Runnable(){

                @Override
                public void run() {
                    LOGGER.finer(PacketReader.this.threadName + " start");
                    try {
                        PacketReader.this.parsePackets();
                    }
                    finally {
                        LOGGER.finer(PacketReader.this.threadName + " exit");
                        PacketReader.this.running = false;
                        XMPPTCPConnection.this.notifyWaitingThreads();
                    }
                }
            }, (String)this.threadName);
        }

        void shutdown() {
            this.done = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void parsePackets() {
            try {
                XMPPTCPConnection.this.openStreamAndResetParser();
                XmlPullParser.Event eventType = this.parser.getEventType();
                while (!this.done) {
                    block2 : switch (eventType) {
                        case START_ELEMENT: {
                            String name = this.parser.getName();
                            String namespace = this.parser.getNamespace();
                            block23 : switch (name) {
                                case "message": 
                                case "iq": 
                                case "presence": {
                                    try {
                                        XMPPTCPConnection.this.parseAndProcessStanza(this.parser);
                                        break block2;
                                    }
                                    finally {
                                        XMPPTCPConnection.this.clientHandledStanzasCount = SMUtils.incrementHeight((long)XMPPTCPConnection.this.clientHandledStanzasCount);
                                    }
                                }
                                case "stream": {
                                    if (!"http://etherx.jabber.org/streams".equals(namespace)) break block2;
                                    XMPPTCPConnection.this.onStreamOpen(this.parser);
                                    break;
                                }
                                case "error": {
                                    StreamError streamError = PacketParserUtils.parseStreamError((XmlPullParser)this.parser);
                                    throw new XMPPException.StreamErrorException(streamError);
                                }
                                case "features": {
                                    XMPPTCPConnection.this.parseFeaturesAndNotify(this.parser);
                                    break;
                                }
                                case "proceed": {
                                    XMPPTCPConnection.this.proceedTLSReceived();
                                    XMPPTCPConnection.this.openStreamAndResetParser();
                                    break;
                                }
                                case "failure": {
                                    switch (namespace) {
                                        case "urn:ietf:params:xml:ns:xmpp-tls": {
                                            throw new SmackException.SmackMessageException("TLS negotiation has failed");
                                        }
                                        case "http://jabber.org/protocol/compress": {
                                            SmackException.SmackMessageException exception = new SmackException.SmackMessageException("Could not establish compression");
                                            XMPPTCPConnection.this.setCurrentConnectionExceptionAndNotify((Exception)exception);
                                            break block23;
                                        }
                                    }
                                    XMPPTCPConnection.this.parseAndProcessNonza(this.parser);
                                    break;
                                }
                                case "compressed": {
                                    XMPPTCPConnection.this.initReaderAndWriter();
                                    XMPPTCPConnection.this.openStreamAndResetParser();
                                    XMPPTCPConnection.this.compressSyncPoint = true;
                                    XMPPTCPConnection.this.notifyWaitingThreads();
                                    break;
                                }
                                case "enabled": {
                                    StreamManagement.Enabled enabled = ParseStreamManagement.enabled((XmlPullParser)this.parser);
                                    if (enabled.isResumeSet()) {
                                        XMPPTCPConnection.this.smSessionId = enabled.getId();
                                        if (StringUtils.isNullOrEmpty((CharSequence)XMPPTCPConnection.this.smSessionId)) {
                                            SmackException.SmackMessageException xmppException = new SmackException.SmackMessageException("Stream Management 'enabled' element with resume attribute but without session id received");
                                            XMPPTCPConnection.this.setCurrentConnectionExceptionAndNotify((Exception)xmppException);
                                            throw xmppException;
                                        }
                                        XMPPTCPConnection.this.smServerMaxResumptionTime = enabled.getMaxResumptionTime();
                                    } else {
                                        XMPPTCPConnection.this.smSessionId = null;
                                    }
                                    XMPPTCPConnection.this.clientHandledStanzasCount = 0L;
                                    XMPPTCPConnection.this.smWasEnabledAtLeastOnce = true;
                                    XMPPTCPConnection.this.smEnabledSyncPoint = true;
                                    XMPPTCPConnection.this.notifyWaitingThreads();
                                    break;
                                }
                                case "failed": {
                                    StreamManagement.Failed failed = ParseStreamManagement.failed((XmlPullParser)this.parser);
                                    if (XMPPTCPConnection.this.smResumedSyncPoint == AbstractXMPPConnection.SyncPointState.request_sent) {
                                        XMPPTCPConnection.this.smResumptionFailed = failed;
                                        XMPPTCPConnection.this.notifyWaitingThreads();
                                        break;
                                    }
                                    XMPPException.FailedNonzaException xmppException = new XMPPException.FailedNonzaException((Nonza)failed, failed.getStanzaErrorCondition());
                                    XMPPTCPConnection.this.setCurrentConnectionExceptionAndNotify((Exception)xmppException);
                                    break;
                                }
                                case "resumed": {
                                    StreamManagement.Resumed resumed = ParseStreamManagement.resumed((XmlPullParser)this.parser);
                                    if (!XMPPTCPConnection.this.smSessionId.equals(resumed.getPrevId())) {
                                        throw new StreamManagementException.StreamIdDoesNotMatchException(XMPPTCPConnection.this.smSessionId, resumed.getPrevId());
                                    }
                                    XMPPTCPConnection.this.smEnabledSyncPoint = true;
                                    XMPPTCPConnection.this.processHandledCount(resumed.getHandledCount());
                                    ArrayList stanzasToResend = new ArrayList(XMPPTCPConnection.this.unacknowledgedStanzas.size());
                                    XMPPTCPConnection.this.unacknowledgedStanzas.drainTo(stanzasToResend);
                                    for (Stanza stanza : stanzasToResend) {
                                        XMPPTCPConnection.this.sendInternal((TopLevelStreamElement)stanza);
                                    }
                                    if (!stanzasToResend.isEmpty()) {
                                        XMPPTCPConnection.this.requestSmAcknowledgementInternal();
                                    }
                                    XMPPTCPConnection.this.smResumedSyncPoint = AbstractXMPPConnection.SyncPointState.successful;
                                    XMPPTCPConnection.this.notifyWaitingThreads();
                                    break;
                                }
                                case "a": {
                                    StreamManagement.AckAnswer ackAnswer = ParseStreamManagement.ackAnswer((XmlPullParser)this.parser);
                                    XMPPTCPConnection.this.processHandledCount(ackAnswer.getHandledCount());
                                    break;
                                }
                                case "r": {
                                    ParseStreamManagement.ackRequest((XmlPullParser)this.parser);
                                    if (XMPPTCPConnection.this.smEnabledSyncPoint) {
                                        XMPPTCPConnection.this.sendSmAcknowledgementInternal();
                                        break;
                                    }
                                    LOGGER.warning("SM Ack Request received while SM is not enabled");
                                    break;
                                }
                                default: {
                                    XMPPTCPConnection.this.parseAndProcessNonza(this.parser);
                                    break;
                                }
                            }
                            break;
                        }
                        case END_ELEMENT: {
                            String endTagName = this.parser.getName();
                            if (!"stream".equals(endTagName)) break;
                            if (!this.parser.getNamespace().equals("http://etherx.jabber.org/streams")) {
                                LOGGER.warning(String.valueOf((Object)XMPPTCPConnection.this) + " </stream> but different namespace " + this.parser.getNamespace());
                                break;
                            }
                            boolean queueWasShutdown = XMPPTCPConnection.this.packetWriter.queue.isShutdown();
                            XMPPTCPConnection.this.closingStreamReceived = true;
                            XMPPTCPConnection.this.notifyWaitingThreads();
                            if (queueWasShutdown) {
                                return;
                            }
                            LOGGER.info(String.valueOf((Object)XMPPTCPConnection.this) + " received closing </stream> element. Server wants to terminate the connection, calling disconnect()");
                            ASYNC_BUT_ORDERED.performAsyncButOrdered((Object)XMPPTCPConnection.this, new Runnable(){

                                @Override
                                public void run() {
                                    XMPPTCPConnection.this.disconnect();
                                }
                            });
                            break;
                        }
                        case END_DOCUMENT: {
                            throw new SmackException.SmackMessageException("Parser got END_DOCUMENT event. This could happen e.g. if the server closed the connection without sending a closing stream element");
                        }
                    }
                    eventType = this.parser.next();
                }
            }
            catch (Exception e) {
                this.running = false;
                String ignoreReasonThread = null;
                boolean writerThreadWasShutDown = XMPPTCPConnection.this.packetWriter.queue.isShutdown();
                if (writerThreadWasShutDown) {
                    ignoreReasonThread = "writer";
                } else if (this.done) {
                    ignoreReasonThread = "reader";
                }
                if (ignoreReasonThread != null) {
                    LOGGER.log(Level.FINER, "Ignoring " + String.valueOf(e) + " as " + ignoreReasonThread + " was already shut down");
                    return;
                }
                XMPPTCPConnection.this.notifyConnectionError(e);
            }
        }
    }

    private static interface SmAckAction<E extends Exception> {
        public void run() throws SmackException.NotConnectedException, E;
    }
}

