/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.websocket.okhttp;

import java.util.logging.Level;
import javax.net.ssl.SSLSession;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.jivesoftware.smack.c2s.internal.ModularXmppClientToServerConnectionInternal;
import org.jivesoftware.smack.websocket.impl.AbstractWebSocket;
import org.jivesoftware.smack.websocket.rce.WebSocketRemoteConnectionEndpoint;

public final class OkHttpWebSocket
extends AbstractWebSocket {
    private static final OkHttpClient OK_HTTP_CLIENT = new OkHttpClient();
    private final WebSocket okHttpWebSocket;
    private final WebSocketListener listener = new WebSocketListener(){

        public void onOpen(WebSocket webSocket, Response response) {
            LOGGER.log(Level.FINER, "OkHttp invoked onOpen() for {0}. Response: {1}", new Object[]{webSocket, response});
            OkHttpWebSocket.this.future.setResult((Object)OkHttpWebSocket.this);
        }

        public void onMessage(WebSocket webSocket, String text) {
            OkHttpWebSocket.this.onIncomingWebSocketElement(text);
        }

        public void onFailure(WebSocket webSocket, Throwable throwable, Response response) {
            LOGGER.log(Level.FINER, "OkHttp invoked onFailure() for " + webSocket + ". Response: " + response, throwable);
            OkHttpWebSocket.this.onWebSocketFailure(throwable);
        }

        public void onClosing(WebSocket webSocket, int code, String reason) {
            LOGGER.log(Level.FINER, "OkHttp invoked onClosing() for " + webSocket + ". Code: " + code + ". Reason: " + reason);
        }

        public void onClosed(WebSocket webSocket, int code, String reason) {
            LOGGER.log(Level.FINER, "OkHttp invoked onClosed() for " + webSocket + ". Code: " + code + ". Reason: " + reason);
        }
    };

    OkHttpWebSocket(WebSocketRemoteConnectionEndpoint endpoint, ModularXmppClientToServerConnectionInternal connectionInternal) {
        super(endpoint, connectionInternal);
        String url = endpoint.getRawString();
        Request request = new Request.Builder().url(url).header("Sec-WebSocket-Protocol", "xmpp").build();
        this.okHttpWebSocket = OK_HTTP_CLIENT.newWebSocket(request, this.listener);
    }

    public void send(String element) {
        this.okHttpWebSocket.send(element);
    }

    public void disconnect(int code, String message) {
        LOGGER.log(Level.INFO, "WebSocket closing with code: " + code + " and message: " + message);
        this.okHttpWebSocket.close(code, message);
    }

    public SSLSession getSSLSession() {
        return null;
    }
}

