/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.websocket.impl;

import org.jivesoftware.smack.websocket.impl.AbstractWebSocket;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public final class AbstractWebSocketTest {
    private static final String OPEN_ELEMENT = "<open from='localhost.org' id='aov9ihhmmn' xmlns='urn:ietf:params:xml:ns:xmpp-framing' xml:lang='en' version='1.0'/>";
    private static final String OPEN_ELEMENT_EXPANDED = "<open from='localhost.org' id='aov9ihhmmn' xmlns='urn:ietf:params:xml:ns:xmpp-framing' xml:lang='en' version='1.0'></open>";
    private static final String OPEN_STREAM = "<stream:stream from='localhost.org' id='aov9ihhmmn' xmlns='jabber:client' xml:lang='en' version='1.0' xmlns:stream='http://etherx.jabber.org/streams'>";
    private static final String CLOSE_ELEMENT = "<close xmlns='urn:ietf:params:xml:ns:xmpp-framing'/>";

    @Test
    public void getStreamFromOpenElementTest() {
        Assertions.assertEquals((Object)OPEN_STREAM, (Object)AbstractWebSocket.getStreamFromOpenElement((String)OPEN_ELEMENT));
        Assertions.assertEquals((Object)OPEN_STREAM, (Object)AbstractWebSocket.getStreamFromOpenElement((String)OPEN_ELEMENT_EXPANDED));
    }

    @Test
    public void isOpenElementTest() {
        Assertions.assertTrue((boolean)AbstractWebSocket.isOpenElement((String)OPEN_ELEMENT));
        Assertions.assertTrue((boolean)AbstractWebSocket.isOpenElement((String)OPEN_ELEMENT_EXPANDED));
        Assertions.assertFalse((boolean)AbstractWebSocket.isOpenElement((String)OPEN_STREAM));
    }

    @Test
    public void isCloseElementTest() {
        Assertions.assertTrue((boolean)AbstractWebSocket.isCloseElement((String)CLOSE_ELEMENT));
        Assertions.assertFalse((boolean)AbstractWebSocket.isCloseElement((String)OPEN_STREAM));
    }
}

