/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.websocket.rce;

import java.net.URISyntaxException;
import org.jivesoftware.smack.datatypes.UInt16;
import org.jivesoftware.smack.websocket.rce.WebSocketRemoteConnectionEndpoint;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class WebSocketRemoteConnectionEndpointTest {
    @Test
    public void endpointTest() throws URISyntaxException {
        String endpointString = "ws://fooDomain.org:7070/ws/";
        WebSocketRemoteConnectionEndpoint endpoint = WebSocketRemoteConnectionEndpoint.from((CharSequence)endpointString);
        Assertions.assertEquals((Object)"fooDomain.org", (Object)endpoint.getHost());
        Assertions.assertEquals((Object)UInt16.from((int)7070), (Object)endpoint.getPort());
        Assertions.assertEquals((Object)endpointString, (Object)endpoint.getUri().toString());
    }

    @Test
    public void faultyEndpointTest() {
        String faultyProtocolString = "wst://fooDomain.org:7070/ws/";
        Assertions.assertThrows(IllegalArgumentException.class, () -> WebSocketRemoteConnectionEndpoint.from((CharSequence)faultyProtocolString));
    }
}

