/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.websocket;

import java.net.URI;
import java.net.URISyntaxException;
import org.jivesoftware.smack.c2s.ModularXmppClientToServerConnection;
import org.jivesoftware.smack.c2s.ModularXmppClientToServerConnectionConfiguration;
import org.jivesoftware.smack.c2s.internal.ModularXmppClientToServerConnectionInternal;
import org.jivesoftware.smack.websocket.XmppWebSocketTransportModule;
import org.jivesoftware.smack.websocket.XmppWebSocketTransportModuleDescriptor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.jxmpp.stringprep.XmppStringprepException;
import org.mockito.Mockito;

public class XmppWebSocketTransportModuleTest {
    @Test
    public void createWebSocketModuleConnectionInstanceTest() throws URISyntaxException, XmppStringprepException {
        ModularXmppClientToServerConnectionConfiguration.Builder builder = ModularXmppClientToServerConnectionConfiguration.builder();
        builder.removeAllModules();
        builder.addModule(XmppWebSocketTransportModuleDescriptor.class);
        builder.setXmppAddressAndPassword((CharSequence)"user5@localhost.org", "user5");
        builder.setHost((CharSequence)"localhost.org");
        XmppWebSocketTransportModuleDescriptor.Builder websocketBuilder = XmppWebSocketTransportModuleDescriptor.getBuilder((ModularXmppClientToServerConnectionConfiguration.Builder)builder);
        websocketBuilder.explicitlySetWebSocketEndpointAndDiscovery(new URI("wss://localhost.org:7443/ws/"), false);
        ModularXmppClientToServerConnectionConfiguration config = builder.build();
        ModularXmppClientToServerConnection connection = new ModularXmppClientToServerConnection(config);
        Assertions.assertNotNull((Object)connection);
    }

    @Test
    public void createDescriptorTest() throws URISyntaxException, XmppStringprepException {
        XmppWebSocketTransportModuleDescriptor websocketTransportModuleDescriptor = XmppWebSocketTransportModuleTest.getWebSocketDescriptor();
        Assertions.assertNotNull((Object)websocketTransportModuleDescriptor);
    }

    @Test
    public void lookupConnectionEndpointsTest() throws URISyntaxException {
        XmppWebSocketTransportModuleDescriptor websocketTransportModuleDescriptor = XmppWebSocketTransportModuleTest.getWebSocketDescriptor();
        ModularXmppClientToServerConnectionInternal connectionInternal = (ModularXmppClientToServerConnectionInternal)Mockito.mock(ModularXmppClientToServerConnectionInternal.class);
        XmppWebSocketTransportModule transportModule = new XmppWebSocketTransportModule(websocketTransportModuleDescriptor, connectionInternal);
        XmppWebSocketTransportModule.XmppWebSocketTransport transport = transportModule.getTransport();
        Assertions.assertNotNull((Object)transport.lookupConnectionEndpoints());
    }

    private static XmppWebSocketTransportModuleDescriptor getWebSocketDescriptor() throws URISyntaxException {
        ModularXmppClientToServerConnectionConfiguration.Builder builder = ModularXmppClientToServerConnectionConfiguration.builder();
        XmppWebSocketTransportModuleDescriptor.Builder websocketBuilder = XmppWebSocketTransportModuleDescriptor.getBuilder((ModularXmppClientToServerConnectionConfiguration.Builder)builder);
        websocketBuilder.explicitlySetWebSocketEndpointAndDiscovery(new URI("wss://localhost.org:7443/ws/"), false);
        return (XmppWebSocketTransportModuleDescriptor)websocketBuilder.build();
    }
}

