/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.websocket.elements;

import org.jivesoftware.smack.test.util.XmlAssertUtil;
import org.jivesoftware.smack.websocket.elements.WebSocketCloseElement;
import org.jivesoftware.smack.websocket.elements.WebSocketOpenElement;
import org.junit.jupiter.api.Test;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.stringprep.XmppStringprepException;

public class WebSocketElementTest {
    private static final String OPEN_ELEMENT = "<open xmlns='urn:ietf:params:xml:ns:xmpp-framing' to='foodomain.foo' version='1.0'/>";
    private static final String CLOSE_ELEMENT = "<close xmlns='urn:ietf:params:xml:ns:xmpp-framing'/>";

    @Test
    public void websocketOpenElementTest() throws XmppStringprepException {
        String openElementXml = new WebSocketOpenElement(JidCreate.domainBareFrom((String)"foodomain.foo")).toXML().toString();
        XmlAssertUtil.assertXmlSimilar((CharSequence)OPEN_ELEMENT, (CharSequence)openElementXml);
        XmlAssertUtil.assertXmlNotSimilar((CharSequence)CLOSE_ELEMENT, (CharSequence)new WebSocketOpenElement(JidCreate.domainBareFrom((String)"foodomain.foo")).toXML());
    }

    @Test
    public void websocketCloseElementTest() throws XmppStringprepException {
        String closeElementXml = new WebSocketCloseElement().toXML().toString();
        XmlAssertUtil.assertXmlSimilar((CharSequence)CLOSE_ELEMENT, (CharSequence)closeElementXml);
        XmlAssertUtil.assertXmlNotSimilar((CharSequence)OPEN_ELEMENT, (CharSequence)closeElementXml);
    }
}

