/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.websocket;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Set;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.c2s.ModularXmppClientToServerConnectionConfiguration;
import org.jivesoftware.smack.c2s.ModularXmppClientToServerConnectionModule;
import org.jivesoftware.smack.c2s.ModularXmppClientToServerConnectionModuleDescriptor;
import org.jivesoftware.smack.c2s.internal.ModularXmppClientToServerConnectionInternal;
import org.jivesoftware.smack.fsm.StateDescriptor;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.websocket.XmppWebSocketTransportModule;
import org.jivesoftware.smack.websocket.impl.WebSocketFactory;
import org.jivesoftware.smack.websocket.rce.WebSocketRemoteConnectionEndpoint;

public final class XmppWebSocketTransportModuleDescriptor
extends ModularXmppClientToServerConnectionModuleDescriptor {
    private final boolean performWebSocketEndpointDiscovery;
    private final boolean implicitWebSocketEndpoint;
    private final WebSocketRemoteConnectionEndpoint wsRce;
    final WebSocketFactory webSocketFactory;

    public XmppWebSocketTransportModuleDescriptor(Builder builder) {
        this.performWebSocketEndpointDiscovery = builder.performWebSocketEndpointDiscovery;
        this.implicitWebSocketEndpoint = builder.implicitWebSocketEndpoint;
        this.webSocketFactory = builder.webSocketFactory;
        URI uri = builder.uri;
        this.wsRce = uri != null ? WebSocketRemoteConnectionEndpoint.from(uri) : null;
    }

    protected void validateConfiguration(ModularXmppClientToServerConnectionConfiguration configuration) {
        if (this.wsRce == null) {
            return;
        }
        ConnectionConfiguration.SecurityMode securityMode = configuration.getSecurityMode();
        switch (securityMode) {
            case required: {
                if (this.wsRce.isSecureEndpoint()) break;
                throw new IllegalArgumentException("The provided WebSocket endpoint " + String.valueOf(this.wsRce) + " is not a secure endpoint, but the connection configuration requires secure endpoints");
            }
            case disabled: {
                if (!this.wsRce.isSecureEndpoint()) break;
                throw new IllegalArgumentException("The provided WebSocket endpoint " + String.valueOf(this.wsRce) + " is a secure endpoint, but the connection configuration has security disabled");
            }
        }
    }

    public boolean isWebSocketEndpointDiscoveryEnabled() {
        return this.performWebSocketEndpointDiscovery;
    }

    public boolean isImplicitWebSocketEndpointEnabled() {
        return this.implicitWebSocketEndpoint;
    }

    public URI getExplicitlyProvidedUri() {
        return this.wsRce.getUri();
    }

    WebSocketRemoteConnectionEndpoint getExplicitlyProvidedEndpoint() {
        return this.wsRce;
    }

    protected Set<Class<? extends StateDescriptor>> getStateDescriptors() {
        HashSet<Class<? extends StateDescriptor>> res = new HashSet<Class<? extends StateDescriptor>>();
        res.add(XmppWebSocketTransportModule.EstablishingWebSocketConnectionStateDescriptor.class);
        return res;
    }

    protected ModularXmppClientToServerConnectionModule<? extends ModularXmppClientToServerConnectionModuleDescriptor> constructXmppConnectionModule(ModularXmppClientToServerConnectionInternal connectionInternal) {
        return new XmppWebSocketTransportModule(this, connectionInternal);
    }

    public static Builder getBuilder(ModularXmppClientToServerConnectionConfiguration.Builder connectionConfigurationBuilder) {
        return new Builder(connectionConfigurationBuilder);
    }

    public static final class Builder
    extends ModularXmppClientToServerConnectionModuleDescriptor.Builder {
        private boolean performWebSocketEndpointDiscovery = true;
        private boolean implicitWebSocketEndpoint = true;
        private URI uri;
        private WebSocketFactory webSocketFactory;

        private Builder(ModularXmppClientToServerConnectionConfiguration.Builder connectionConfigurationBuilder) {
            super(connectionConfigurationBuilder);
        }

        public Builder explicitlySetWebSocketEndpoint(URI endpoint) {
            return this.explicitlySetWebSocketEndpointAndDiscovery(endpoint, true);
        }

        public Builder explicitlySetWebSocketEndpointAndDiscovery(URI endpoint, boolean performWebSocketEndpointDiscovery) {
            Objects.requireNonNull((Object)endpoint, (String)"Provided endpoint URI must not be null");
            this.uri = endpoint;
            this.performWebSocketEndpointDiscovery = performWebSocketEndpointDiscovery;
            return this;
        }

        public Builder explicitlySetWebSocketEndpoint(CharSequence endpoint) throws URISyntaxException {
            URI endpointUri = new URI(endpoint.toString());
            return this.explicitlySetWebSocketEndpoint(endpointUri);
        }

        public Builder explicitlySetWebSocketEndpointAndDiscovery(CharSequence endpoint, boolean performWebSocketEndpointDiscovery) throws URISyntaxException {
            URI endpointUri = new URI(endpoint.toString());
            return this.explicitlySetWebSocketEndpointAndDiscovery(endpointUri, performWebSocketEndpointDiscovery);
        }

        public Builder disableImplicitWebsocketEndpoint() {
            this.implicitWebSocketEndpoint = false;
            return this;
        }

        public Builder setWebSocketFactory(WebSocketFactory webSocketFactory) {
            Objects.requireNonNull((Object)webSocketFactory);
            this.webSocketFactory = webSocketFactory;
            return this;
        }

        public ModularXmppClientToServerConnectionModuleDescriptor build() {
            return new XmppWebSocketTransportModuleDescriptor(this);
        }
    }
}

