/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.websocket;

import java.util.ArrayList;
import java.util.List;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.SmackFuture;
import org.jivesoftware.smack.c2s.internal.ModularXmppClientToServerConnectionInternal;
import org.jivesoftware.smack.fsm.StateTransitionResult;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.websocket.XmppWebSocketTransportModule;
import org.jivesoftware.smack.websocket.impl.AbstractWebSocket;
import org.jivesoftware.smack.websocket.impl.WebSocketFactory;
import org.jivesoftware.smack.websocket.rce.WebSocketRemoteConnectionEndpoint;
import org.jivesoftware.smack.websocket.rce.WebSocketRemoteConnectionEndpointLookup;

public final class WebSocketConnectionAttemptState {
    private final ModularXmppClientToServerConnectionInternal connectionInternal;
    private final XmppWebSocketTransportModule.XmppWebSocketTransport.DiscoveredWebSocketEndpoints discoveredEndpoints;
    private final WebSocketFactory webSocketFactory;
    private AbstractWebSocket webSocket;

    WebSocketConnectionAttemptState(ModularXmppClientToServerConnectionInternal connectionInternal, XmppWebSocketTransportModule.XmppWebSocketTransport.DiscoveredWebSocketEndpoints discoveredWebSocketEndpoints, WebSocketFactory webSocketFactory) {
        assert (discoveredWebSocketEndpoints != null);
        assert (!discoveredWebSocketEndpoints.result.isEmpty());
        this.connectionInternal = connectionInternal;
        this.discoveredEndpoints = discoveredWebSocketEndpoints;
        this.webSocketFactory = webSocketFactory;
    }

    StateTransitionResult.Failure establishWebSocketConnection() throws InterruptedException {
        WebSocketRemoteConnectionEndpointLookup.Result endpointLookupResult = this.discoveredEndpoints.result;
        ArrayList<Exception> failures = new ArrayList<Exception>(endpointLookupResult.discoveredEndpointCount());
        this.webSocket = null;
        ConnectionConfiguration.SecurityMode securityMode = this.connectionInternal.connection.getConfiguration().getSecurityMode();
        switch (securityMode) {
            case required: 
            case ifpossible: {
                this.establishWebSocketConnection(endpointLookupResult.discoveredSecureEndpoints, failures);
                if (this.webSocket == null) break;
                return null;
            }
        }
        this.establishWebSocketConnection(endpointLookupResult.discoveredInsecureEndpoints, failures);
        if (this.webSocket != null) {
            return null;
        }
        FailedToConnectToAnyWebSocketEndpoint failure = FailedToConnectToAnyWebSocketEndpoint.create(failures);
        return failure;
    }

    private void establishWebSocketConnection(List<? extends WebSocketRemoteConnectionEndpoint> webSocketEndpoints, List<Exception> failures) throws InterruptedException {
        int endpointCount = webSocketEndpoints.size();
        ArrayList<SmackFuture<AbstractWebSocket, Exception>> futures = new ArrayList<SmackFuture<AbstractWebSocket, Exception>>(endpointCount);
        ArrayList<AbstractWebSocket> webSockets = new ArrayList<AbstractWebSocket>(endpointCount);
        for (WebSocketRemoteConnectionEndpoint webSocketRemoteConnectionEndpoint : webSocketEndpoints) {
            AbstractWebSocket webSocket = this.webSocketFactory.create(webSocketRemoteConnectionEndpoint, this.connectionInternal);
            webSockets.add(webSocket);
        }
        for (AbstractWebSocket abstractWebSocket : webSockets) {
            SmackFuture<AbstractWebSocket, Exception> future = abstractWebSocket.getFuture();
            futures.add(future);
        }
        SmackFuture.await(futures, (long)this.connectionInternal.connection.getReplyTimeout());
        for (SmackFuture smackFuture : futures) {
            AbstractWebSocket abstractWebSocket = (AbstractWebSocket)smackFuture.getIfAvailable();
            if (abstractWebSocket == null) {
                Exception exception = smackFuture.getExceptionIfAvailable();
                assert (exception != null);
                failures.add(exception);
                continue;
            }
            if (this.webSocket == null) {
                this.webSocket = abstractWebSocket;
                continue;
            }
            abstractWebSocket.disconnect(1000, "Using other connection endpoint at " + String.valueOf(this.webSocket.getEndpoint()));
        }
    }

    public AbstractWebSocket getConnectedWebSocket() {
        return this.webSocket;
    }

    public static final class FailedToConnectToAnyWebSocketEndpoint
    extends StateTransitionResult.Failure {
        private final List<Exception> failures;

        private FailedToConnectToAnyWebSocketEndpoint(String failureMessage, List<Exception> failures) {
            super(failureMessage);
            this.failures = failures;
        }

        public List<Exception> getFailures() {
            return this.failures;
        }

        private static FailedToConnectToAnyWebSocketEndpoint create(List<Exception> failures) {
            StringBuilder sb = new StringBuilder(256);
            StringUtils.appendTo(failures, (StringBuilder)sb, e -> sb.append(e.getMessage()));
            String message = sb.toString();
            return new FailedToConnectToAnyWebSocketEndpoint(message, failures);
        }
    }
}

