/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.websocket.rce;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jivesoftware.smack.altconnections.HttpLookupMethod;
import org.jivesoftware.smack.util.rce.RemoteConnectionEndpointLookupFailure;
import org.jivesoftware.smack.websocket.rce.InsecureWebSocketRemoteConnectionEndpoint;
import org.jivesoftware.smack.websocket.rce.SecureWebSocketRemoteConnectionEndpoint;
import org.jivesoftware.smack.websocket.rce.WebSocketRemoteConnectionEndpoint;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jxmpp.jid.DomainBareJid;

public final class WebSocketRemoteConnectionEndpointLookup {
    public static Result lookup(DomainBareJid domainBareJid) {
        ArrayList<RemoteConnectionEndpointLookupFailure> lookupFailures = new ArrayList<RemoteConnectionEndpointLookupFailure>(1);
        List rcUriList = null;
        try {
            rcUriList = HttpLookupMethod.lookup((DomainBareJid)domainBareJid, (HttpLookupMethod.LinkRelation)HttpLookupMethod.LinkRelation.WEBSOCKET);
        }
        catch (IOException | URISyntaxException | XmlPullParserException e) {
            lookupFailures.add((RemoteConnectionEndpointLookupFailure)new RemoteConnectionEndpointLookupFailure.HttpLookupFailure(domainBareJid, (Exception)e));
            return new Result(lookupFailures);
        }
        ArrayList<SecureWebSocketRemoteConnectionEndpoint> discoveredSecureEndpoints = new ArrayList<SecureWebSocketRemoteConnectionEndpoint>(rcUriList.size());
        ArrayList<InsecureWebSocketRemoteConnectionEndpoint> discoveredInsecureEndpoints = new ArrayList<InsecureWebSocketRemoteConnectionEndpoint>(rcUriList.size());
        for (URI webSocketUri : rcUriList) {
            WebSocketRemoteConnectionEndpoint wsRce = WebSocketRemoteConnectionEndpoint.from(webSocketUri);
            if (wsRce instanceof SecureWebSocketRemoteConnectionEndpoint) {
                SecureWebSocketRemoteConnectionEndpoint secureWsRce = (SecureWebSocketRemoteConnectionEndpoint)wsRce;
                discoveredSecureEndpoints.add(secureWsRce);
                continue;
            }
            if (wsRce instanceof InsecureWebSocketRemoteConnectionEndpoint) {
                InsecureWebSocketRemoteConnectionEndpoint insecureWsRce = (InsecureWebSocketRemoteConnectionEndpoint)wsRce;
                discoveredInsecureEndpoints.add(insecureWsRce);
                continue;
            }
            throw new AssertionError();
        }
        return new Result(discoveredSecureEndpoints, discoveredInsecureEndpoints, lookupFailures);
    }

    public static final class Result {
        public final List<SecureWebSocketRemoteConnectionEndpoint> discoveredSecureEndpoints;
        public final List<InsecureWebSocketRemoteConnectionEndpoint> discoveredInsecureEndpoints;
        public final List<RemoteConnectionEndpointLookupFailure> lookupFailures;

        public Result() {
            this(Collections.emptyList());
        }

        public Result(List<RemoteConnectionEndpointLookupFailure> lookupFailures) {
            this(new ArrayList<SecureWebSocketRemoteConnectionEndpoint>(1), new ArrayList<InsecureWebSocketRemoteConnectionEndpoint>(1), lookupFailures);
        }

        public Result(List<SecureWebSocketRemoteConnectionEndpoint> discoveredSecureEndpoints, List<InsecureWebSocketRemoteConnectionEndpoint> discoveredInsecureEndpoints, List<RemoteConnectionEndpointLookupFailure> lookupFailures) {
            this.discoveredSecureEndpoints = discoveredSecureEndpoints;
            this.discoveredInsecureEndpoints = discoveredInsecureEndpoints;
            this.lookupFailures = lookupFailures;
        }

        public boolean isEmpty() {
            return this.discoveredSecureEndpoints.isEmpty() && this.discoveredInsecureEndpoints.isEmpty();
        }

        public int discoveredEndpointCount() {
            return this.discoveredSecureEndpoints.size() + this.discoveredInsecureEndpoints.size();
        }

        public List<SecureWebSocketRemoteConnectionEndpoint> getDiscoveredSecureRemoteConnectionEndpoints() {
            return this.discoveredSecureEndpoints;
        }

        public List<InsecureWebSocketRemoteConnectionEndpoint> getDiscoveredInsecureRemoteConnectionEndpoints() {
            return this.discoveredInsecureEndpoints;
        }

        public List<RemoteConnectionEndpointLookupFailure> getLookupFailures() {
            return this.lookupFailures;
        }
    }
}

