/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.xml.stax;

import java.io.IOException;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;

public final class StaxXmlPullParser
implements XmlPullParser {
    private final XMLStreamReader xmlStreamReader;
    private int depth;
    private boolean delayedDepthDecrement;

    StaxXmlPullParser(XMLStreamReader xmlStreamReader) {
        this.xmlStreamReader = xmlStreamReader;
    }

    public Object getProperty(String name) {
        return this.xmlStreamReader.getProperty(name);
    }

    public String getInputEncoding() {
        return this.xmlStreamReader.getEncoding();
    }

    public int getNamespaceCount() {
        return this.xmlStreamReader.getNamespaceCount();
    }

    public String getNamespacePrefix(int pos) {
        return this.xmlStreamReader.getNamespacePrefix(pos);
    }

    public String getNamespaceUri(int pos) {
        return this.xmlStreamReader.getNamespaceURI(pos);
    }

    public String getNamespace(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        NamespaceContext namespaceContext = this.xmlStreamReader.getNamespaceContext();
        return namespaceContext.getNamespaceURI(prefix);
    }

    public int getDepth() {
        return this.depth;
    }

    public String getPositionDescription() {
        Location location = this.xmlStreamReader.getLocation();
        return location.toString();
    }

    public int getLineNumber() {
        Location location = this.xmlStreamReader.getLocation();
        return location.getLineNumber();
    }

    public int getColumnNumber() {
        Location location = this.xmlStreamReader.getLocation();
        return location.getColumnNumber();
    }

    public boolean isWhiteSpace() {
        return this.xmlStreamReader.isWhiteSpace();
    }

    public String getText() {
        return this.xmlStreamReader.getText();
    }

    public String getNamespace() {
        NamespaceContext namespaceContext = this.xmlStreamReader.getNamespaceContext();
        String prefix = this.getPrefix();
        return namespaceContext.getNamespaceURI(prefix);
    }

    public String getName() {
        QName qname = this.getQName();
        return qname.getLocalPart();
    }

    public QName getQName() {
        return this.xmlStreamReader.getName();
    }

    public String getPrefix() {
        return this.xmlStreamReader.getPrefix();
    }

    public int getAttributeCount() {
        return this.xmlStreamReader.getAttributeCount();
    }

    public String getAttributeNamespace(int index) {
        return this.xmlStreamReader.getAttributeNamespace(index);
    }

    public String getAttributeName(int index) {
        QName qname = this.getAttributeQName(index);
        if (qname == null) {
            return null;
        }
        return qname.getLocalPart();
    }

    public QName getAttributeQName(int index) {
        return this.xmlStreamReader.getAttributeName(index);
    }

    public String getAttributePrefix(int index) {
        return this.xmlStreamReader.getAttributePrefix(index);
    }

    public String getAttributeType(int index) {
        return this.xmlStreamReader.getAttributeType(index);
    }

    public String getAttributeValue(int index) {
        return this.xmlStreamReader.getAttributeValue(index);
    }

    public String getAttributeValue(String namespace, String name) {
        String namespaceURI = namespace;
        String localName = name;
        return this.xmlStreamReader.getAttributeValue(namespaceURI, localName);
    }

    public XmlPullParser.Event getEventType() {
        int staxEventInt = this.xmlStreamReader.getEventType();
        return StaxXmlPullParser.staxEventIntegerToEvent(staxEventInt);
    }

    public XmlPullParser.Event next() throws XmlPullParserException {
        int staxEventInt;
        this.preNextEvent();
        try {
            staxEventInt = this.xmlStreamReader.next();
        }
        catch (XMLStreamException e) {
            throw new XmlPullParserException((Exception)e);
        }
        XmlPullParser.Event event = StaxXmlPullParser.staxEventIntegerToEvent(staxEventInt);
        switch (event) {
            case START_ELEMENT: {
                ++this.depth;
                break;
            }
            case END_ELEMENT: {
                this.delayedDepthDecrement = true;
                break;
            }
        }
        return event;
    }

    public String nextText() throws IOException, XmlPullParserException {
        String nextText;
        try {
            nextText = this.xmlStreamReader.getElementText();
        }
        catch (XMLStreamException e) {
            throw new XmlPullParserException((Exception)e);
        }
        this.delayedDepthDecrement = true;
        return nextText;
    }

    public XmlPullParser.TagEvent nextTag() throws IOException, XmlPullParserException {
        int staxEventInt;
        this.preNextEvent();
        try {
            staxEventInt = this.xmlStreamReader.nextTag();
        }
        catch (XMLStreamException e) {
            throw new XmlPullParserException((Exception)e);
        }
        switch (staxEventInt) {
            case 1: {
                ++this.depth;
                return XmlPullParser.TagEvent.START_ELEMENT;
            }
            case 2: {
                this.delayedDepthDecrement = true;
                return XmlPullParser.TagEvent.END_ELEMENT;
            }
        }
        throw new AssertionError();
    }

    private void preNextEvent() {
        if (this.delayedDepthDecrement) {
            --this.depth;
            this.delayedDepthDecrement = false;
            assert (this.depth >= 0);
        }
    }

    private static XmlPullParser.Event staxEventIntegerToEvent(int staxEventInt) {
        switch (staxEventInt) {
            case 1: {
                return XmlPullParser.Event.START_ELEMENT;
            }
            case 2: {
                return XmlPullParser.Event.END_ELEMENT;
            }
            case 3: {
                return XmlPullParser.Event.PROCESSING_INSTRUCTION;
            }
            case 4: {
                return XmlPullParser.Event.TEXT_CHARACTERS;
            }
            case 5: {
                return XmlPullParser.Event.COMMENT;
            }
            case 6: {
                return XmlPullParser.Event.IGNORABLE_WHITESPACE;
            }
            case 7: {
                return XmlPullParser.Event.START_DOCUMENT;
            }
            case 8: {
                return XmlPullParser.Event.END_DOCUMENT;
            }
            case 9: {
                return XmlPullParser.Event.ENTITY_REFERENCE;
            }
            case 10: {
                return XmlPullParser.Event.OTHER;
            }
            case 11: {
                return XmlPullParser.Event.OTHER;
            }
            case 12: {
                return XmlPullParser.Event.OTHER;
            }
            case 13: {
                return XmlPullParser.Event.OTHER;
            }
            case 14: {
                return XmlPullParser.Event.OTHER;
            }
            case 15: {
                return XmlPullParser.Event.OTHER;
            }
        }
        throw new IllegalArgumentException("Unknown Stax event integer: " + staxEventInt);
    }

    public boolean supportsRoundtrip() {
        return false;
    }
}

