/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.xml;

import java.io.Reader;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smack.xml.XmlPullParserFactory;

public class SmackXmlParser {
    private static final ServiceLoader<XmlPullParserFactory> xmlPullParserFactoryServiceLoader = ServiceLoader.load(XmlPullParserFactory.class);

    public static XmlPullParserFactory getXmlPullParserFactory() {
        Iterator<XmlPullParserFactory> iterator = xmlPullParserFactoryServiceLoader.iterator();
        if (!iterator.hasNext()) {
            throw new IllegalStateException("Could not load a XmlPullParserFactory via Service Provider Interface (SPI)");
        }
        return iterator.next();
    }

    public static XmlPullParser newXmlParser(Reader reader) throws XmlPullParserException {
        XmlPullParserFactory xmlPullParserFactory = SmackXmlParser.getXmlPullParserFactory();
        return xmlPullParserFactory.newXmlPullParser(reader);
    }
}

