/*
 * Decompiled with CFR 0.152.
 */
package org.xmpp.packet;

import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.List;
import net.jcip.annotations.NotThreadSafe;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.xmpp.packet.JID;
import org.xmpp.packet.PacketError;
import org.xmpp.packet.PacketExtension;

@NotThreadSafe
public abstract class Packet {
    protected static DocumentFactory docFactory = DocumentFactory.getInstance();
    protected Element element;
    protected JID toJID;
    protected JID fromJID;

    public Packet(Element element) {
        this(element, false);
    }

    public Packet(Element element, boolean skipValidation) {
        String from;
        this.element = element;
        String to = element.attributeValue("to");
        if (to != null) {
            if (to.length() == 0) {
                element.addAttribute("to", null);
            } else {
                String[] parts = JID.getParts(to);
                this.toJID = new JID(parts[0], parts[1], parts[2], skipValidation);
                element.addAttribute("to", this.toJID.toString());
            }
        }
        if ((from = element.attributeValue("from")) != null) {
            if (from.length() == 0) {
                element.addAttribute("from", null);
            } else {
                String[] parts = JID.getParts(from);
                this.fromJID = new JID(parts[0], parts[1], parts[2], true);
                element.addAttribute("from", this.fromJID.toString());
            }
        }
    }

    protected Packet() {
    }

    public String getID() {
        return this.element.attributeValue("id");
    }

    public void setID(String ID) {
        this.element.addAttribute("id", ID);
    }

    public JID getTo() {
        String to = this.element.attributeValue("to");
        if (to == null || to.length() == 0) {
            return null;
        }
        if (this.toJID != null && to.equals(this.toJID.toString())) {
            return this.toJID;
        }
        String[] parts = JID.getParts(to);
        this.toJID = new JID(parts[0], parts[1], parts[2], true);
        return this.toJID;
    }

    public void setTo(String to) {
        if (to != null) {
            this.toJID = new JID(to);
            to = this.toJID.toString();
        }
        this.element.addAttribute("to", to);
    }

    public void setTo(JID to) {
        this.toJID = to;
        if (to == null) {
            this.element.addAttribute("to", null);
        } else {
            this.element.addAttribute("to", to.toString());
        }
    }

    public JID getFrom() {
        String from = this.element.attributeValue("from");
        if (from == null || from.length() == 0) {
            return null;
        }
        if (this.fromJID != null && from.equals(this.fromJID.toString())) {
            return this.fromJID;
        }
        String[] parts = JID.getParts(from);
        this.fromJID = new JID(parts[0], parts[1], parts[2], true);
        return this.fromJID;
    }

    public void setFrom(String from) {
        if (from != null) {
            this.fromJID = new JID(from);
            from = this.fromJID.toString();
        }
        this.element.addAttribute("from", from);
    }

    public void setFrom(JID from) {
        this.fromJID = from;
        if (from == null) {
            this.element.addAttribute("from", null);
        } else {
            this.element.addAttribute("from", from.toString());
        }
    }

    public void addExtension(PacketExtension extension) {
        this.element.add(extension.getElement());
    }

    public PacketExtension getExtension(String name, String namespace) {
        List extensions = this.element.elements(QName.get((String)name, (String)namespace));
        if (!extensions.isEmpty()) {
            Class<? extends PacketExtension> extensionClass = PacketExtension.getExtensionClass(name, namespace);
            if (extensionClass != null) {
                try {
                    Constructor<? extends PacketExtension> constructor = extensionClass.getDeclaredConstructor(Element.class);
                    return constructor.newInstance(extensions.get(0));
                }
                catch (Exception e) {}
            } else {
                return new PacketExtension((Element)extensions.get(0));
            }
        }
        return null;
    }

    public boolean deleteExtension(String name, String namespace) {
        List extensions = this.element.elements(QName.get((String)name, (String)namespace));
        if (!extensions.isEmpty()) {
            this.element.remove((Element)extensions.get(0));
            return true;
        }
        return false;
    }

    public PacketError getError() {
        Element error = this.element.element("error");
        if (error != null) {
            return new PacketError(error);
        }
        return null;
    }

    public void setError(PacketError error) {
        if (this.element == null) {
            throw new NullPointerException("Error cannot be null");
        }
        this.element.addAttribute("type", "error");
        if (this.element.element("error") != null) {
            this.element.remove(this.element.element("error"));
        }
        this.element.add(error.getElement());
    }

    public void setError(PacketError.Condition condition) {
        this.setError(new PacketError(condition));
    }

    public abstract Packet createCopy();

    public Element getElement() {
        return this.element;
    }

    public String toXML() {
        return this.element.asXML();
    }

    public String toString() {
        StringWriter out = new StringWriter();
        XMLWriter writer = new XMLWriter((Writer)out, OutputFormat.createPrettyPrint());
        try {
            writer.write(this.element);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return out.toString();
    }
}

