/*
 * Decompiled with CFR 0.152.
 */
package org.xmpp.component;

import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.component.Component;
import org.xmpp.component.ComponentException;
import org.xmpp.component.ComponentManager;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;
import org.xmpp.packet.Packet;
import org.xmpp.packet.PacketError;
import org.xmpp.packet.Presence;

public abstract class AbstractComponent
implements Component {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String NAMESPACE_DISCO_ITEMS = "http://jabber.org/protocol/disco#items";
    public static final String NAMESPACE_DISCO_INFO = "http://jabber.org/protocol/disco#info";
    public static final String NAMESPACE_XMPP_PING = "urn:xmpp:ping";
    protected ComponentManager compMan = null;
    private ThreadPoolExecutor executor;
    private final int maxThreadPoolSize;
    private final int maxQueueSize;
    private final boolean enforceIQResult;

    public AbstractComponent() {
        this(17, 1000, true);
    }

    public AbstractComponent(int maxThreadpoolSize, int maxQueueSize, boolean enforceIQResult) {
        this.maxThreadPoolSize = maxThreadpoolSize;
        this.maxQueueSize = maxQueueSize;
        this.enforceIQResult = enforceIQResult;
    }

    public final void initialize(JID jid, String host, ComponentManager componentManager) throws ComponentException {
        this.compMan = componentManager;
    }

    public final void processPacket(Packet packet) {
        block2: {
            Packet copy = packet.createCopy();
            try {
                this.executor.execute(new PacketProcessor(copy));
            }
            catch (RejectedExecutionException ex) {
                this.log.error("(serving component '" + this.getName() + "') Unable to process packet! " + "Is the thread pool queue exhausted? " + "Packet dropped in component '" + this.getName() + "'. Packet that's dropped: " + packet.toXML(), (Throwable)ex);
                if (!(packet instanceof IQ) || !((IQ)packet).isRequest()) break block2;
                IQ response = IQ.createResultIQ((IQ)packet);
                response.setError(PacketError.Condition.internal_server_error);
                this.send(response);
            }
        }
    }

    private final void processQueuedPacket(Packet packet) {
        if (packet instanceof IQ) {
            this.processIQ((IQ)packet);
        } else if (packet instanceof Message) {
            this.processMessage((Message)packet);
        } else if (packet instanceof Presence) {
            this.processPresence((Presence)packet);
        }
    }

    private final void processIQ(IQ iq) {
        IQ response;
        block12: {
            this.log.debug("(serving component '{}') Processing IQ (packetId {}).", (Object)this.getName(), (Object)iq.getID());
            response = null;
            IQ.Type type = iq.getType();
            try {
                switch (type) {
                    case get: 
                    case set: {
                        String requestID = iq.getID();
                        response = this.processIQRequest(iq);
                        if (response == null) {
                            if (!this.enforceIQResult) break;
                            response = IQ.createResultIQ(iq);
                            response.setError(PacketError.Condition.feature_not_implemented);
                            break;
                        }
                        if (!response.isResponse()) {
                            throw new IllegalStateException("Responses to IQ of type <tt>get</tt> or <tt>set</tt> can only be IQ stanza's of type <tt>error</tt> or <tt>result</tt>. The response to this packet was incorrect: " + iq.toXML() + ". The response was: " + response.toXML());
                        }
                        if (requestID.equals(response.getID())) break;
                        throw new IllegalStateException("The response to an request IQ must have the same packet ID. If this was done intentionally, #send(Packet) should have been used instead. The response to this packet was incorrect: " + iq.toXML() + ". The response was: " + response.toXML());
                    }
                    case result: {
                        if (this.servesLocalUsersOnly() && !this.sentByLocalEntity(iq)) {
                            this.log.info("(serving component '{}') Dropping IQ stanza sent by a user from another domain: {}", (Object)this.getName(), (Object)iq.getFrom());
                            this.log.debug("(serving component '{}') Dropping IQ stanza sent by a user from another domain: {}", (Object)this.getName(), (Object)iq.toXML());
                            return;
                        }
                        this.handleIQResult(iq);
                        break;
                    }
                    case error: {
                        if (this.servesLocalUsersOnly() && !this.sentByLocalEntity(iq)) {
                            this.log.info("(serving component '{}') Dropping IQ stanza sent by a user from another domain: {}", (Object)this.getName(), (Object)iq.getFrom());
                            this.log.debug("(serving component '{}') Dropping IQ stanza sent by a user from another domain: {}", (Object)this.getName(), (Object)iq.toXML());
                            return;
                        }
                        this.handleIQError(iq);
                    }
                }
            }
            catch (Exception ex) {
                this.log.warn("(serving component '" + this.getName() + "') Unexpected exception while processing IQ stanza: " + iq.toXML(), (Throwable)ex);
                if (!iq.isRequest()) break block12;
                response = IQ.createResultIQ(iq);
                response.setError(PacketError.Condition.internal_server_error);
            }
        }
        if (response != null) {
            this.send(response);
        }
    }

    private final void processMessage(Message message) {
        if (this.servesLocalUsersOnly() && !this.sentByLocalEntity(message)) {
            this.log.info("(serving component '{}') Dropping IQ stanza sent by a user from another domain: {}", (Object)this.getName(), (Object)message.getFrom());
            this.log.debug("(serving component '{}') Dropping IQ stanza sent by a user from another domain: {}", (Object)this.getName(), (Object)message.toXML());
            return;
        }
        this.handleMessage(message);
    }

    private final void processPresence(Presence presence) {
        if (this.servesLocalUsersOnly() && !this.sentByLocalEntity(presence)) {
            this.log.info("(serving component '{}') Dropping IQ stanza sent by a user from another domain: {}", (Object)this.getName(), (Object)presence.getFrom());
            this.log.debug("(serving component '{}') Dropping IQ stanza sent by a user from another domain: {}", (Object)this.getName(), (Object)presence.toXML());
            return;
        }
        this.handlePresence(presence);
    }

    private final IQ processIQRequest(IQ iq) throws Exception {
        this.log.debug("(serving component '{}') Processing IQ request (packetId {}).", (Object)this.getName(), (Object)iq.getID());
        Element childElement = iq.getChildElement();
        String namespace = null;
        if (childElement != null) {
            namespace = childElement.getNamespaceURI();
        }
        if (namespace == null) {
            this.log.debug("(serving component '{}') Invalid XMPP - no child element or namespace in IQ request (packetId {})", (Object)this.getName(), (Object)iq.getID());
            IQ response = IQ.createResultIQ(iq);
            response.setError(PacketError.Condition.bad_request);
            return response;
        }
        if (this.servesLocalUsersOnly() && !this.sentByLocalEntity(iq)) {
            this.log.info("(serving component '{}') Returning 'not-authorized' IQ error to a user from another domain: {}", (Object)this.getName(), (Object)iq.getFrom());
            this.log.debug("(serving component '{}') Returning 'not-authorized' IQ error to a user from another domain: {}", (Object)this.getName(), (Object)iq.toXML());
            IQ error = IQ.createResultIQ(iq);
            error.setError(PacketError.Condition.not_authorized);
            return error;
        }
        IQ.Type type = iq.getType();
        if (type == IQ.Type.get) {
            if (NAMESPACE_DISCO_INFO.equals(namespace)) {
                this.log.trace("(serving component '{}') Calling #handleDiscoInfo() (packetId {}).", (Object)this.getName(), (Object)iq.getID());
                return this.handleDiscoInfo(iq);
            }
            if (NAMESPACE_DISCO_ITEMS.equals(namespace)) {
                this.log.trace("(serving component '{}') Calling #handleDiscoItems() (packetId {}).", (Object)this.getName(), (Object)iq.getID());
                return this.handleDiscoItems(iq);
            }
            if (NAMESPACE_XMPP_PING.equals(namespace)) {
                this.log.trace("(serving component '{}') Calling #handlePing() (packetId {}).", (Object)this.getName(), (Object)iq.getID());
                return this.handlePing(iq);
            }
            return this.handleIQGet(iq);
        }
        if (type == IQ.Type.set) {
            return this.handleIQSet(iq);
        }
        return null;
    }

    protected void handleIQResult(IQ iq) {
    }

    protected void handleIQError(IQ iq) {
        this.log.info("(serving component '{}') IQ stanza of type <tt>error</tt> received: ", (Object)this.getName(), (Object)iq.toXML());
    }

    protected IQ handleIQGet(IQ iq) throws Exception {
        return null;
    }

    protected IQ handleIQSet(IQ iq) throws Exception {
        return null;
    }

    protected IQ handleDiscoItems(IQ iq) {
        return null;
    }

    protected IQ handleDiscoInfo(IQ iq) {
        IQ replyPacket = IQ.createResultIQ(iq);
        Element responseElement = replyPacket.setChildElement("query", NAMESPACE_DISCO_INFO);
        responseElement.addElement("identity").addAttribute("category", this.discoInfoIdentityCategory()).addAttribute("type", this.discoInfoIdentityCategoryType()).addAttribute("name", this.getName());
        responseElement.addElement("feature").addAttribute("var", NAMESPACE_DISCO_INFO);
        responseElement.addElement("feature").addAttribute("var", NAMESPACE_XMPP_PING);
        for (String feature : this.discoInfoFeatureNamespaces()) {
            responseElement.addElement("feature").addAttribute("var", feature);
        }
        return replyPacket;
    }

    protected IQ handlePing(IQ iq) {
        return IQ.createResultIQ(iq);
    }

    public abstract String getDescription();

    public abstract String getName();

    public abstract String getDomain();

    protected String discoInfoIdentityCategory() {
        return "component";
    }

    protected String discoInfoIdentityCategoryType() {
        return "generic";
    }

    protected String[] discoInfoFeatureNamespaces() {
        return new String[0];
    }

    protected void handleMessage(Message message) {
    }

    protected void handlePresence(Presence presence) {
    }

    public boolean servesLocalUsersOnly() {
        return false;
    }

    public final void shutdown() {
        this.preComponentShutdown();
        this.closeQueue();
        this.postComponentShutdown();
    }

    private void closeQueue() {
        this.log.debug("Closing queue...");
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(2L, TimeUnit.SECONDS)) {
                List<Runnable> wasAwatingExecution = this.executor.shutdownNow();
                for (Runnable abortMe : wasAwatingExecution) {
                    IQ iq;
                    Packet packet = ((PacketProcessor)abortMe).packet;
                    if (!(packet instanceof IQ) || !(iq = (IQ)packet).isRequest()) continue;
                    this.log.debug("Responding 'service unavailable' to unprocessed stanza: {}", (Object)iq.toXML());
                    IQ error = IQ.createResultIQ(iq);
                    error.setError(PacketError.Condition.service_unavailable);
                    this.send(error);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void send(Packet packet) {
        try {
            this.compMan.sendPacket(this, packet);
        }
        catch (ComponentException e) {
            this.log.warn("(serving component '" + this.getName() + "') Could not send packet!", (Throwable)e);
        }
    }

    public void preComponentShutdown() {
    }

    public void postComponentShutdown() {
    }

    public void start() {
        this.preComponentStart();
        if (this.executor == null || this.executor.isShutdown()) {
            this.executor = new ThreadPoolExecutor(this.maxThreadPoolSize, this.maxThreadPoolSize, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(this.maxQueueSize));
        }
        this.postComponentStart();
    }

    public void preComponentStart() {
    }

    public void postComponentStart() {
    }

    private boolean sentByLocalEntity(Packet packet) {
        JID from = packet.getFrom();
        if (from == null) {
            return true;
        }
        String domain = from.getDomain();
        return domain.equals(this.getDomain()) || domain.endsWith("." + this.getDomain());
    }

    private class PacketProcessor
    implements Runnable {
        private final Packet packet;

        public PacketProcessor(Packet packet) {
            this.packet = packet;
        }

        public void run() {
            AbstractComponent.this.processQueuedPacket(this.packet);
        }
    }
}

