/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.whack;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.XMLWriter;
import org.dom4j.io.XPPPacketReader;
import org.jivesoftware.whack.ExternalComponentManager;
import org.jivesoftware.whack.SocketReadThread;
import org.jivesoftware.whack.util.StringUtils;
import org.jivesoftware.whack.util.TaskEngine;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;
import org.xmpp.component.Component;
import org.xmpp.component.ComponentException;
import org.xmpp.component.ComponentManager;
import org.xmpp.component.IQResultListener;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;
import org.xmpp.packet.Packet;
import org.xmpp.packet.StreamError;

public class ExternalComponent
implements Component {
    private static String CHARSET = "UTF-8";
    private Component component;
    private ExternalComponentManager manager;
    private Socket socket;
    private XMLWriter xmlSerializer;
    private XmlPullParserFactory factory = null;
    private XPPPacketReader reader = null;
    private Writer writer = null;
    private boolean shutdown = false;
    private boolean reconnecting = false;
    private KeepAliveTask keepAliveTask;
    private TimeoutTask timeoutTask;
    private long lastActive = System.currentTimeMillis();
    private String connectionID;
    private String domain;
    private String subdomain;
    private String host;
    private int port;
    private ThreadPoolExecutor threadPool;
    private SocketReadThread readerThread;
    private Map<String, IQResultListener> resultListeners = new ConcurrentHashMap<String, IQResultListener>();
    private Map<String, Long> resultTimeout = new ConcurrentHashMap<String, Long>();

    public ExternalComponent(Component component, ExternalComponentManager manager) {
        this(component, manager, 25);
    }

    public ExternalComponent(Component component, ExternalComponentManager manager, int maxThreads) {
        this.component = component;
        this.manager = manager;
        this.threadPool = new ThreadPoolExecutor(maxThreads, maxThreads, 15L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    public void connect(String host, int port, String subdomain) throws ComponentException {
        try {
            this.socket = new Socket();
            this.socket.connect(new InetSocketAddress(host, port), this.manager.getConnectTimeout());
            this.domain = this.manager.getServerName() != null ? subdomain + "." + this.manager.getServerName() : subdomain;
            this.subdomain = subdomain;
            this.host = host;
            this.port = port;
            try {
                this.factory = XmlPullParserFactory.newInstance();
                this.reader = new XPPPacketReader();
                this.reader.setXPPFactory(this.factory);
                this.reader.getXPPParser().setInput((Reader)new InputStreamReader(this.socket.getInputStream(), CHARSET));
                this.writer = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream(), CHARSET));
                StringBuilder stream = new StringBuilder();
                stream.append("<stream:stream");
                stream.append(" xmlns=\"jabber:component:accept\"");
                stream.append(" xmlns:stream=\"http://etherx.jabber.org/streams\"");
                if (this.manager.isMultipleAllowed(subdomain)) {
                    stream.append(" allowMultiple=\"true\"");
                }
                stream.append(" to=\"").append(this.domain).append("\">");
                this.writer.write(stream.toString());
                this.writer.flush();
                stream = null;
                XmlPullParser xpp = this.reader.getXPPParser();
                int eventType = xpp.getEventType();
                while (eventType != 2) {
                    eventType = xpp.next();
                }
                this.connectionID = xpp.getAttributeValue("", "id");
                if (xpp.getAttributeValue("", "from") != null) {
                    this.domain = xpp.getAttributeValue("", "from");
                }
                this.xmlSerializer = new XMLWriter(this.writer);
                stream = new StringBuilder();
                stream.append("<handshake>");
                stream.append(StringUtils.hash(this.connectionID + this.manager.getSecretKey(subdomain)));
                stream.append("</handshake>");
                this.writer.write(stream.toString());
                this.writer.flush();
                stream = null;
                try {
                    Element doc = this.reader.parseDocument().getRootElement();
                    if ("error".equals(doc.getName())) {
                        StreamError error = new StreamError(doc);
                        this.socket.close();
                        this.socket = null;
                        throw new ComponentException(error);
                    }
                    this.keepAliveTask = new KeepAliveTask();
                    TaskEngine.getInstance().scheduleAtFixedRate((TimerTask)this.keepAliveTask, 15000L, 30000L);
                    this.timeoutTask = new TimeoutTask();
                    TaskEngine.getInstance().scheduleAtFixedRate((TimerTask)this.timeoutTask, 2000L, 2000L);
                }
                catch (DocumentException e) {
                    try {
                        this.socket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw new ComponentException((Throwable)e);
                }
                catch (XmlPullParserException e) {
                    try {
                        this.socket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw new ComponentException((Throwable)e);
                }
            }
            catch (XmlPullParserException e) {
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw new ComponentException((Throwable)e);
            }
        }
        catch (UnknownHostException uhe) {
            try {
                if (this.socket != null) {
                    this.socket.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new ComponentException((Throwable)uhe);
        }
        catch (IOException ioe) {
            try {
                if (this.socket != null) {
                    this.socket.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new ComponentException((Throwable)ioe);
        }
    }

    public Component getComponent() {
        return this.component;
    }

    public String getName() {
        return this.component.getName();
    }

    public String getDescription() {
        return this.component.getDescription();
    }

    public String getDomain() {
        return this.domain;
    }

    public String getSubdomain() {
        return this.subdomain;
    }

    ExternalComponentManager getManager() {
        return this.manager;
    }

    public void processPacket(final Packet packet) {
        this.threadPool.execute(new Runnable(){

            public void run() {
                IQ iq;
                IQ.Type iqType;
                if (packet instanceof IQ && (IQ.Type.result == (iqType = (iq = (IQ)packet).getType()) || IQ.Type.error == iqType)) {
                    IQResultListener iqResultListener = (IQResultListener)ExternalComponent.this.resultListeners.remove(iq.getID());
                    ExternalComponent.this.resultTimeout.remove(iq.getID());
                    if (iqResultListener != null) {
                        try {
                            iqResultListener.receivedAnswer(iq);
                        }
                        catch (Exception e) {
                            ExternalComponent.this.manager.getLog().error("Error processing answer of remote entity", e);
                        }
                        return;
                    }
                }
                ExternalComponent.this.component.processPacket(packet);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Packet packet) {
        Writer writer = this.writer;
        synchronized (writer) {
            block5: {
                try {
                    this.xmlSerializer.write(packet.getElement());
                    this.xmlSerializer.flush();
                    this.lastActive = System.currentTimeMillis();
                }
                catch (IOException e) {
                    this.manager.getLog().error(e);
                    if (this.shutdown) break block5;
                    this.connectionLost();
                }
            }
        }
    }

    public void initialize(JID jid, ComponentManager componentManager) throws ComponentException {
        this.component.initialize(jid, componentManager);
    }

    public void start() {
        this.readerThread = new SocketReadThread(this, this.reader);
        this.readerThread.setDaemon(true);
        this.readerThread.start();
        this.component.start();
    }

    public void shutdown() {
        this.shutdown = true;
        this.component.shutdown();
        this.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnect() {
        if (this.readerThread != null) {
            this.readerThread.shutdown();
        }
        this.threadPool.shutdown();
        TaskEngine.getInstance().cancelScheduledTask(this.keepAliveTask);
        TaskEngine.getInstance().cancelScheduledTask(this.timeoutTask);
        if (this.socket != null && !this.socket.isClosed()) {
            try {
                Writer writer = this.writer;
                synchronized (writer) {
                    try {
                        this.writer.write("</stream:stream>");
                        this.xmlSerializer.flush();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.socket.close();
            }
            catch (Exception e) {
                this.manager.getLog().error(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionLost() {
        ExternalComponent externalComponent = this;
        synchronized (externalComponent) {
            if (this.reconnecting) {
                return;
            }
            this.reconnecting = true;
        }
        this.readerThread = null;
        boolean isConnected = false;
        if (!this.shutdown) {
            this.component.shutdown();
        }
        while (!isConnected && !this.shutdown) {
            try {
                this.connect(this.host, this.port, this.subdomain);
                isConnected = true;
                if (this.shutdown) {
                    this.disconnect();
                    continue;
                }
                this.start();
            }
            catch (ComponentException e) {
                this.manager.getLog().error("Error trying to reconnect with the server", e);
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.reconnecting = false;
    }

    void addIQResultListener(String id, IQResultListener listener, long timeoutmillis) {
        this.resultListeners.put(id, listener);
        this.resultTimeout.put(id, System.currentTimeMillis() + timeoutmillis);
    }

    private class TimeoutTask
    extends TimerTask {
        private TimeoutTask() {
        }

        public void run() {
            Iterator it = ExternalComponent.this.resultTimeout.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry pointer = it.next();
                if (System.currentTimeMillis() < (Long)pointer.getValue()) continue;
                String packetId = (String)pointer.getKey();
                IQResultListener listener = (IQResultListener)ExternalComponent.this.resultListeners.remove(packetId);
                if (listener != null) {
                    listener.answerTimeout(packetId);
                }
                it.remove();
            }
        }
    }

    private class KeepAliveTask
    extends TimerTask {
        private KeepAliveTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Writer writer = ExternalComponent.this.writer;
            synchronized (writer) {
                if (System.currentTimeMillis() - ExternalComponent.this.lastActive >= 30000L) {
                    try {
                        ExternalComponent.this.writer.write(" ");
                        ExternalComponent.this.writer.flush();
                    }
                    catch (IOException e) {
                        ExternalComponent.this.manager.getLog().error(e);
                        if (!ExternalComponent.this.shutdown) {
                            ExternalComponent.this.connectionLost();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

