/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.whack;

import org.dom4j.Element;
import org.dom4j.io.XPPPacketReader;
import org.jivesoftware.whack.ExternalComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.XmlPullParserException;
import org.xmpp.packet.IQ;
import org.xmpp.packet.Message;
import org.xmpp.packet.Packet;
import org.xmpp.packet.Presence;
import org.xmpp.packet.Roster;

class SocketReadThread
extends Thread {
    private static final Logger Log = LoggerFactory.getLogger(SocketReadThread.class);
    private ExternalComponent component;
    private boolean shutdown = false;
    XPPPacketReader reader = null;

    public SocketReadThread(ExternalComponent component, XPPPacketReader reader) {
        super("Component socket reader");
        this.component = component;
        this.reader = reader;
    }

    @Override
    public void run() {
        block2: {
            try {
                this.readStream();
            }
            catch (Exception e) {
                if (this.shutdown) break block2;
                Log.error("Unexpected exception", (Throwable)e);
                this.component.connectionLost();
            }
        }
    }

    private void readStream() throws Exception {
        while (!this.shutdown) {
            Message packet;
            Element doc = this.reader.parseDocument().getRootElement();
            if (doc == null) {
                return;
            }
            String tag = doc.getName();
            if ("message".equals(tag)) {
                packet = new Message(doc);
            } else if ("presence".equals(tag)) {
                packet = new Presence(doc);
            } else if ("iq".equals(tag)) {
                packet = this.getIQ(doc);
            } else {
                throw new XmlPullParserException("Unknown packet type was read: " + tag);
            }
            this.component.processPacket((Packet)packet);
        }
    }

    private IQ getIQ(Element doc) {
        Element query = doc.element("query");
        if (query != null && "jabber:iq:roster".equals(query.getNamespaceURI())) {
            return new Roster(doc);
        }
        return new IQ(doc);
    }

    public void shutdown() {
        this.shutdown = true;
    }
}

