/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.weather;

import net.sf.jweather.Weather;
import net.sf.jweather.metar.Metar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.component.AbstractComponent;
import org.xmpp.packet.Message;
import org.xmpp.packet.Packet;

public class WeatherComponent
extends AbstractComponent {
    Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private String serverDomain;
    private String name;

    public WeatherComponent(String name, String serverDomain) {
        this.name = name;
        this.serverDomain = serverDomain;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return "Weather component - sample component";
    }

    public String getDomain() {
        return this.serverDomain;
    }

    protected void handleMessage(Message message) {
        System.out.println("Received message:" + message.toXML());
        String station = message.getBody();
        Metar metar = Weather.getMetar((String)station, (int)5000);
        Message reply = new Message();
        reply.setTo(message.getFrom());
        reply.setFrom(message.getTo());
        reply.setType(message.getType());
        reply.setThread(message.getThread());
        if (metar != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("station id : " + metar.getStationID());
            sb.append("\rwind dir   : " + metar.getWindDirection() + " degrees");
            sb.append("\rwind speed : " + metar.getWindSpeedInMPH() + " mph, " + metar.getWindSpeedInKnots() + " knots");
            if (!metar.getVisibilityLessThan()) {
                sb.append("\rvisibility : " + metar.getVisibility() + " mile(s)");
            } else {
                sb.append("\rvisibility : < " + metar.getVisibility() + " mile(s)");
            }
            sb.append("\rpressure   : " + metar.getPressure() + " in Hg");
            sb.append("\rtemperaturePrecise: " + metar.getTemperaturePreciseInCelsius() + " C, " + metar.getTemperaturePreciseInFahrenheit() + " F");
            sb.append("\rtemperature: " + metar.getTemperatureInCelsius() + " C, " + metar.getTemperatureInFahrenheit() + " F");
            sb.append("\rtemperatureMostPrecise: " + metar.getTemperatureMostPreciseInCelsius() + " C, " + metar.getTemperatureMostPreciseInFahrenheit() + " F");
            reply.setBody(sb.toString());
        } else {
            reply.setBody("Unknown station ID");
        }
        this.send((Packet)reply);
    }
}

