/*
 * Decompiled with CFR 0.152.
 */
package org.iherus.codegen.qrcode.renderer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import org.iherus.codegen.qrcode.QreyesFormat;
import org.iherus.codegen.qrcode.QreyesPosition;
import org.iherus.codegen.qrcode.QreyesRenderer;
import org.iherus.codegen.utils.ReflectionUtils;

public class DR2BRPQreyesRenderer
implements QreyesRenderer {
    private static final int ARC = 13;

    @Override
    public void render(BufferedImage image, QreyesFormat format, QreyesPosition position, Color slave, Color border, Color point) {
        this.checkFormat(format);
        int width = image.getWidth();
        int height = image.getHeight();
        int borderSize = position.getBorderSize(width);
        String[] directions = new String[]{"topLeft", "topRight", "bottomLeft"};
        Graphics2D graphics = image.createGraphics();
        graphics.setBackground(slave);
        for (String direction : directions) {
            int[] rect = (int[])ReflectionUtils.invokeMethod(position, direction + "Rect");
            graphics.clearRect(rect[0], rect[1], rect[2], rect[3]);
            int x = rect[0] + borderSize / 2;
            int y = rect[1] + borderSize / 2;
            Shape shape = new RoundRectangle2D.Double(x, y, rect[2] - borderSize, rect[3] - borderSize, 13.0, 13.0);
            graphics.setColor(slave);
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.fill(shape);
            graphics.setStroke(new BasicStroke(borderSize));
            graphics.setColor(border);
            graphics.draw(shape);
            Graphics graphicsX = graphics.create();
            if (directions[0].equals(direction)) {
                graphicsX.drawLine(x, y, x, y + 13);
                graphicsX.drawLine(x, y, x + 13, y);
                x = position.getLeftEndX() - borderSize / 2 - 1;
                y = position.getTopEndY() - borderSize / 2 - 1;
                graphicsX.drawLine(x, y, x, y - 13);
                graphicsX.drawLine(x, y, x - 13, y);
            } else if (directions[1].equals(direction)) {
                x = position.getRightStartX() + borderSize / 2;
                y = position.getTopEndY() - borderSize / 2 - 1;
                graphicsX.drawLine(x, y, x, y - 13);
                graphicsX.drawLine(x, y, x + 13, y);
                x = position.getRightEndX() - borderSize / 2 - 1;
                y = position.getTopStartY() + borderSize / 2;
                graphicsX.drawLine(x, y, x, y + 13);
                graphicsX.drawLine(x, y, x - 13, y);
            } else {
                x = position.getLeftStartX() + borderSize / 2;
                y = position.getBottomEndY() - borderSize / 2 - 1;
                graphicsX.drawLine(x, y, x, y - 13);
                graphicsX.drawLine(x, y, x + 13, y);
                x = position.getLeftEndX() - borderSize / 2 - 1;
                y = position.getBottomStartY() + borderSize / 2;
                graphicsX.drawLine(x, y, x, y + 13);
                graphicsX.drawLine(x, y, x - 13, y);
            }
            rect = (int[])ReflectionUtils.invokeMethod(position.focusPoint(width, height), direction + "Point");
            shape = this.getPointShape(rect[0], rect[1], rect[2], rect[3], 5.0, 5.0);
            graphics.setColor(point);
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.fill(shape);
            graphics.setStroke(new BasicStroke(0.0f));
            graphics.setColor(point);
            graphics.draw(shape);
        }
        graphics.dispose();
        image.flush();
    }

    @Override
    public Shape getPointShape(double x, double y, double w, double h, double arcw, double arch) {
        return new RoundRectangle2D.Double(x, y, w, h, arcw, arch);
    }

    @Override
    public void checkFormat(QreyesFormat format) {
        if (QreyesFormat.DR2_BORDER_R_POINT != format) {
            throw new IllegalArgumentException("Can only render DR2_BORDER_R_POINT, but got " + (Object)((Object)format));
        }
    }
}

