/*
 * Decompiled with CFR 0.152.
 */
package org.iherus.codegen.qrcode.renderer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import org.iherus.codegen.qrcode.QreyesFormat;
import org.iherus.codegen.qrcode.QreyesPosition;
import org.iherus.codegen.qrcode.QreyesRenderer;
import org.iherus.codegen.utils.ReflectionUtils;

public class RBRPQreyesRenderer
implements QreyesRenderer {
    @Override
    public void render(BufferedImage image, QreyesFormat format, QreyesPosition position, Color slave, Color border, Color point) {
        this.checkFormat(format);
        int width = image.getWidth();
        int height = image.getHeight();
        int borderSize = position.getBorderSize(width);
        String[] directions = new String[]{"topLeft", "topRight", "bottomLeft"};
        Graphics2D graphics = image.createGraphics();
        graphics.setBackground(slave);
        for (String direction : directions) {
            int[] rect = (int[])ReflectionUtils.invokeMethod(position, direction + "Rect");
            graphics.clearRect(rect[0], rect[1], rect[2], rect[3]);
            Shape shape = new Rectangle2D.Float(rect[0] + borderSize / 2, rect[1] + borderSize / 2, rect[2] - borderSize, rect[3] - borderSize);
            graphics.setColor(slave);
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.fill(shape);
            graphics.setStroke(new BasicStroke(borderSize));
            graphics.setColor(border);
            graphics.draw(shape);
            rect = (int[])ReflectionUtils.invokeMethod(position.focusPoint(width, height), direction + "Point");
            shape = this.getPointShape(rect[0], rect[1], rect[2], rect[3], 5.0, 5.0);
            graphics.setColor(point);
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.fill(shape);
            graphics.setStroke(new BasicStroke(0.0f));
            graphics.setColor(point);
            graphics.draw(shape);
        }
        graphics.dispose();
        image.flush();
    }

    @Override
    public void checkFormat(QreyesFormat format) {
        if (QreyesFormat.R_BORDER_R_POINT != format) {
            throw new IllegalArgumentException("Can only render R_BORDER_R_POINT, but got " + (Object)((Object)format));
        }
    }

    @Override
    public Shape getPointShape(double x, double y, double w, double h, double arcw, double arch) {
        return new RoundRectangle2D.Double(x, y, w, h, arcw, arch);
    }
}

