/*
 * Decompiled with CFR 0.152.
 */
package org.iherus.shiro.cache.redis;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.cache.CacheException;
import org.apache.shiro.util.CollectionUtils;
import org.iherus.shiro.cache.redis.RedisCachePool;
import org.iherus.shiro.util.ArrayUtils;
import org.iherus.shiro.util.SerializeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.util.SafeEncoder;

public class RedisCache<K, V>
implements Cache<K, V>,
Serializable {
    private static final long serialVersionUID = 4521785299624111291L;
    private static final Logger logger = LoggerFactory.getLogger(RedisCache.class);
    private static final String DEFAULT_CACHE_NAME = "shiro_redis_cache";
    private String name = "shiro_redis_cache";
    private String shiroCacheKeyPrefix;
    protected RedisCachePool cachePool;

    public RedisCache(RedisCachePool cachePool) {
        this.cachePool = cachePool;
    }

    public RedisCache(RedisCachePool cachePool, String name) {
        if (cachePool == null) {
            throw new IllegalArgumentException("CachePool argument cannot be null.");
        }
        this.cachePool = cachePool;
        this.name = name;
    }

    private final byte[] getKeyToBytes(K key) {
        if (key instanceof byte[]) {
            return (byte[])key;
        }
        byte[] preBytes = this.getPrefixToBytes();
        byte[] keyBytes = SerializeUtils.serialize(key);
        return ArrayUtils.mergeAll(preBytes, keyBytes);
    }

    private final byte[] getPrefixToBytes() {
        return SafeEncoder.encode((String)this.getShiroCacheKeyPrefix());
    }

    private final byte[] getKeyPattern() {
        return SafeEncoder.encode((String)(this.getShiroCacheKeyPrefix() + "*"));
    }

    public V get(K key) throws CacheException {
        if (logger.isDebugEnabled()) {
            logger.debug("Getting object from cache [" + this.getName() + "] for key [" + key + "]");
        }
        Jedis jedis = RedisCache.initJedis(this.cachePool);
        try {
            if (key == null) {
                V v = null;
                return v;
            }
            byte[] value = jedis.get(this.getKeyToBytes(key));
            if (value == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Cache for [" + key + "] is null.");
                }
                V v = null;
                return v;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Cache for [" + key + "] is exist, ready to use it.");
            }
            Object object = SerializeUtils.deserialize(value);
            return (V)object;
        }
        catch (Throwable t) {
            throw new CacheException(t);
        }
        finally {
            RedisCache.close(jedis);
        }
    }

    public V put(K key, V value) throws CacheException {
        if (logger.isDebugEnabled()) {
            logger.debug("Putting object in cache [" + this.getName() + "] for key [" + key + "]");
        }
        Jedis jedis = RedisCache.initJedis(this.cachePool);
        try {
            V previous = this.get(key);
            byte[] nval = SerializeUtils.serialize(value);
            jedis.set(this.getKeyToBytes(key), nval);
            V v = previous;
            return v;
        }
        catch (Throwable t) {
            throw new CacheException(t);
        }
        finally {
            RedisCache.close(jedis);
        }
    }

    public V remove(K key) throws CacheException {
        if (logger.isDebugEnabled()) {
            logger.debug("Removing object from cache [" + this.getName() + "] for key [" + key + "]");
        }
        Jedis jedis = RedisCache.initJedis(this.cachePool);
        try {
            V previous = this.get(key);
            long statusCode = jedis.del(this.getKeyToBytes(key));
            if (statusCode > 0L && logger.isInfoEnabled()) {
                logger.info("Remove key [{}] successfully.", key);
            }
            V v = previous;
            return v;
        }
        catch (Throwable t) {
            throw new CacheException(t);
        }
        finally {
            RedisCache.close(jedis);
        }
    }

    public void clear() throws CacheException {
        if (logger.isDebugEnabled()) {
            logger.debug("Clearing all objects from cache [" + this.getName() + "]");
        }
        Jedis jedis = RedisCache.initJedis(this.cachePool);
        try {
            String statusCode = jedis.flushDB();
            if ("OK".equalsIgnoreCase(statusCode) && logger.isInfoEnabled()) {
                logger.info("Flush DB_{} successfully.", (Object)jedis.getDB());
            }
        }
        catch (Throwable t) {
            throw new CacheException(t);
        }
        finally {
            RedisCache.close(jedis);
        }
    }

    public int size() {
        Jedis jedis = RedisCache.initJedis(this.cachePool);
        try {
            long size = jedis.dbSize();
            int n = Long.valueOf(size).intValue();
            return n;
        }
        catch (Throwable t) {
            throw new CacheException(t);
        }
        finally {
            RedisCache.close(jedis);
        }
    }

    public Set<K> keys() {
        Jedis jedis = RedisCache.initJedis(this.cachePool);
        try {
            Set keySet = jedis.keys(this.getKeyPattern());
            if (!CollectionUtils.isEmpty((Collection)keySet)) {
                LinkedHashSet<byte[]> keys = new LinkedHashSet<byte[]>();
                for (byte[] key : keySet) {
                    keys.add(key);
                }
                LinkedHashSet<byte[]> linkedHashSet = keys;
                return linkedHashSet;
            }
            Set set = Collections.emptySet();
            return set;
        }
        catch (Throwable t) {
            throw new CacheException(t);
        }
        finally {
            RedisCache.close(jedis);
        }
    }

    public Collection<V> values() {
        try {
            Set<K> keys = this.keys();
            if (!CollectionUtils.isEmpty(keys)) {
                ArrayList<V> values = new ArrayList<V>(keys.size());
                for (K key : keys) {
                    V value = this.get(key);
                    if (value == null) continue;
                    values.add(value);
                }
                return Collections.unmodifiableList(values);
            }
            return Collections.emptyList();
        }
        catch (Throwable t) {
            throw new CacheException(t);
        }
    }

    public static Jedis initJedis(RedisCachePool cachePool) {
        if (cachePool == null) {
            throw new IllegalArgumentException("CachePool argument cannot be null.");
        }
        Jedis jedis = null;
        try {
            jedis = cachePool.getResource();
            jedis.select(cachePool.getDatabaseIndex());
            if (logger.isDebugEnabled()) {
                logger.debug("The current application database is located in DB_{}.", (Object)jedis.getDB());
            }
            return jedis;
        }
        catch (Exception e) {
            RedisCache.close(jedis);
            throw new CacheException((Throwable)e);
        }
    }

    public static void close(Jedis jedis) {
        if (jedis != null) {
            jedis.close();
        }
    }

    public String toString() {
        return "RedisCache [" + this.getName() + "]";
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getShiroCacheKeyPrefix() {
        return this.shiroCacheKeyPrefix;
    }

    public void setShiroCacheKeyPrefix(String shiroCacheKeyPrefix) {
        this.shiroCacheKeyPrefix = shiroCacheKeyPrefix;
    }
}

