/*
 * Decompiled with CFR 0.152.
 */
package org.iherus.shiro.cache.redis;

import org.apache.shiro.ShiroException;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.cache.CacheException;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.util.Destroyable;
import org.apache.shiro.util.Initializable;
import org.iherus.shiro.cache.redis.RedisCache;
import org.iherus.shiro.cache.redis.RedisCacheConfigFactory;
import org.iherus.shiro.cache.redis.RedisCachePool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisCacheManager
implements CacheManager,
Initializable,
Destroyable {
    private static final Logger logger = LoggerFactory.getLogger(RedisCacheManager.class);
    private static final String DEFAULT_CACHE_KEY_PREFIX = "shiro_cache_";
    protected RedisCachePool cachePool;
    private String shiroCacheKeyPrefix = "shiro_cache_";
    private RedisCacheConfigFactory configFactory;
    private boolean cachePoolImplicitlyCreated = false;

    public RedisCachePool getCachePool() {
        return this.cachePool;
    }

    public String getShiroCacheKeyPrefix() {
        return this.shiroCacheKeyPrefix;
    }

    public void setShiroCacheKeyPrefix(String shiroCacheKeyPrefix) {
        this.shiroCacheKeyPrefix = shiroCacheKeyPrefix;
    }

    public RedisCacheConfigFactory getConfigFactory() {
        return this.configFactory;
    }

    public void setConfigFactory(RedisCacheConfigFactory configFactory) {
        this.configFactory = configFactory;
    }

    public final void init() throws ShiroException {
        this.ensureCacheManager();
    }

    private RedisCachePool ensureCacheManager() {
        try {
            if (null == this.cachePool) {
                if (logger.isDebugEnabled()) {
                    logger.debug("cachePoolManager property not set. Constructing cachePoolManager instance... ");
                }
                this.cachePool = new RedisCachePool(this.configFactory);
                if (logger.isTraceEnabled()) {
                    logger.trace("instantiated Redis cachePool instance.");
                }
                this.cachePoolImplicitlyCreated = true;
                if (logger.isDebugEnabled()) {
                    logger.debug("implicit cachePool created successfully.");
                }
            }
            return this.cachePool;
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public <K, V> Cache<K, V> getCache(String name) throws CacheException {
        if (logger.isDebugEnabled()) {
            logger.debug("Acquiring Cache instance named [" + name + "]");
        }
        RedisCache redisCache = this.ensureCacheManager().getCache(name);
        redisCache.setShiroCacheKeyPrefix(this.getShiroCacheKeyPrefix());
        return redisCache;
    }

    public void destroy() throws Exception {
        if (this.cachePoolImplicitlyCreated) {
            block3: {
                try {
                    RedisCachePool cachePool = this.getCachePool();
                    cachePool.destroy();
                }
                catch (Exception e) {
                    if (!logger.isWarnEnabled()) break block3;
                    logger.warn("Unable to cleanly shutdown implicitly created CachePool instance.  Ignoring (shutting down)...");
                }
            }
            this.cachePoolImplicitlyCreated = false;
        }
    }
}

