/*
 * Decompiled with CFR 0.152.
 */
package org.iherus.shiro.cache.redis;

import java.io.Serializable;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.iherus.shiro.cache.redis.RedisCache;
import org.iherus.shiro.cache.redis.RedisCacheConfigFactory;
import org.iherus.shiro.util.SerializeUtils;
import org.iherus.shiro.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public class RedisCachePool
extends JedisPool
implements Serializable {
    private static final long serialVersionUID = -4990239742530217458L;
    private static final Logger logger = LoggerFactory.getLogger(RedisCachePool.class);
    private int databaseIndex;

    public RedisCachePool(RedisCacheConfigFactory factory) {
        super((GenericObjectPoolConfig)factory.getPoolConfig(), factory.host, factory.getPort(), factory.getTimeout(), factory.getPassword(), factory.getDatabase(), factory.clientName);
        this.databaseIndex = factory.getDatabase();
    }

    public RedisCache getCache(String name) {
        RedisCache cache = null;
        byte[] serializedValue = null;
        if (StringUtils.isNotEmpty(name)) {
            try (Jedis jedis = null;){
                jedis = this.getResource();
                byte[] key = name.getBytes();
                serializedValue = jedis.get(key);
                if (serializedValue == null) {
                    if (logger.isInfoEnabled()) {
                        logger.info("Cache with name '{}' does not yet exist.  Creating now.", (Object)name);
                    }
                    cache = new RedisCache(this, name);
                    serializedValue = SerializeUtils.serialize(cache);
                    jedis.set(key, serializedValue);
                    if (logger.isInfoEnabled()) {
                        logger.info("Added Cache named [" + name + "]");
                    }
                } else {
                    cache = (RedisCache)SerializeUtils.deserialize(serializedValue);
                    if (logger.isInfoEnabled()) {
                        logger.info("Using existing Cache named [" + cache.getName() + "]");
                    }
                }
                RedisCache redisCache = cache;
                return redisCache;
            }
        }
        return null;
    }

    public int getDatabaseIndex() {
        return this.databaseIndex;
    }

    public void setDatabaseIndex(int databaseIndex) {
        this.databaseIndex = databaseIndex;
    }
}

