/*
 * Decompiled with CFR 0.152.
 */
package org.iherus.shiro.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.iherus.shiro.exception.SerializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SerializeUtils {
    private static final Logger logger = LoggerFactory.getLogger(SerializeUtils.class);
    private static final int DEFAULT_BUFFER_SIZE = 1024;

    private SerializeUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] serialize(Object object) {
        if (object == null) {
            return new byte[0];
        }
        byte[] serializedValue = null;
        ByteArrayOutputStream byteOutStream = null;
        ObjectOutputStream objectOutStream = null;
        try {
            byteOutStream = new ByteArrayOutputStream(1024);
            objectOutStream = new ObjectOutputStream(byteOutStream);
            try {
                objectOutStream.writeObject(object);
            }
            catch (NotSerializableException ex) {
                throw new SerializationException(object.getClass().getName() + " does not implement Serializable or externalizable.", ex);
            }
            objectOutStream.flush();
            serializedValue = byteOutStream.toByteArray();
            if (logger.isDebugEnabled()) {
                logger.debug("Object serialzed successfully.");
            }
        }
        catch (Throwable e) {
            logger.error("Failed to serialize object of type: " + object.getClass().getName() + ".", e);
        }
        finally {
            if (objectOutStream != null) {
                try {
                    objectOutStream.close();
                    byteOutStream.close();
                }
                catch (IOException ex) {}
            }
        }
        return serializedValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object deserialize(byte[] serializedBytes) {
        if (null == serializedBytes || serializedBytes.length == 0) {
            return null;
        }
        Object source = null;
        ByteArrayInputStream byteInStream = null;
        ObjectInputStream objectInStream = null;
        try {
            byteInStream = new ByteArrayInputStream(serializedBytes);
            objectInStream = new ObjectInputStream(byteInStream);
            try {
                source = objectInStream.readObject();
            }
            catch (ClassNotFoundException ex) {
                throw new SerializationException("Failed to deserialize object type.", ex);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("SerializedBytes deserialzed successfully.");
            }
        }
        catch (Throwable e) {
            logger.error("Failed to deserialize.", e);
        }
        finally {
            if (objectInStream != null) {
                try {
                    objectInStream.close();
                    byteInStream.close();
                }
                catch (IOException ex) {}
            }
        }
        return source;
    }
}

