/*
 * Decompiled with CFR 0.152.
 */
package org.iherus.shiro.cache.redis;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.shiro.util.ClassUtils;
import org.iherus.shiro.cache.redis.RedisOperations;
import org.iherus.shiro.cache.redis.connection.RedisConnection;
import org.iherus.shiro.cache.redis.connection.RedisConnectionFactory;
import org.iherus.shiro.cache.redis.serializer.DefaultSerializer;
import org.iherus.shiro.cache.redis.serializer.FstSerializer;
import org.iherus.shiro.cache.redis.serializer.ValueSerializer;
import org.iherus.shiro.exception.ExecutionException;

public abstract class AbstractRedisOperations
implements RedisOperations {
    private static final Supplier<ValueSerializer> VS_SUPPLIER = new Supplier<ValueSerializer>(){
        final AtomicReference<ValueSerializer> vsRef = new AtomicReference();

        @Override
        public ValueSerializer get() {
            ValueSerializer serializer = this.vsRef.get();
            if (serializer != null) {
                return serializer;
            }
            serializer = new FstSerializer();
            return this.vsRef.compareAndSet(null, serializer) ? serializer : this.vsRef.get();
        }
    };

    @Override
    public ValueSerializer getValueSerializer() {
        if (ClassUtils.isAvailable((String)"org.nustaq.serialization.FSTConfiguration")) {
            return VS_SUPPLIER.get();
        }
        return DefaultSerializer.INSTANCE;
    }

    static class DefaultRedisOperations
    extends AbstractRedisOperations {
        private final RedisConnectionFactory connectionFactory;

        DefaultRedisOperations(RedisConnectionFactory connectionFactory) {
            this.connectionFactory = connectionFactory;
        }

        @Override
        public RedisConnectionFactory getConnectionFactory() {
            return this.connectionFactory;
        }

        public RedisConnectionFactory getRequiredConnectionFactory() {
            RedisConnectionFactory connectionFactory = this.getConnectionFactory();
            if (connectionFactory == null) {
                throw new IllegalStateException("RedisConnectionFactory is required");
            }
            return connectionFactory;
        }

        @Override
        public <T> T execute(Function<RedisConnection, T> action) throws ExecutionException {
            RedisConnectionFactory factory = this.getRequiredConnectionFactory();
            try (RedisConnection connection = null;){
                connection = factory.getConnection();
                T t = action.apply(connection);
                return t;
            }
        }
    }
}

