/*
 * Decompiled with CFR 0.152.
 */
package org.iherus.shiro.cache.redis.connection.lettuce;

import io.lettuce.core.RedisURI;
import io.lettuce.core.ScriptOutputType;
import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.api.sync.RedisCommands;
import io.lettuce.core.cluster.SlotHash;
import io.lettuce.core.cluster.api.StatefulRedisClusterConnection;
import io.lettuce.core.cluster.api.sync.RedisAdvancedClusterCommands;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.iherus.shiro.cache.redis.connection.BatchOptions;
import org.iherus.shiro.cache.redis.connection.RedisConnection;
import org.iherus.shiro.cache.redis.connection.lettuce.AbstractLettuceConnection;
import org.iherus.shiro.cache.redis.connection.lettuce.ConnectionPool;
import org.iherus.shiro.util.RedisVerUtils;
import org.iherus.shiro.util.Utils;

public class LettuceClusterConnection
extends AbstractLettuceConnection
implements RedisConnection {
    private final ConnectionPool pool;
    private final BatchOptions options;
    private final Duration timeout;
    private volatile StatefulRedisClusterConnection<byte[], byte[]> nativeConnection;
    private static final Function<byte[], Integer> calculator = key -> SlotHash.getSlot((byte[])key);

    public LettuceClusterConnection(ConnectionPool pool) {
        this(pool, BatchOptions.defaulted, RedisURI.DEFAULT_TIMEOUT_DURATION);
    }

    public LettuceClusterConnection(ConnectionPool pool, BatchOptions options, Duration timeout) {
        this.pool = pool;
        this.options = options;
        this.timeout = timeout;
    }

    public BatchOptions getOptions() {
        return this.options;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StatefulRedisClusterConnection<byte[], byte[]> getNativeConnection() {
        if (this.nativeConnection == null) {
            LettuceClusterConnection lettuceClusterConnection = this;
            synchronized (lettuceClusterConnection) {
                if (this.nativeConnection == null) {
                    this.nativeConnection = this.pool.getConnection(StatefulRedisClusterConnection.class);
                }
            }
        }
        return this.nativeConnection;
    }

    protected RedisAdvancedClusterCommands<byte[], byte[]> getCommandExecutor() {
        RedisAdvancedClusterCommands commands = this.getNativeConnection().sync();
        commands.setTimeout(this.timeout);
        return commands;
    }

    @Override
    public byte[] get(byte[] key) {
        return (byte[])this.getCommandExecutor().get((Object)key);
    }

    @Override
    public byte[] set(byte[] key, byte[] value, Duration expired) {
        return (byte[])this.getCommandExecutor().eval("local previous = redis.call('get', KEYS[1]); redis.call('psetex', KEYS[1], ARGV[2], ARGV[1]); return previous", ScriptOutputType.VALUE, (Object[])new byte[][]{key}, (Object[])new byte[][]{value, Utils.longToBytes(expired.toMillis())});
    }

    @Override
    public Long mdel(byte[] ... keys) {
        if (Utils.isEmpty(keys)) {
            return 0L;
        }
        RedisAdvancedClusterCommands<byte[], byte[]> commandExecutor = this.getCommandExecutor();
        boolean unlink = RedisVerUtils.getServerVersion(() -> this.parseServerVersion(commandExecutor.info("Server"))).isSupportUnlink();
        return this.batchDeleteOnCluster(this.options.getDeleteBatchSize(), keys, batchKeys -> unlink ? commandExecutor.unlink((Object[])batchKeys) : commandExecutor.del((Object[])batchKeys), calculator);
    }

    @Override
    public List<byte[]> mget(byte[] ... keys) {
        RedisAdvancedClusterCommands<byte[], byte[]> commandExecutor = this.getCommandExecutor();
        return this.batchGetOnCluster(this.options.getFetchBatchSize(), keys, batchKeys -> {
            List kvs = commandExecutor.mget((Object[])batchKeys);
            return kvs.stream().map(kv -> (byte[])kv.getValue()).collect(Collectors.toList());
        }, calculator);
    }

    @Override
    public byte[] del(byte[] key) {
        return (byte[])this.getCommandExecutor().eval("if redis.call('exists', KEYS[1]) > 0 then local value = redis.call('get', KEYS[1]); redis.call('del', KEYS[1]); return value else local r; return r end", ScriptOutputType.VALUE, (Object[])new byte[][]{key});
    }

    @Override
    public Set<byte[]> keys(byte[] pattern) {
        return this.distributionScanKeys(completion -> {
            Map masters = this.getCommandExecutor().masters().asMap();
            masters.forEach((node, commands) -> completion.submit(() -> this.scanKeys((RedisCommands<byte[], byte[]>)commands, pattern, this.options.getScanBatchSize())));
            return masters.size();
        });
    }

    @Override
    public boolean isClusterConnection() {
        return true;
    }

    @Override
    public void close() {
        if (this.nativeConnection != null) {
            this.pool.release((StatefulConnection<?, ?>)this.nativeConnection);
        }
    }
}

