/*
 * Decompiled with CFR 0.152.
 */
package org.iherus.shiro.cache.redis.connection.redisson;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.iherus.shiro.cache.redis.Constant;
import org.iherus.shiro.cache.redis.connection.AbstractRedisConnection;
import org.iherus.shiro.util.Utils;
import org.redisson.BaseIterator;
import org.redisson.ScanResult;
import org.redisson.api.RFuture;
import org.redisson.client.RedisClient;
import org.redisson.client.codec.ByteArrayCodec;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.decoder.ListScanResult;
import org.redisson.command.CommandExecutor;
import org.redisson.connection.MasterSlaveEntry;

public abstract class AbstractRedissonConnection
extends AbstractRedisConnection {
    protected abstract CommandExecutor getCommandExecutor();

    public Iterator<byte[]> scanKeys(final MasterSlaveEntry entry, final byte[] pattern, final int batchSize) {
        return new BaseIterator<byte[], byte[]>(){

            protected ScanResult<byte[]> iterator(RedisClient client, long nextIterPos) {
                return (ScanResult)AbstractRedissonConnection.this.getCommandExecutor().get(AbstractRedissonConnection.this.scanAsync(client, entry, nextIterPos, pattern, batchSize));
            }

            protected byte[] getValue(byte[] entry2) {
                return entry2;
            }

            protected void remove(byte[] value) {
            }
        };
    }

    private RFuture<ListScanResult<byte[]>> scanAsync(RedisClient client, MasterSlaveEntry entry, long startPos, byte[] pattern, int count) {
        return this.getCommandExecutor().readAsync(client, entry, (Codec)ByteArrayCodec.INSTANCE, RedisCommands.SCAN, new Object[]{startPos, "MATCH", pattern, "COUNT", count});
    }

    public Set<byte[]> scanKeysOnDb(MasterSlaveEntry entry, int db, byte[] pattern, int batchSize) {
        HashSet<byte[]> keys = new HashSet<byte[]>();
        Utils.MutableArray<Object> mutableArray = Utils.newMutableArray(null, pattern, Utils.intToBytes(batchSize), Utils.intToBytes(db));
        byte[] cursor = Utils.intToBytes(0);
        do {
            Object[] params = mutableArray.replace(0, cursor).toArray();
            RFuture f = this.getCommandExecutor().evalReadAsync(entry, (Codec)ByteArrayCodec.INSTANCE, RedisCommands.EVAL_LIST, Constant.Select.SCAN.command(), Collections.emptyList(), params);
            List objectList = (List)this.getCommandExecutor().get(f);
            cursor = (byte[])objectList.get(0);
            keys.addAll((Collection)objectList.get(1));
        } while (Utils.bytesToText(cursor).compareTo("0") > 0);
        return keys;
    }
}

