/*
 * Decompiled with CFR 0.152.
 */
package org.iherus.shiro.cache.redis.connection.redisson;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import org.iherus.shiro.cache.redis.connection.BatchOptions;
import org.iherus.shiro.cache.redis.connection.RedisConnection;
import org.iherus.shiro.cache.redis.connection.redisson.AbstractRedissonConnection;
import org.iherus.shiro.util.RedisVerUtils;
import org.iherus.shiro.util.Utils;
import org.redisson.Redisson;
import org.redisson.api.RFuture;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.ByteArrayCodec;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandExecutor;
import org.redisson.connection.CRC16;
import org.redisson.connection.ConnectionManager;
import org.redisson.connection.MasterSlaveEntry;

public class RedissonClusterConnection
extends AbstractRedissonConnection
implements RedisConnection {
    private final Redisson redisson;
    private final BatchOptions options;
    private static final Function<byte[], Integer> calculator = key -> RedissonClusterConnection.calcSlot(key);

    public RedissonClusterConnection(RedissonClient client) {
        this(client, BatchOptions.defaulted);
    }

    public RedissonClusterConnection(RedissonClient client, BatchOptions options) {
        this.redisson = (Redisson)client;
        this.options = options;
    }

    @Override
    protected CommandExecutor getCommandExecutor() {
        return this.redisson.getCommandExecutor();
    }

    @Override
    public byte[] get(byte[] key) {
        RFuture f = this.getCommandExecutor().readAsync(key, (Codec)ByteArrayCodec.INSTANCE, RedisCommands.GET, new Object[]{key});
        return (byte[])this.getCommandExecutor().get(f);
    }

    @Override
    public byte[] set(byte[] key, byte[] value, Duration expired) {
        MasterSlaveEntry entry = this.getEntryByKey(key);
        RFuture f = this.getCommandExecutor().evalWriteAsync(entry, (Codec)ByteArrayCodec.INSTANCE, RedisCommands.EVAL_OBJECT, "local previous = redis.call('get', KEYS[1]); redis.call('psetex', KEYS[1], ARGV[2], ARGV[1]); return previous", Collections.singletonList(key), new Object[]{value, Utils.longToBytes(expired.toMillis())});
        return (byte[])this.getCommandExecutor().get(f);
    }

    @Override
    public Long mdel(byte[] ... keys) {
        if (Utils.isEmpty(keys)) {
            return 0L;
        }
        CommandExecutor executor = this.getCommandExecutor();
        boolean unlink = RedisVerUtils.getServerVersion(() -> {
            MasterSlaveEntry entry = (MasterSlaveEntry)executor.getConnectionManager().getEntrySet().iterator().next();
            RFuture f = executor.readAsync(entry, (Codec)StringCodec.INSTANCE, (RedisCommand)RedisCommands.INFO_SERVER, new Object[0]);
            return ((Map)executor.get(f)).getOrDefault("redis_version", "");
        }).isSupportUnlink();
        return this.batchDeleteOnCluster(this.options.getDeleteBatchSize(), keys, batchKeys -> {
            RFuture f = executor.writeAsync(batchKeys[0], (Codec)ByteArrayCodec.INSTANCE, (RedisCommand)(unlink ? RedisCommands.UNLINK : RedisCommands.DEL), Arrays.asList(batchKeys).toArray());
            return (Long)executor.get(f);
        }, calculator);
    }

    @Override
    public List<byte[]> mget(byte[] ... keys) {
        CommandExecutor executor = this.getCommandExecutor();
        return this.batchGetOnCluster(this.options.getFetchBatchSize(), keys, batchKeys -> {
            RFuture f = executor.readAsync(batchKeys[0], (Codec)ByteArrayCodec.INSTANCE, RedisCommands.MGET, Arrays.asList(batchKeys).toArray());
            return (List)executor.get(f);
        }, calculator);
    }

    @Override
    public byte[] del(byte[] key) {
        MasterSlaveEntry entry = this.getEntryByKey(key);
        RFuture f = this.getCommandExecutor().evalWriteAsync(entry, (Codec)ByteArrayCodec.INSTANCE, RedisCommands.EVAL_OBJECT, "if redis.call('exists', KEYS[1]) > 0 then local value = redis.call('get', KEYS[1]); redis.call('del', KEYS[1]); return value else local r; return r end", Collections.singletonList(key), new Object[0]);
        return (byte[])this.getCommandExecutor().get(f);
    }

    @Override
    public Set<byte[]> keys(byte[] pattern) {
        return this.distributionScanKeys(completion -> {
            Collection entrySet = this.getCommandExecutor().getConnectionManager().getEntrySet();
            entrySet.forEach(entry -> completion.submit(() -> {
                HashSet<byte[]> keysOfNode = new HashSet<byte[]>();
                Iterator<byte[]> iterator = this.scanKeys((MasterSlaveEntry)entry, pattern, this.options.getScanBatchSize());
                while (iterator.hasNext()) {
                    keysOfNode.add(iterator.next());
                }
                return keysOfNode;
            }));
            return entrySet.size();
        });
    }

    @Override
    protected ExecutorService getConcurrentExecutor() {
        return this.redisson.getConnectionManager().getExecutor();
    }

    @Override
    public boolean isClusterConnection() {
        return true;
    }

    private MasterSlaveEntry getEntryByKey(byte[] key) {
        ConnectionManager cm = this.redisson.getConnectionManager();
        return cm.getEntry(cm.calcSlot(key));
    }

    private static int calcSlot(byte[] key) {
        if (key == null) {
            return 0;
        }
        int start = RedissonClusterConnection.indexOf(key, (byte)123);
        if (start != -1) {
            int end = RedissonClusterConnection.indexOf(key, (byte)125);
            key = Arrays.copyOfRange(key, start + 1, end);
        }
        int result = CRC16.crc16((byte[])key) % 16384;
        return result;
    }

    private static int indexOf(byte[] array, byte element) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != element) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void close() {
    }
}

