/*
 * Decompiled with CFR 0.152.
 */
package org.iherus.shiro.cache.redis.connection.redisson;

import java.net.URL;
import java.time.Duration;
import java.util.Optional;
import java.util.Set;
import org.apache.shiro.util.ClassUtils;
import org.iherus.shiro.cache.redis.config.RedisClusterConfiguration;
import org.iherus.shiro.cache.redis.config.RedisConfiguration;
import org.iherus.shiro.cache.redis.config.RedisSentinelConfiguration;
import org.iherus.shiro.cache.redis.config.RedisStandaloneConfiguration;
import org.iherus.shiro.cache.redis.connection.BatchOptions;
import org.iherus.shiro.cache.redis.connection.Destroyable;
import org.iherus.shiro.cache.redis.connection.Initializable;
import org.iherus.shiro.cache.redis.connection.RedisConnection;
import org.iherus.shiro.cache.redis.connection.RedisConnectionFactory;
import org.iherus.shiro.cache.redis.connection.redisson.RedissonClusterConnection;
import org.iherus.shiro.cache.redis.connection.redisson.RedissonConnection;
import org.iherus.shiro.exception.InvocationException;
import org.iherus.shiro.util.Utils;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.ByteArrayCodec;
import org.redisson.client.codec.Codec;
import org.redisson.config.BaseMasterSlaveServersConfig;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.Config;
import org.redisson.config.SentinelServersConfig;
import org.redisson.config.SingleServerConfig;

public class RedissonConnectionFactory
implements RedisConnectionFactory,
Initializable,
Destroyable {
    private volatile RedissonClient client;
    private Optional<String> clientName = Optional.empty();
    private Optional<Integer> connectionMinIdleSize = Optional.empty();
    private Optional<Integer> connectionPoolSize = Optional.empty();
    private Optional<Duration> soTimeout = Optional.empty();
    private Optional<Duration> connectTimeout = Optional.empty();
    private boolean useSsl;
    private URL sslTruststore;
    private String sslTruststorePassword;
    private URL sslKeystore;
    private String sslKeystorePassword;
    private RedisConfiguration configuration = RedisConfiguration.defaulted;
    private Optional<BatchOptions> batchOptions = Optional.empty();
    private final Object lock = new Object();

    public RedissonConnectionFactory() {
    }

    public RedissonConnectionFactory(RedisStandaloneConfiguration standaloneConfig) {
        Utils.assertNotNull(standaloneConfig, "RedisStandaloneConfiguration must not be null.");
        this.configuration = standaloneConfig;
    }

    public RedissonConnectionFactory(RedisSentinelConfiguration sentinelConfig) {
        Utils.assertNotNull(sentinelConfig, "RedisSentinelConfiguration must not be null.");
        this.configuration = sentinelConfig;
    }

    public RedissonConnectionFactory(RedisClusterConfiguration clusterConfig) {
        Utils.assertNotNull(clusterConfig, "RedisClusterConfiguration must not be null.");
        this.configuration = clusterConfig;
    }

    public Optional<Integer> getConnectionMinIdleSize() {
        return this.connectionMinIdleSize;
    }

    public void setConnectionMinIdleSize(Integer connectionMinIdleSize) {
        this.connectionMinIdleSize = Optional.of(Math.max(0, connectionMinIdleSize));
    }

    public Optional<Integer> getConnectionPoolSize() {
        return this.connectionPoolSize;
    }

    public void setConnectionPoolSize(Integer connectionPoolSize) {
        this.connectionPoolSize = Optional.of(Math.max(8, connectionPoolSize));
    }

    public Optional<String> getClientName() {
        return this.clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = Optional.ofNullable(clientName);
    }

    @Override
    public RedisConfiguration getConfiguration() {
        return this.configuration;
    }

    protected RedisConfiguration getRequiredConfig() {
        RedisConfiguration config = this.getConfiguration();
        if (config == null) {
            throw new IllegalArgumentException("RedisConfiguration must not be null.");
        }
        return config;
    }

    public void setConfiguration(RedisConfiguration configuration) {
        this.configuration = configuration;
    }

    public Optional<Duration> getSoTimeout() {
        return this.soTimeout;
    }

    public void setSoTimeout(Duration soTimeout) {
        this.soTimeout = Optional.ofNullable(soTimeout);
    }

    public void setSoTimeoutMillis(long millis) {
        this.setSoTimeout(Duration.ofMillis(millis));
    }

    public Optional<Duration> getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(Duration connectTimeout) {
        this.connectTimeout = Optional.ofNullable(connectTimeout);
    }

    public void setConnectTimeoutMillis(long millis) {
        this.setConnectTimeout(Duration.ofMillis(millis));
    }

    public URL getSslTruststore() {
        return this.sslTruststore;
    }

    public void setSslTruststore(URL sslTruststore) {
        this.sslTruststore = sslTruststore;
    }

    public String getSslTruststorePassword() {
        return this.sslTruststorePassword;
    }

    public void setSslTruststorePassword(String sslTruststorePassword) {
        this.sslTruststorePassword = sslTruststorePassword;
    }

    public URL getSslKeystore() {
        return this.sslKeystore;
    }

    public void setSslKeystore(URL sslKeystore) {
        this.sslKeystore = sslKeystore;
    }

    public String getSslKeystorePassword() {
        return this.sslKeystorePassword;
    }

    public void setSslKeystorePassword(String sslKeystorePassword) {
        this.sslKeystorePassword = sslKeystorePassword;
    }

    public Optional<BatchOptions> getBatchOptions() {
        return this.batchOptions;
    }

    @Override
    public void setBatchOptions(BatchOptions options) {
        this.batchOptions = Optional.ofNullable(options);
    }

    public boolean isUseSsl() {
        return this.useSsl;
    }

    public void setUseSsl(boolean useSsl) {
        this.useSsl = useSsl;
    }

    @Override
    public void init() throws Exception {
        if (this.client == null) {
            this.client = this.createClient();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RedissonClient getClient() {
        if (this.client == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.client == null) {
                    this.client = this.createClient();
                }
            }
        }
        return this.client;
    }

    @Override
    public void destroy() throws Exception {
        try {
            if (this.client != null) {
                this.client.shutdown();
            }
        }
        finally {
            this.client = null;
        }
    }

    @Override
    public RedisConnection getConnection() {
        if (this.isRedisClusterAware()) {
            return this.getClusterConnection();
        }
        return new RedissonConnection(this.getClient(), this.batchOptions.orElse(BatchOptions.defaulted));
    }

    public RedissonClusterConnection getClusterConnection() {
        if (!this.isRedisClusterAware()) {
            throw new InvocationException("Cluster is not configured.");
        }
        return new RedissonClusterConnection(this.getClient(), this.batchOptions.orElse(BatchOptions.defaulted));
    }

    public boolean isRedisSentinelAware() {
        return RedisConfiguration.isSentinelConfiguration(this.configuration);
    }

    public boolean isRedisClusterAware() {
        return RedisConfiguration.isClusterConfiguration(this.configuration);
    }

    protected RedissonClient createClient() {
        Config config = new Config();
        if (this.isRedisSentinelAware()) {
            RedisSentinelConfiguration settingConfig = (RedisSentinelConfiguration)this.getRequiredConfig();
            SentinelServersConfig sentinelConfig = config.useSentinelServers();
            Set<String> sentinels = settingConfig.getAddresses(this.isUseSsl());
            sentinelConfig.setMasterName(settingConfig.getMasterName());
            sentinelConfig.setDatabase(settingConfig.getDatabase());
            sentinelConfig.addSentinelAddress(sentinels.toArray(new String[sentinels.size()]));
            this.setCommonProperties(sentinelConfig, settingConfig.getPassword());
        } else if (this.isRedisClusterAware()) {
            RedisClusterConfiguration settingConfig = (RedisClusterConfiguration)this.getRequiredConfig();
            ClusterServersConfig clusterConfig = config.useClusterServers();
            Set<String> nodes = settingConfig.getAddresses(this.isUseSsl());
            clusterConfig.addNodeAddress(nodes.toArray(new String[nodes.size()]));
            clusterConfig.setRetryAttempts(settingConfig.getMaxAttempts());
            this.setCommonProperties(clusterConfig, settingConfig.getPassword());
        } else {
            RedisStandaloneConfiguration settingConfig = (RedisStandaloneConfiguration)this.getRequiredConfig();
            SingleServerConfig standaloneConfig = config.useSingleServer();
            standaloneConfig.setAddress(settingConfig.getAddress(this.isUseSsl()));
            standaloneConfig.setDatabase(settingConfig.getDatabase());
            this.setCommonProperties(standaloneConfig, settingConfig.getPassword());
        }
        return Redisson.create((Config)config.setCodec((Codec)ByteArrayCodec.INSTANCE));
    }

    protected void setCommonProperties(Object config, String password) {
        Class clazz = ClassUtils.forName((String)"org.redisson.config.BaseConfig");
        Class<?> configClass = config.getClass();
        if (BaseMasterSlaveServersConfig.class.isAssignableFrom(configClass)) {
            BaseMasterSlaveServersConfig configToUse = (BaseMasterSlaveServersConfig)config;
            this.getConnectionMinIdleSize().ifPresent(arg_0 -> ((BaseMasterSlaveServersConfig)configToUse).setMasterConnectionMinimumIdleSize(arg_0));
            this.getConnectionMinIdleSize().ifPresent(arg_0 -> ((BaseMasterSlaveServersConfig)configToUse).setSlaveConnectionMinimumIdleSize(arg_0));
            this.getConnectionPoolSize().ifPresent(arg_0 -> ((BaseMasterSlaveServersConfig)configToUse).setMasterConnectionPoolSize(arg_0));
            this.getConnectionPoolSize().ifPresent(arg_0 -> ((BaseMasterSlaveServersConfig)configToUse).setSlaveConnectionPoolSize(arg_0));
        } else if (SingleServerConfig.class.isAssignableFrom(configClass)) {
            SingleServerConfig configToUse = (SingleServerConfig)config;
            this.getConnectionMinIdleSize().ifPresent(arg_0 -> ((SingleServerConfig)configToUse).setConnectionMinimumIdleSize(arg_0));
            this.getConnectionPoolSize().ifPresent(arg_0 -> ((SingleServerConfig)configToUse).setConnectionPoolSize(arg_0));
        }
        if (clazz.isAssignableFrom(config.getClass())) {
            this.getClientName().ifPresent(name -> Utils.invokeMethod(config, "setClientName", String.class, name));
            this.getConnectTimeout().ifPresent(timeout -> Utils.invokeMethod(config, "setConnectTimeout", Integer.class, timeout));
            this.getSoTimeout().ifPresent(timeout -> Utils.invokeMethod(config, "setTimeout", Integer.class, timeout));
            Optional.ofNullable(password).ifPresent(pwd -> Utils.invokeMethod(config, "setPassword", String.class, pwd));
            Optional.ofNullable(this.getSslTruststore()).ifPresent(it -> Utils.invokeMethod(config, "setSslTruststore", URL.class, it));
            Optional.ofNullable(this.getSslKeystore()).ifPresent(it -> Utils.invokeMethod(config, "setSslKeystore", URL.class, it));
            if (Utils.isNotEmpty(this.getSslTruststorePassword())) {
                Utils.invokeMethod(config, "setSslTruststorePassword", String.class, (Object)this.getSslTruststorePassword());
            }
            if (Utils.isNotEmpty(this.getSslKeystorePassword())) {
                Utils.invokeMethod(config, "setSslKeystorePassword", String.class, (Object)this.getSslKeystorePassword());
            }
        }
    }
}

