/*
 * Decompiled with CFR 0.152.
 */
package org.iherus.shiro.cache.redis.connection.spring;

import java.time.Duration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import org.iherus.shiro.cache.redis.connection.AbstractRedisConnection;
import org.iherus.shiro.cache.redis.connection.BatchOptions;
import org.iherus.shiro.cache.redis.connection.RedisConnection;
import org.iherus.shiro.cache.redis.serializer.StringSerializer;
import org.iherus.shiro.util.RedisVerUtils;
import org.iherus.shiro.util.Utils;
import org.springframework.data.redis.connection.ClusterSlotHashUtil;
import org.springframework.data.redis.connection.RedisClusterConnection;
import org.springframework.data.redis.connection.RedisClusterNode;
import org.springframework.data.redis.connection.ReturnType;
import org.springframework.data.redis.connection.jedis.JedisClusterConnection;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.ScanOptions;

public class CompatibleRedisConnection
extends AbstractRedisConnection
implements RedisConnection {
    private final org.springframework.data.redis.connection.RedisConnection nativeConnection;
    private final BatchOptions options;
    private static final Function<byte[], Integer> calculator = key -> ClusterSlotHashUtil.calculateSlot((byte[])key);

    public CompatibleRedisConnection(org.springframework.data.redis.connection.RedisConnection connection) {
        this(connection, BatchOptions.defaulted);
    }

    public CompatibleRedisConnection(org.springframework.data.redis.connection.RedisConnection connection, BatchOptions options) {
        this.nativeConnection = connection;
        this.options = options;
    }

    public BatchOptions getOptions() {
        return this.options;
    }

    @Override
    public byte[] get(byte[] key) {
        return this.nativeConnection.get(key);
    }

    @Override
    public byte[] set(byte[] key, byte[] value, Duration expired) {
        byte[] command = StringSerializer.UTF_8.serialize("local previous = redis.call('get', KEYS[1]); redis.call('psetex', KEYS[1], ARGV[2], ARGV[1]); return previous");
        return (byte[])this.nativeConnection.eval(command, ReturnType.VALUE, 1, (byte[][])new byte[][]{key, value, Utils.longToBytes(expired.toMillis())});
    }

    @Override
    public Long mdel(byte[] ... keys) {
        if (Utils.isEmpty(keys)) {
            return 0L;
        }
        boolean unlink = RedisVerUtils.getServerVersion(() -> CompatibleRedisConnection.getServerVersion(this.isClusterConnection(), this.getNativeConnection().info("Server"))).isSupportUnlink();
        Function<byte[][], Long> executor = batchKeys -> {
            if (this.isJedisClusterConnection()) {
                Object primitive = this.getNativeConnection().getNativeConnection();
                return (Long)Optional.ofNullable(Utils.invokeMethod(primitive, unlink ? "unlink" : "del", new Class[]{byte[][].class}, batchKeys)).orElse(0L);
            }
            return unlink ? this.getNativeConnection().unlink(batchKeys) : this.getNativeConnection().del(batchKeys);
        };
        if (this.isClusterConnection()) {
            return this.batchDeleteOnCluster(this.options.getDeleteBatchSize(), keys, executor, calculator);
        }
        return this.batchDeleteOnStandalone(this.options.getDeleteBatchSize(), keys, executor);
    }

    @Override
    public List<byte[]> mget(byte[] ... keys) {
        if (this.isClusterConnection()) {
            return this.mgetOnCluster(keys);
        }
        return this.batchGetOnStandalone(this.options.getFetchBatchSize(), keys, batchKeys -> this.getNativeConnection().mGet(batchKeys));
    }

    protected List<byte[]> mgetOnCluster(byte[] ... keys) {
        boolean isJedis = this.isJedisClusterConnection();
        return this.batchGetOnCluster(this.options.getFetchBatchSize(), keys, batchKeys -> {
            if (isJedis) {
                Object primitive = this.getNativeConnection().getNativeConnection();
                return (List)Utils.invokeMethod(primitive, "mget", new Class[]{byte[][].class}, batchKeys);
            }
            return this.getNativeConnection().mGet(batchKeys);
        }, calculator);
    }

    @Override
    public byte[] del(byte[] key) {
        byte[] command = StringSerializer.UTF_8.serialize("if redis.call('exists', KEYS[1]) > 0 then local value = redis.call('get', KEYS[1]); redis.call('del', KEYS[1]); return value else local r; return r end");
        return (byte[])this.nativeConnection.eval(command, ReturnType.VALUE, 1, (byte[][])new byte[][]{key});
    }

    @Override
    public Set<byte[]> keys(byte[] pattern) {
        if (this.isClusterConnection()) {
            return this.getClusterKeys(pattern);
        }
        return this.getKeys(pattern);
    }

    @Override
    public boolean isClusterConnection() {
        return this.getNativeConnection() instanceof RedisClusterConnection;
    }

    protected boolean isJedisClusterConnection() {
        return this.getNativeConnection() instanceof JedisClusterConnection;
    }

    @Override
    public void close() {
        this.getNativeConnection().close();
    }

    public org.springframework.data.redis.connection.RedisConnection getNativeConnection() {
        return this.nativeConnection;
    }

    protected Set<byte[]> getKeys(byte[] pattern) {
        HashSet<byte[]> keys = new HashSet<byte[]>();
        ScanOptions options = ScanOptions.scanOptions().match(StringSerializer.UTF_8.deserialize(pattern)).count((long)this.options.getScanBatchSize()).build();
        Cursor cursor = this.getNativeConnection().scan(options);
        while (cursor.hasNext()) {
            keys.add((byte[])cursor.next());
        }
        return keys;
    }

    protected Set<byte[]> getClusterKeys(byte[] pattern) {
        return this.distributionScanKeys(completion -> {
            Map masterSlaveMap = ((RedisClusterConnection)this.getNativeConnection()).clusterGetMasterSlaveMap();
            Set masters = masterSlaveMap.keySet();
            String patternAsText = StringSerializer.UTF_8.deserialize(pattern);
            masters.forEach(node -> completion.submit(() -> this.getKeysFromNode((RedisClusterNode)node, patternAsText)));
            return masters.size();
        });
    }

    private Set<byte[]> getKeysFromNode(RedisClusterNode node, String pattern) {
        HashSet<byte[]> keys = new HashSet<byte[]>();
        ScanOptions options = ScanOptions.scanOptions().match(pattern).count((long)this.options.getScanBatchSize()).build();
        Cursor cursor = ((RedisClusterConnection)this.getNativeConnection()).scan(node, options);
        while (cursor.hasNext()) {
            keys.add((byte[])cursor.next());
        }
        return keys;
    }

    private static String getServerVersion(boolean cluster, Properties properties) {
        if (!cluster) {
            return properties.get("redis_version").toString();
        }
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            if (!entry.getKey().toString().contains("redis_version")) continue;
            return entry.getValue().toString();
        }
        return "";
    }
}

