/*
 * Decompiled with CFR 0.152.
 */
package org.iherus.shiro.cache.redis.serializer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.shiro.io.ClassResolvingObjectInputStream;
import org.apache.shiro.io.SerializationException;
import org.iherus.shiro.cache.redis.serializer.ValueSerializer;
import org.iherus.shiro.util.Utils;

public class DefaultSerializer
extends ValueSerializer {
    public static final DefaultSerializer INSTANCE = new DefaultSerializer();

    public byte[] serialize(Object object) throws SerializationException {
        if (object == null) {
            return EMPTY_ARRAY;
        }
        if (!(object instanceof Serializable)) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + " requires a Serializable payload but received an object of type [" + object.getClass().getName() + "]");
        }
        ByteArrayOutputStream bytesOutputStream = new ByteArrayOutputStream(1024);
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(bytesOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
            return bytesOutputStream.toByteArray();
        }
        catch (Exception e) {
            throw new SerializationException("Failed to serialize object of type: " + object.getClass().getName(), (Throwable)e);
        }
    }

    public Object deserialize(byte[] serialized) throws SerializationException {
        if (Utils.isEmpty(serialized)) {
            return null;
        }
        ByteArrayInputStream bytesInputStream = new ByteArrayInputStream(serialized);
        ClassResolvingObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ClassResolvingObjectInputStream((InputStream)bytesInputStream);
            Object object = objectInputStream.readObject();
            return object;
        }
        catch (Exception e) {
            throw new SerializationException("Failed to deserialize payload. Is the byte array a result of corresponding serialization for " + this.getClass().getSimpleName() + "?", (Throwable)e);
        }
        finally {
            if (objectInputStream != null) {
                try {
                    objectInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

