/*
 * Decompiled with CFR 0.152.
 */
package org.iherus.shiro.cache.redis.serializer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.shiro.io.SerializationException;
import org.iherus.shiro.cache.redis.serializer.ValueSerializer;
import org.iherus.shiro.util.Utils;
import org.nustaq.serialization.FSTConfiguration;
import org.nustaq.serialization.FSTObjectInput;
import org.nustaq.serialization.FSTObjectOutput;

public class FstSerializer
extends ValueSerializer {
    private static Supplier<FSTConfiguration> confSupplier = new Supplier<FSTConfiguration>(){
        final AtomicReference<FSTConfiguration> confRef = new AtomicReference();

        @Override
        public FSTConfiguration get() {
            FSTConfiguration conf = this.confRef.get();
            if (conf != null) {
                return conf;
            }
            conf = FSTConfiguration.createDefaultConfiguration();
            return this.confRef.compareAndSet(null, conf) ? conf : this.confRef.get();
        }
    };

    public byte[] serialize(Object object) throws SerializationException {
        if (object == null) {
            return EMPTY_ARRAY;
        }
        if (!(object instanceof Serializable)) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + " requires a Serializable payload but received an object of type [" + object.getClass().getName() + "]");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
        FSTObjectOutput objectOutput = confSupplier.get().getObjectOutput((OutputStream)out);
        try {
            objectOutput.writeObject(object);
            byte[] byArray = objectOutput.getCopyOfWrittenBuffer();
            return byArray;
        }
        catch (Exception e) {
            throw new SerializationException("Failed to serialize object of type: " + object.getClass().getName(), (Throwable)e);
        }
        finally {
            try {
                objectOutput.flush();
                out.close();
            }
            catch (Exception exception) {}
        }
    }

    public Object deserialize(byte[] serialized) throws SerializationException {
        if (Utils.isEmpty(serialized)) {
            return null;
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(serialized);
        FSTObjectInput objectInput = confSupplier.get().getObjectInput((InputStream)inputStream);
        try {
            Object object = objectInput.readObject();
            return object;
        }
        catch (Exception e) {
            throw new SerializationException("Failed to deserialize payload. Is the byte array a result of corresponding serialization for " + this.getClass().getSimpleName() + "?", (Throwable)e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }
}

