/*
 * Decompiled with CFR 0.152.
 */
package org.iherus.shiro.cache.redis;

import java.time.Duration;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.shiro.ShiroException;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.cache.CacheException;
import org.apache.shiro.cache.CacheManager;
import org.iherus.shiro.cache.redis.AbstractRedisOperations;
import org.iherus.shiro.cache.redis.Constant;
import org.iherus.shiro.cache.redis.RedisCache;
import org.iherus.shiro.cache.redis.connection.BatchOptions;
import org.iherus.shiro.cache.redis.connection.Destroyable;
import org.iherus.shiro.cache.redis.connection.Initializable;
import org.iherus.shiro.cache.redis.connection.RedisConnectionFactory;
import org.iherus.shiro.cache.redis.connection.spring.CompatibleRedisConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisCacheManager
implements CacheManager,
org.apache.shiro.util.Initializable,
org.apache.shiro.util.Destroyable {
    private static final Logger logger = LoggerFactory.getLogger(RedisCacheManager.class);
    private static final ConcurrentHashMap<String, Cache> LOCAL_CACHE = new ConcurrentHashMap();
    private final BatchOptions.Builder optionsBuilder = BatchOptions.builder();
    private String keyPrefix = "shiro:cache:";
    private Duration expiration = Constant.DEFAULT_CACHE_EXPIRATION;
    private Integer database;
    private RedisConnectionFactory connectionFactory;

    public String getKeyPrefix() {
        return this.keyPrefix;
    }

    public void setKeyPrefix(String keyPrefix) {
        this.keyPrefix = keyPrefix;
    }

    public Duration getExpiration() {
        return this.expiration;
    }

    public void setExpiration(Duration expiration) {
        this.expiration = expiration;
    }

    public void setExpirationMillis(long expiration) {
        this.expiration = Duration.ofMillis(expiration);
    }

    public RedisConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    protected RedisConnectionFactory getRequiredConnectionFactory() {
        RedisConnectionFactory factory = this.getConnectionFactory();
        if (factory == null) {
            throw new CacheException("RedisConnectionFactory must not be null.");
        }
        return factory;
    }

    public void setConnectionFactory(RedisConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public Integer getDatabase() {
        return this.database;
    }

    public void setDatabase(Integer database) {
        if (this.getRequiredConnectionFactory() instanceof CompatibleRedisConnectionFactory) {
            throw new UnsupportedOperationException("CompatibleRedisConnectionFactory instance does not support this method.");
        }
        this.database = database;
    }

    public BatchOptions.Builder setScanBatchSize(int size) {
        return this.optionsBuilder.scanSize(size);
    }

    public BatchOptions.Builder setDeleteBatchSize(int size) {
        return this.optionsBuilder.deleteSize(size);
    }

    public BatchOptions.Builder setFetchBatchSize(int size) {
        return this.optionsBuilder.fetchSize(size);
    }

    public void init() throws ShiroException {
        if (logger.isInfoEnabled()) {
            logger.info("Shiro CacheManager initializing...");
        }
        RedisConnectionFactory factory = this.getRequiredConnectionFactory();
        BatchOptions options = this.optionsBuilder.build();
        if (!BatchOptions.defaulted.equals(options)) {
            factory.setBatchOptions(options);
        }
        try {
            if (this.connectionFactory instanceof Initializable) {
                ((Initializable)((Object)this.connectionFactory)).init();
            }
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public <K, V> Cache<K, V> getCache(String name) throws CacheException {
        RedisCache cache = LOCAL_CACHE.get(name);
        if (cache == null) {
            AbstractRedisOperations.DefaultRedisOperations operations = new AbstractRedisOperations.DefaultRedisOperations(this.getRequiredConnectionFactory());
            cache = new RedisCache(name, operations, this.keyPrefix, this.expiration, this.database);
            LOCAL_CACHE.put(name, cache);
        }
        return cache;
    }

    public void destroy() throws Exception {
        if (logger.isInfoEnabled()) {
            logger.info("Shiro CacheManager destroying...");
        }
        try {
            if (this.connectionFactory instanceof Destroyable) {
                ((Destroyable)((Object)this.connectionFactory)).destroy();
            }
        }
        catch (Exception e) {
            if (logger.isWarnEnabled()) {
                logger.warn("Unable to destroy connectionFactory instance gracefully and ignore it. (shutting down) ");
            }
            throw new CacheException((Throwable)e);
        }
    }
}

