/*
 * Decompiled with CFR 0.152.
 */
package org.iherus.shiro.cache.redis.config;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.iherus.shiro.cache.redis.config.HostPortPair;
import org.iherus.shiro.cache.redis.config.RedisConfiguration;
import org.iherus.shiro.util.Utils;

public class RedisClusterConfiguration
implements RedisConfiguration,
RedisConfiguration.ClusterConfiguration {
    private static final int DEFAULT_MAX_ATTEMPS = 5;
    private Set<HostPortPair> clusterNodes = new LinkedHashSet<HostPortPair>();
    private int maxAttempts = 5;
    private String password;

    @Override
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public Set<HostPortPair> getClusterNodes() {
        return Collections.unmodifiableSet(this.clusterNodes);
    }

    public void setClusterNodes(Set<HostPortPair> clusterNodes) {
        this.clusterNodes = clusterNodes;
    }

    public void setClusterNodesFromText(String clusterNodes) {
        String nodesToUse = Utils.isNotBlank(clusterNodes) ? clusterNodes.replace(" ", "") : clusterNodes;
        this.addClusterNodes(Utils.commaDelimitedListToSet(nodesToUse));
    }

    @Override
    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    public void setMaxAttempts(int maxAttempts) {
        this.maxAttempts = Math.max(maxAttempts, 0);
    }

    public void addClusterNode(HostPortPair node) {
        Utils.assertNotNull(node, "Cluster node must not be 'null'.");
        this.clusterNodes.add(node);
    }

    private void addClusterNodes(Set<String> hostAndPorts) {
        for (String hostAndPort : hostAndPorts) {
            this.addClusterNode(this.readHostAndPortFromString(hostAndPort));
        }
    }

    private HostPortPair readHostAndPortFromString(String hostAndPort) {
        String[] args = Utils.split(hostAndPort, ":");
        Utils.assertNotNull(args, "HostAndPort need to be seperated by ':'.");
        Utils.assertIsTrue(args.length == 2, () -> "Host and Port String needs to specified as host:port");
        return new HostPortPair(args[0], Integer.valueOf(args[1]));
    }

    @Override
    public Set<String> getAddresses(boolean ssl) {
        return HostPortPair.convertToStringPairs(this.getClusterNodes(), true, ssl);
    }
}

