/*
 * Decompiled with CFR 0.152.
 */
package org.iherus.shiro.util;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;

public final class Md5Utils {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final String ALGORITHM_NAME = "MD5";
    private static final int DEFAULT_ITERATIONS = 1;
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private Md5Utils() {
        throw new InstantiationError("Utility class must not be instantiated.");
    }

    public static String getMd5(Object source) {
        return Md5Utils.getMd5ToHex(source, null, 1);
    }

    public static String getMd5(Object source, Object salt) {
        return Md5Utils.getMd5ToHex(source, salt, 1);
    }

    public static String getMd5(Object source, Object salt, int hashIterations) {
        return Md5Utils.getMd5ToHex(source, salt, hashIterations);
    }

    public static String getMd5ToHex(Object source) {
        return Md5Utils.getMd5ToHex(source, null, 1);
    }

    public static String getMd5ToHex(Object source, Object salt) {
        return Md5Utils.getMd5ToHex(source, salt, 1);
    }

    public static String getMd5ToBase64(Object source) {
        return Md5Utils.getMd5ToBase64(source, null, 1);
    }

    public static String getMd5ToBase64(Object source, Object salt) {
        return Md5Utils.getMd5ToBase64(source, salt, 1);
    }

    public static String getMd5ToHex(Object source, Object salt, int hashIterations) {
        return Md5Utils.toHexString(Md5Utils.md5HashByObject(source, salt, hashIterations));
    }

    public static String getMd5ToBase64(Object source, Object salt, int hashIterations) {
        return Md5Utils.toBase64String(Md5Utils.md5HashByObject(source, salt, hashIterations));
    }

    public static final String toBase64String(byte[] source) {
        return new String(Base64.getEncoder().encode(source), UTF_8);
    }

    public static final String toHexString(byte[] source) {
        int len = source.length;
        char[] out = new char[len << 1];
        int j = 0;
        for (int i = 0; i < len; ++i) {
            out[j++] = DIGITS[(0xF0 & source[i]) >>> 4];
            out[j++] = DIGITS[0xF & source[i]];
        }
        return new String(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] toBytes(InputStream in) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException("InputStream must not be null.");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
        byte[] buffer = new byte[1024];
        try {
            int bytesRead;
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        finally {
            Md5Utils.closeQuietly(in);
        }
    }

    private static byte[] md5HashByObject(Object source, Object salt, int hashIterations) {
        if (source == null) {
            throw new IllegalArgumentException("Argument[source] cannot be null.");
        }
        int iterations = Math.max(1, hashIterations);
        byte[] sourceBytes = Md5Utils.toBytes(source);
        byte[] saltBytes = salt == null ? null : Md5Utils.toBytes(salt);
        return Md5Utils.md5Hash(sourceBytes, saltBytes, iterations);
    }

    private static byte[] md5Hash(byte[] source, byte[] salt, int hashIterations) {
        MessageDigest digest = Md5Utils.getMd5Digest();
        if (salt != null && salt.length > 0) {
            digest.reset();
            digest.update(salt);
        }
        byte[] hashed = digest.digest(source);
        for (int i = 1; i < hashIterations; ++i) {
            digest.reset();
            hashed = digest.digest(hashed);
        }
        return hashed;
    }

    private static MessageDigest getMd5Digest() {
        try {
            return MessageDigest.getInstance(ALGORITHM_NAME);
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnknownAlgorithmException("No native 'MD5' MessageDigest instance available on the current JVM.");
        }
    }

    private static byte[] toBytes(Object source) {
        if (source == null) {
            throw new IllegalArgumentException("Argument for byte conversion cannot be null.");
        }
        if (!Md5Utils.isByteSource(source)) {
            throw new CodecException("Only the following types of objects are supported: byte[], char[], String, File or InputStream.");
        }
        try {
            if (source instanceof char[]) {
                return new String((char[])source).getBytes(UTF_8);
            }
            if (source instanceof String) {
                return ((String)source).getBytes(UTF_8);
            }
            if (source instanceof File) {
                return Md5Utils.toBytes(new FileInputStream((File)source));
            }
            if (source instanceof InputStream) {
                return Md5Utils.toBytes((InputStream)source);
            }
            return (byte[])source;
        }
        catch (Exception e) {
            throw new CodecException("Unable to convert source [" + source + "] to byte array", e);
        }
    }

    private static boolean isByteSource(Object source) {
        return source instanceof byte[] || source instanceof char[] || source instanceof String || source instanceof File || source instanceof InputStream;
    }

    private static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static class UnknownAlgorithmException
    extends RuntimeException {
        private static final long serialVersionUID = -9057567450240331588L;

        public UnknownAlgorithmException(String message) {
            super(message);
        }

        public UnknownAlgorithmException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class CodecException
    extends RuntimeException {
        private static final long serialVersionUID = 1411948854906245432L;

        public CodecException(String message) {
            super(message);
        }

        public CodecException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

