/**
 * Copyright (c) 2016-2019, Bosco.Liao (bosco_liao@126.com).
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.iherus.shiro.cache.redis.connection.lettuce;

import java.util.HashSet;
import java.util.Set;

import org.iherus.shiro.cache.redis.connection.AbstractRedisConnection;
import org.iherus.shiro.cache.redis.serializer.StringSerializer;

import io.lettuce.core.KeyScanCursor;
import io.lettuce.core.ScanArgs;
import io.lettuce.core.ScanCursor;
import io.lettuce.core.api.sync.RedisCommands;

/**
 * AbstractLettuceConnection
 * 
 * @author Bosco.Liao
 * @since 2.0.0
 */
public abstract class AbstractLettuceConnection extends AbstractRedisConnection {

	public Set<byte[]> scanKeys(RedisCommands<byte[], byte[]> connection, final byte[] pattern, final int batchSize) {
		Set<byte[]> keys = new HashSet<byte[]>();
		ScanArgs args = ScanArgs.Builder.matches(StringSerializer.UTF_8.deserialize(pattern)).limit(batchSize);
		ScanCursor cursor = ScanCursor.INITIAL;

		do {
			KeyScanCursor<byte[]> cursorOfPerBatch = connection.scan(cursor, args);
			keys.addAll(cursorOfPerBatch.getKeys()); // Filter duplicate keys.
			cursor = new ScanCursor(cursorOfPerBatch.getCursor(), cursorOfPerBatch.isFinished());

		} while (!cursor.isFinished());

		return keys;
	}

}