/*
 * Decompiled with CFR 0.152.
 */
package org.iherus.shiro.cache.redis;

import java.io.Serializable;
import java.time.Duration;
import java.util.Date;
import java.util.HashMap;
import org.apache.shiro.ShiroException;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.cache.CacheException;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.UnknownSessionException;
import org.apache.shiro.session.mgt.SimpleSession;
import org.apache.shiro.session.mgt.ValidatingSession;
import org.apache.shiro.session.mgt.eis.CachingSessionDAO;
import org.apache.shiro.util.Initializable;
import org.iherus.shiro.cache.redis.ExpiredCache;
import org.iherus.shiro.cache.redis.MemorySessionCache;
import org.iherus.shiro.cache.redis.serializer.DefaultSerializer;
import org.iherus.shiro.util.Md5Utils;
import org.iherus.shiro.util.Utils;

public class RedisSessionDAO
extends CachingSessionDAO
implements Initializable {
    private static final String CLASS_NAME = RedisSessionDAO.class.getName();
    private static final String MD5_OF_SESSION_ATTR = CLASS_NAME + "_MD5";
    private static final String REFERENCE_TIME_ATTR = CLASS_NAME + "_referenceTime";
    private static final ThreadLocal<Boolean> NEXTS = new ThreadLocal();
    private final MemorySessionCache localCache = new MemorySessionCache();
    private long updateAboveDelayTimeMillis = -1L;

    @Deprecated
    public RedisSessionDAO setLocalSessionCacheMaxCapacity(long capacity) {
        return this.setMemoryCacheMaxCapacity(capacity);
    }

    public RedisSessionDAO setMemoryCacheMaxCapacity(long capacity) {
        this.localCache.setCapacityThreshold(capacity);
        return this;
    }

    public RedisSessionDAO setMemorySessionTtl(int ttl) {
        this.localCache.setTtl(ttl);
        return this;
    }

    @Deprecated
    public int getDelayTimeMillis() {
        return (int)this.getUpdateAboveDelayTimeMillis();
    }

    @Deprecated
    public void setDelayTimeMillis(int delayTimeMillis) {
        this.setUpdateAboveDelayTimeMillis(delayTimeMillis);
    }

    public long getUpdateAboveDelayTimeMillis() {
        return this.updateAboveDelayTimeMillis;
    }

    public void setUpdateAboveDelayTimeMillis(long updateAboveDelayTimeMillis) {
        this.updateAboveDelayTimeMillis = updateAboveDelayTimeMillis;
    }

    private boolean isDelaySyncEnabled() {
        return this.updateAboveDelayTimeMillis > 0L;
    }

    public static boolean isExpiredCacheAware(Cache cache) {
        return cache instanceof ExpiredCache;
    }

    public static boolean isSimpleSession(Session session) {
        return session instanceof SimpleSession;
    }

    public void init() throws ShiroException {
        try {
            this.localCache.init();
        }
        catch (Exception e) {
            throw new CacheException("MemorySessionCache cannot be initialized normally", (Throwable)e);
        }
    }

    protected void cache(Session session, Serializable sessionId, Cache<Serializable, Session> cache) {
        if (RedisSessionDAO.isExpiredCacheAware(cache)) {
            ((ExpiredCache)cache).put(sessionId, session, Duration.ofMillis(session.getTimeout()));
            this.afterCache(sessionId, session);
            return;
        }
        super.cache(session, sessionId, cache);
        this.afterCache(sessionId, session);
    }

    protected void afterCache(Serializable sessionId, Session session) {
        try {
            this.localCache.put(sessionId, session);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void uncache(Session session) {
        if (session == null) {
            return;
        }
        Serializable id = session.getId();
        if (id == null) {
            return;
        }
        Cache<Serializable, Session> cache = this.getActiveSessionsCacheLazy();
        if (cache != null && !RedisSessionDAO.isExpiredCacheAware(cache)) {
            cache.remove((Object)id);
        }
    }

    protected Cache<Serializable, Session> getActiveSessionsCacheLazy() {
        return (Cache)Utils.invokeMethod((Object)this, "getActiveSessionsCacheLazy");
    }

    protected Serializable doCreate(Session session) {
        Serializable sessionId = this.generateSessionId(session);
        this.assignSessionId(session, sessionId);
        this.initializeReferences(session);
        return sessionId;
    }

    protected void initializeReferences(Session session) {
        if (this.isDelaySyncEnabled() && RedisSessionDAO.isSimpleSession(session)) {
            session.setAttribute((Object)MD5_OF_SESSION_ATTR, (Object)"");
            session.setAttribute((Object)REFERENCE_TIME_ATTR, (Object)session.getLastAccessTime());
        }
    }

    public void update(Session session) throws UnknownSessionException {
        try {
            this.doUpdate(session);
            if (!NEXTS.get().booleanValue()) {
                return;
            }
            if (session instanceof ValidatingSession) {
                if (((ValidatingSession)session).isValid()) {
                    this.cache(session, session.getId());
                } else {
                    this.uncache(session);
                }
            } else {
                this.cache(session, session.getId());
            }
        }
        finally {
            NEXTS.remove();
        }
    }

    protected void doUpdate(Session session) {
        if (this.isDelaySyncEnabled() && RedisSessionDAO.isSimpleSession(session)) {
            String md5 = this.getMd5((SimpleSession)session);
            Date lastAccessTime = session.getLastAccessTime();
            Date datumTime = (Date)session.getAttribute((Object)REFERENCE_TIME_ATTR);
            if (md5.equals(session.getAttribute((Object)MD5_OF_SESSION_ATTR)) && lastAccessTime.getTime() - datumTime.getTime() < (long)this.getDelayTimeMillis()) {
                NEXTS.set(false);
                return;
            }
            session.setAttribute((Object)MD5_OF_SESSION_ATTR, (Object)md5);
            session.setAttribute((Object)REFERENCE_TIME_ATTR, (Object)lastAccessTime);
        }
        NEXTS.set(true);
    }

    protected String getMd5(SimpleSession session) {
        SimpleSession sessionCopy = new SimpleSession();
        sessionCopy.setId(session.getId());
        sessionCopy.setStartTimestamp(session.getStartTimestamp());
        sessionCopy.setStopTimestamp(session.getStopTimestamp());
        sessionCopy.setTimeout(session.getTimeout());
        sessionCopy.setExpired(session.isExpired());
        sessionCopy.setHost(session.getHost());
        sessionCopy.setAttributes(new HashMap(session.getAttributes()));
        sessionCopy.setLastAccessTime(null);
        sessionCopy.removeAttribute((Object)MD5_OF_SESSION_ATTR);
        sessionCopy.removeAttribute((Object)REFERENCE_TIME_ATTR);
        byte[] bytes = DefaultSerializer.INSTANCE.serialize(sessionCopy);
        return Md5Utils.getMd5(bytes);
    }

    public void delete(Session session) {
        super.uncache(session);
        this.doDelete(session);
    }

    protected void doDelete(Session session) {
        this.localCache.remove(session.getId());
    }

    protected Session getCachedSession(Serializable sessionId) {
        Session session = this.localCache.get(sessionId);
        if (session == null && (session = super.getCachedSession(sessionId)) != null) {
            this.localCache.put(sessionId, session);
        }
        return session;
    }

    protected Session doReadSession(Serializable sessionId) {
        return null;
    }
}

