/*
 * Decompiled with CFR 0.152.
 */
package org.iherus.shiro.cache.redis.config;

import java.util.Collections;
import java.util.Set;
import org.iherus.shiro.cache.redis.config.HostPortPair;
import org.iherus.shiro.cache.redis.config.RedisConfiguration;
import org.iherus.shiro.util.Utils;

public class RedisStandaloneConfiguration
implements RedisConfiguration,
RedisConfiguration.StandaloneConfiguration {
    private static final String DEFAULT_HOST = "127.0.0.1";
    private static final int DEFAULT_PORT = 6379;
    private String host = "127.0.0.1";
    private int port = 6379;
    private int database;
    private String password;

    public RedisStandaloneConfiguration() {
    }

    public RedisStandaloneConfiguration(String host) {
        this(host, 6379);
    }

    public RedisStandaloneConfiguration(String host, int port) {
        Utils.assertNotBlank(host, "Host name must not be null or empty!");
        Utils.assertIsTrue(port >= 1 && port <= 65535, () -> String.format("Port %d must be a valid TCP port in the range between 1-65535!", port));
        this.host = host;
        this.port = port;
    }

    @Override
    public int getDatabase() {
        return this.database;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setDatabase(int database) {
        Utils.assertIsTrue(database >= 0, () -> String.format("Invalid DB index '%s' (a positive index required)", database));
        this.database = database;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getAddress(boolean ssl) {
        return new HostPortPair(this.host, this.port).toStringWithProtocol(ssl);
    }

    @Override
    public Set<String> getAddresses(boolean ssl) {
        return Collections.singleton(this.getAddress(ssl));
    }
}

