/*
 * Decompiled with CFR 0.152.
 */
package org.iherus.shiro.cache.redis.connection;

public class BatchOptions {
    public static final BatchOptions defaulted = new BatchOptions(3000, 5000, 50);
    private final int scanBatchSize;
    private final int deleteBatchSize;
    private final int fetchBatchSize;

    BatchOptions(Builder builder) {
        this(builder.scanBatchSize, builder.deleteBatchSize, builder.fetchBatchSize);
    }

    private BatchOptions(int scanBatchSize, int deleteBatchSize, int fetchBatchSize) {
        this.scanBatchSize = scanBatchSize;
        this.deleteBatchSize = deleteBatchSize;
        this.fetchBatchSize = fetchBatchSize;
    }

    public int getScanBatchSize() {
        return this.scanBatchSize;
    }

    public int getDeleteBatchSize() {
        return this.deleteBatchSize;
    }

    public int getFetchBatchSize() {
        return this.fetchBatchSize;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BatchOptions other = (BatchOptions)obj;
        if (this.deleteBatchSize != other.deleteBatchSize) {
            return false;
        }
        if (this.fetchBatchSize != other.fetchBatchSize) {
            return false;
        }
        return this.scanBatchSize == other.scanBatchSize;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int scanBatchSize = 3000;
        private int deleteBatchSize = 5000;
        private int fetchBatchSize = 50;

        private Builder() {
        }

        public Builder scanSize(int size) {
            this.scanBatchSize = Math.max(1, size);
            return this;
        }

        public Builder deleteSize(int size) {
            this.deleteBatchSize = Math.max(1, size);
            return this;
        }

        public Builder fetchSize(int size) {
            this.fetchBatchSize = Math.max(1, size);
            return this;
        }

        public BatchOptions build() {
            return new BatchOptions(this);
        }
    }
}

