/*
 * Decompiled with CFR 0.152.
 */
package org.iherus.shiro.cache.redis.connection.lettuce;

import io.lettuce.core.AbstractRedisClient;
import io.lettuce.core.ClientOptions;
import io.lettuce.core.ReadFrom;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.cluster.ClusterClientOptions;
import io.lettuce.core.cluster.RedisClusterClient;
import io.lettuce.core.codec.ByteArrayCodec;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.resource.ClientResources;
import java.time.Duration;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.iherus.shiro.cache.redis.config.DefaultPoolConfig;
import org.iherus.shiro.cache.redis.config.HostPortPair;
import org.iherus.shiro.cache.redis.config.RedisClusterConfiguration;
import org.iherus.shiro.cache.redis.config.RedisConfiguration;
import org.iherus.shiro.cache.redis.config.RedisSentinelConfiguration;
import org.iherus.shiro.cache.redis.config.RedisStandaloneConfiguration;
import org.iherus.shiro.cache.redis.connection.BatchOptions;
import org.iherus.shiro.cache.redis.connection.Destroyable;
import org.iherus.shiro.cache.redis.connection.Initializable;
import org.iherus.shiro.cache.redis.connection.RedisConnection;
import org.iherus.shiro.cache.redis.connection.RedisConnectionFactory;
import org.iherus.shiro.cache.redis.connection.lettuce.ConnectionPool;
import org.iherus.shiro.cache.redis.connection.lettuce.ConnectionProvider;
import org.iherus.shiro.cache.redis.connection.lettuce.LettuceClusterConnection;
import org.iherus.shiro.cache.redis.connection.lettuce.LettuceClusterConnectionProvider;
import org.iherus.shiro.cache.redis.connection.lettuce.LettuceConnection;
import org.iherus.shiro.cache.redis.connection.lettuce.LettuceStandaloneConnectionProvider;
import org.iherus.shiro.exception.InvocationException;
import org.iherus.shiro.util.Utils;

public class LettuceConnectionFactory
implements RedisConnectionFactory,
Initializable,
Destroyable {
    private boolean useSsl;
    private boolean verifyPeer = true;
    private boolean startTls;
    private Optional<ClientResources> clientResources = Optional.empty();
    private Optional<ClientOptions> clientOptions = Optional.empty();
    private Optional<ReadFrom> readFrom = Optional.empty();
    private Optional<Duration> timeout = Optional.empty();
    private Optional<String> clientName = Optional.empty();
    private RedisConfiguration configuration = RedisConfiguration.defaulted;
    private GenericObjectPoolConfig poolConfig;
    private volatile ConnectionPool pool;
    private volatile AbstractRedisClient client;
    private Optional<BatchOptions> batchOptions = Optional.empty();
    private final Object lock = new Object();

    public LettuceConnectionFactory() {
        this(new DefaultPoolConfig());
    }

    public LettuceConnectionFactory(GenericObjectPoolConfig<?> poolConfig) {
        this.poolConfig = poolConfig == null ? new DefaultPoolConfig() : poolConfig;
    }

    public LettuceConnectionFactory(RedisStandaloneConfiguration standaloneConfig) {
        this(standaloneConfig, new DefaultPoolConfig());
    }

    public LettuceConnectionFactory(RedisSentinelConfiguration sentinelConfig) {
        this(sentinelConfig, (GenericObjectPoolConfig)new DefaultPoolConfig());
    }

    public LettuceConnectionFactory(RedisClusterConfiguration clusterConfig) {
        this(clusterConfig, (GenericObjectPoolConfig)new DefaultPoolConfig());
    }

    public LettuceConnectionFactory(RedisStandaloneConfiguration standaloneConfig, GenericObjectPoolConfig<?> poolConfig) {
        this(poolConfig);
        Utils.assertNotNull(standaloneConfig, "RedisStandaloneConfiguration must not be null.");
        this.configuration = standaloneConfig;
    }

    public LettuceConnectionFactory(RedisSentinelConfiguration sentinelConfig, GenericObjectPoolConfig poolConfig) {
        this(poolConfig);
        Utils.assertNotNull(sentinelConfig, "RedisSentinelConfiguration must not be null.");
        this.configuration = sentinelConfig;
    }

    public LettuceConnectionFactory(RedisClusterConfiguration clusterConfig, GenericObjectPoolConfig poolConfig) {
        this(poolConfig);
        Utils.assertNotNull(clusterConfig, "RedisClusterConfiguration must not be null.");
        this.configuration = clusterConfig;
    }

    public boolean isUseSsl() {
        return this.useSsl;
    }

    public void setUseSsl(boolean useSsl) {
        this.useSsl = useSsl;
    }

    public boolean isVerifyPeer() {
        return this.verifyPeer;
    }

    public void setVerifyPeer(boolean verifyPeer) {
        this.verifyPeer = verifyPeer;
    }

    public boolean isStartTls() {
        return this.startTls;
    }

    public void setStartTls(boolean startTls) {
        this.startTls = startTls;
    }

    public Optional<ClientResources> getClientResources() {
        return this.clientResources;
    }

    public void setClientResources(ClientResources clientResources) {
        this.clientResources = Optional.ofNullable(clientResources);
    }

    public Optional<ClientOptions> getClientOptions() {
        return this.clientOptions;
    }

    public void setClientOptions(ClientOptions clientOptions) {
        this.clientOptions = Optional.ofNullable(clientOptions);
    }

    public Optional<ReadFrom> getReadFrom() {
        return this.readFrom;
    }

    public void setReadFrom(ReadFrom readFrom) {
        this.readFrom = Optional.ofNullable(readFrom);
    }

    public Optional<String> getClientName() {
        return this.clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = Optional.ofNullable(clientName);
    }

    public Optional<Duration> getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Duration timeout) {
        this.timeout = Optional.ofNullable(timeout);
    }

    public void setTimeoutMillis(long timeout) {
        this.setTimeout(Duration.ofMillis(timeout));
    }

    public GenericObjectPoolConfig getPoolConfig() {
        return this.poolConfig;
    }

    public void setPoolConfig(GenericObjectPoolConfig poolConfig) {
        this.poolConfig = poolConfig;
    }

    @Override
    public RedisConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(RedisConfiguration configuration) {
        this.configuration = configuration;
    }

    public Optional<BatchOptions> getBatchOptions() {
        return this.batchOptions;
    }

    @Override
    public void setBatchOptions(BatchOptions options) {
        this.batchOptions = Optional.ofNullable(options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ConnectionPool getPool() {
        if (this.pool == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.pool == null) {
                    this.doInit();
                }
            }
        }
        return this.pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractRedisClient getClient() {
        if (this.client == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.client == null) {
                    this.doInit();
                }
            }
        }
        return this.client;
    }

    @Override
    public RedisConnection getConnection() {
        if (this.isRedisClusterAware()) {
            return this.getClusterConnection();
        }
        return new LettuceConnection(this.getPool(), this.batchOptions.orElse(BatchOptions.defaulted), this.timeout.orElse(RedisURI.DEFAULT_TIMEOUT_DURATION));
    }

    public LettuceClusterConnection getClusterConnection() {
        if (!this.isRedisClusterAware()) {
            throw new InvocationException("Cluster is not configured.");
        }
        return new LettuceClusterConnection(this.getPool(), this.batchOptions.orElse(BatchOptions.defaulted), this.timeout.orElse(RedisURI.DEFAULT_TIMEOUT_DURATION));
    }

    public boolean isRedisSentinelAware() {
        return RedisConfiguration.isSentinelConfiguration(this.configuration);
    }

    public boolean isRedisClusterAware() {
        return RedisConfiguration.isClusterConfiguration(this.configuration);
    }

    protected ConnectionPool createConnectionPool(AbstractRedisClient client, RedisCodec<?, ?> codec, ReadFrom readFrom) {
        ConnectionProvider connectionProvider = this.createConnectionProvider(client, codec, readFrom);
        return new ConnectionPool.LettuceSmartConnectionPool(connectionProvider, this.poolConfig);
    }

    protected ConnectionProvider createConnectionProvider(AbstractRedisClient client, RedisCodec<?, ?> codec, ReadFrom readFrom) {
        if (this.isRedisClusterAware()) {
            return new LettuceClusterConnectionProvider((RedisClusterClient)client, codec, readFrom);
        }
        return new LettuceStandaloneConnectionProvider((RedisClient)client, codec, readFrom);
    }

    protected AbstractRedisClient createClient() {
        if (this.isRedisSentinelAware()) {
            RedisURI redisUri = this.createSentinelRedisUri((RedisSentinelConfiguration)this.configuration);
            RedisClient client = this.getClientResources().map(clientResources -> RedisClient.create((ClientResources)clientResources, (RedisURI)redisUri)).orElseGet(() -> RedisClient.create((RedisURI)redisUri));
            this.getClientOptions().ifPresent(arg_0 -> ((RedisClient)client).setOptions(arg_0));
            return client;
        }
        if (this.isRedisClusterAware()) {
            Set<RedisURI> redisUris = this.createClusterRedisUris((RedisClusterConfiguration)this.configuration);
            RedisClusterClient clusterClient = this.getClientResources().map(clientResources -> RedisClusterClient.create((ClientResources)clientResources, (Iterable)redisUris)).orElseGet(() -> RedisClusterClient.create((Iterable)redisUris));
            clusterClient.setOptions(this.getClusterClientOptions((RedisConfiguration.ClusterConfiguration)((Object)this.configuration)));
            return clusterClient;
        }
        RedisStandaloneConfiguration conf = (RedisStandaloneConfiguration)this.configuration;
        RedisURI redisUri = this.createRedisUri(conf.getHost(), conf.getPort(), conf.getPassword(), conf.getDatabase());
        RedisClient client = this.getClientResources().map(clientResources -> RedisClient.create((ClientResources)clientResources, (RedisURI)redisUri)).orElseGet(() -> RedisClient.create((RedisURI)redisUri));
        this.getClientOptions().ifPresent(arg_0 -> ((RedisClient)client).setOptions(arg_0));
        return client;
    }

    private ClusterClientOptions getClusterClientOptions(RedisConfiguration.ClusterConfiguration clusterConfig) {
        Optional<ClientOptions> clientOptions = this.getClientOptions();
        ClusterClientOptions clusterClientOptions = clientOptions.filter(ClusterClientOptions.class::isInstance).map(ClusterClientOptions.class::cast).orElseGet(() -> clientOptions.map(options -> ClusterClientOptions.builder((ClientOptions)options).build()).orElseGet(ClusterClientOptions::create));
        return clusterClientOptions.mutate().maxRedirects(clusterConfig.getMaxAttempts()).build();
    }

    private RedisURI createSentinelRedisUri(RedisSentinelConfiguration sentinelConfig) {
        Utils.assertNotNull(sentinelConfig, "RedisSentinelConfiguration is required");
        Set<HostPortPair> sentinels = sentinelConfig.getSentinels();
        RedisURI.Builder builder = RedisURI.builder().withSentinelMasterId(sentinelConfig.getMasterName());
        sentinels.forEach(pair -> builder.withSentinel(pair.getHost(), pair.getPort()));
        Optional.ofNullable(sentinelConfig.getPassword()).ifPresent(arg_0 -> ((RedisURI.Builder)builder).withPassword(arg_0));
        this.getClientName().ifPresent(arg_0 -> ((RedisURI.Builder)builder).withClientName(arg_0));
        this.getTimeout().ifPresent(arg_0 -> ((RedisURI.Builder)builder).withTimeout(arg_0));
        return builder.withSsl(this.isUseSsl()).withVerifyPeer(this.isVerifyPeer()).withStartTls(this.isStartTls()).withDatabase(sentinelConfig.getDatabase()).build();
    }

    private RedisURI createRedisUri(String host, int port, String password, int database) {
        RedisURI.Builder builder = RedisURI.Builder.redis((String)host, (int)port);
        Optional.ofNullable(password).ifPresent(arg_0 -> ((RedisURI.Builder)builder).withPassword(arg_0));
        this.getClientName().ifPresent(arg_0 -> ((RedisURI.Builder)builder).withClientName(arg_0));
        this.getTimeout().ifPresent(arg_0 -> ((RedisURI.Builder)builder).withTimeout(arg_0));
        return builder.withSsl(this.isUseSsl()).withVerifyPeer(this.isVerifyPeer()).withStartTls(this.isStartTls()).withDatabase(database).build();
    }

    private Set<RedisURI> createClusterRedisUris(RedisClusterConfiguration clusterConfig) {
        Utils.assertNotNull(clusterConfig, "RedisClusterConfiguration is required");
        Set<HostPortPair> nodes = clusterConfig.getClusterNodes();
        LinkedHashSet<RedisURI> redisUris = new LinkedHashSet<RedisURI>(nodes.size());
        nodes.forEach(pair -> redisUris.add(this.createRedisUri(pair.getHost(), pair.getPort(), clusterConfig.getPassword(), 0)));
        return redisUris;
    }

    @Override
    public void init() throws Exception {
        this.doInit();
    }

    private void doInit() {
        if (this.client == null) {
            this.client = this.createClient();
            this.pool = this.createConnectionPool(this.client, (RedisCodec<?, ?>)ByteArrayCodec.INSTANCE, this.readFrom.orElse(null));
        }
    }

    @Override
    public void destroy() throws Exception {
        this.doDestroy();
    }

    private void doDestroy() throws Exception {
        if (this.client != null) {
            try {
                this.client.shutdown();
                this.pool.destroy();
            }
            finally {
                this.client = null;
                this.pool = null;
            }
        }
    }
}

