/**
 * Copyright (c) 2016-2019, Bosco.Liao (bosco_liao@126.com).
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.iherus.shiro.util;

import static org.iherus.shiro.util.Utils.assertNotBlank;
import static org.iherus.shiro.util.Utils.assertNotNull;

import java.util.function.Supplier;

/**
 * Redis 版本解析工具。
 *
 * @author Bosco.Liao
 * @since 2.0.0
 */
public class RedisVerUtils {

	private volatile static VersionInfo serverVersion;

	public static VersionInfo getServerVersion(final Supplier<String> supplier) {

		assertNotNull(supplier, "Supplier must not be null.");

		if (serverVersion == null) {
			synchronized (RedisVerUtils.class) {
				if (serverVersion == null) {
					serverVersion = new VersionInfo(supplier.get());
				}
			}
		}

		return serverVersion;
	}

	public final static class VersionInfo {

		private final String version;

		VersionInfo(String version) {
			assertNotBlank(version, "Version must not be blank.");
			this.version = version;
		}

		public String getVersion() {
			return version;
		}

		public boolean isSupportUnlink() {
			return version.startsWith("4");
		}

		public boolean isSupportStream() {
			return version.startsWith("5");
		}

	}

}
