/*
 * Decompiled with CFR 0.152.
 */
package org.iherus.shiro.cache.redis.config;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.iherus.shiro.cache.redis.config.HostPortPair;
import org.iherus.shiro.cache.redis.config.RedisConfiguration;
import org.iherus.shiro.util.Utils;

public class RedisSentinelConfiguration
implements RedisConfiguration,
RedisConfiguration.SentinelConfiguration {
    private String masterName;
    private Set<HostPortPair> sentinels = new LinkedHashSet<HostPortPair>();
    private int database;
    private String password;

    @Override
    public String getMasterName() {
        return this.masterName;
    }

    public void setMasterName(String masterName) {
        this.masterName = masterName;
    }

    @Override
    public int getDatabase() {
        return this.database;
    }

    public void setDatabase(int database) {
        Utils.assertIsTrue(database >= 0, () -> String.format("Invalid DB index '%s' (a positive index required)", database));
        this.database = database;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public Set<HostPortPair> getSentinels() {
        return Collections.unmodifiableSet(this.sentinels);
    }

    public void setSentinels(Set<HostPortPair> sentinels) {
        this.sentinels = sentinels;
    }

    public void setSentinelsFromText(String sentinels) {
        String sentinelsToUse = Utils.isNotBlank(sentinels) ? sentinels.replace(" ", "") : sentinels;
        this.addSentinels(Utils.commaDelimitedListToSet(sentinelsToUse));
    }

    public void addSentinel(HostPortPair sentinel) {
        Utils.assertNotNull(sentinel, "Sentinel must not be 'null'.");
        this.sentinels.add(sentinel);
    }

    private void addSentinels(Set<String> hostAndPorts) {
        for (String hostAndPort : hostAndPorts) {
            this.addSentinel(this.readHostAndPortFromString(hostAndPort));
        }
    }

    private HostPortPair readHostAndPortFromString(String hostAndPort) {
        String[] args = Utils.split(hostAndPort, ":");
        Utils.assertNotNull(args, "HostAndPort need to be seperated by  ':'.");
        Utils.assertIsTrue(args.length == 2, () -> "Host and Port String needs to specified as host:port");
        return new HostPortPair(args[0], Integer.valueOf(args[1]));
    }

    public Set<String> getTextSentinels() {
        return HostPortPair.convertToStringPairs(this.getSentinels(), false, new boolean[0]);
    }

    @Override
    public Set<String> getAddresses(boolean ssl) {
        return HostPortPair.convertToStringPairs(this.getSentinels(), true, ssl);
    }
}

