/*
 * Decompiled with CFR 0.152.
 */
package org.iherus.shiro.cache.redis.connection.jedis;

import java.time.Duration;
import java.util.HashSet;
import java.util.Optional;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.iherus.shiro.cache.redis.config.DefaultPoolConfig;
import org.iherus.shiro.cache.redis.config.HostPortPair;
import org.iherus.shiro.cache.redis.config.RedisClusterConfiguration;
import org.iherus.shiro.cache.redis.config.RedisConfiguration;
import org.iherus.shiro.cache.redis.config.RedisSentinelConfiguration;
import org.iherus.shiro.cache.redis.config.RedisStandaloneConfiguration;
import org.iherus.shiro.cache.redis.connection.BatchOptions;
import org.iherus.shiro.cache.redis.connection.Destroyable;
import org.iherus.shiro.cache.redis.connection.Initializable;
import org.iherus.shiro.cache.redis.connection.RedisConnection;
import org.iherus.shiro.cache.redis.connection.RedisConnectionFactory;
import org.iherus.shiro.cache.redis.connection.jedis.JedisClusterConnection;
import org.iherus.shiro.cache.redis.connection.jedis.JedisConnection;
import org.iherus.shiro.exception.InvocationException;
import org.iherus.shiro.util.Utils;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisSentinelPool;
import redis.clients.jedis.util.Pool;

public class JedisConnectionFactory
implements RedisConnectionFactory,
Initializable,
Destroyable {
    private volatile Pool<Jedis> pool;
    private volatile JedisCluster cluster;
    private RedisConfiguration configuration = RedisConfiguration.defaulted;
    private GenericObjectPoolConfig<?> poolConfig;
    private String clientName;
    private Duration soTimeout = Duration.ofMillis(2000L);
    private Duration connectTimeout = Duration.ofMillis(2000L);
    private boolean useSsl;
    private SSLSocketFactory sslSocketFactory;
    private SSLParameters sslParameters;
    private HostnameVerifier hostnameVerifier;
    private Optional<BatchOptions> batchOptions = Optional.empty();
    private final Object lock = new Object();

    public JedisConnectionFactory() {
        this(new DefaultPoolConfig());
    }

    public JedisConnectionFactory(GenericObjectPoolConfig<?> poolConfig) {
        this.poolConfig = poolConfig == null ? new DefaultPoolConfig() : poolConfig;
    }

    public JedisConnectionFactory(RedisStandaloneConfiguration standaloneConfig) {
        this(standaloneConfig, new DefaultPoolConfig());
    }

    public JedisConnectionFactory(RedisSentinelConfiguration sentinelConfig) {
        this(sentinelConfig, new DefaultPoolConfig());
    }

    public JedisConnectionFactory(RedisClusterConfiguration clusterConfig) {
        this(clusterConfig, new DefaultPoolConfig());
    }

    public JedisConnectionFactory(RedisStandaloneConfiguration standaloneConfig, GenericObjectPoolConfig<?> poolConfig) {
        this(poolConfig);
        Utils.assertNotNull(standaloneConfig, "RedisStandaloneConfiguration must not be null.");
        this.configuration = standaloneConfig;
    }

    public JedisConnectionFactory(RedisSentinelConfiguration sentinelConfig, GenericObjectPoolConfig<?> poolConfig) {
        this(poolConfig);
        Utils.assertNotNull(sentinelConfig, "RedisSentinelConfiguration must not be null.");
        this.configuration = sentinelConfig;
    }

    public JedisConnectionFactory(RedisClusterConfiguration clusterConfig, GenericObjectPoolConfig<?> poolConfig) {
        this(poolConfig);
        Utils.assertNotNull(clusterConfig, "RedisClusterConfiguration must not be null.");
        this.configuration = clusterConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Pool<Jedis> getPool() {
        if (this.pool == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.pool == null) {
                    this.pool = this.createPool();
                }
            }
        }
        return this.pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JedisCluster getCluster() {
        if (this.cluster == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.cluster == null) {
                    this.cluster = this.createCluster();
                }
            }
        }
        return this.cluster;
    }

    @Override
    public RedisConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(RedisConfiguration configuration) {
        this.configuration = configuration;
    }

    public GenericObjectPoolConfig<?> getPoolConfig() {
        return this.poolConfig;
    }

    public void setPoolConfig(GenericObjectPoolConfig<?> poolConfig) {
        this.poolConfig = poolConfig;
    }

    public String getClientName() {
        return this.clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public Duration getSoTimeout() {
        return this.soTimeout;
    }

    public void setSoTimeout(Duration soTimeout) {
        this.soTimeout = soTimeout;
    }

    public void setSoTimeoutMillis(long soTimeoutMillis) {
        this.setSoTimeout(Duration.ofMillis(soTimeoutMillis));
    }

    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setConnectTimeoutMillis(long connectTimeoutMillis) {
        this.setConnectTimeout(Duration.ofMillis(connectTimeoutMillis));
    }

    protected int getSoTimeoutAsMillis() {
        return Math.toIntExact(this.getSoTimeout().toMillis());
    }

    protected int getConnectionTimeoutAsMillis() {
        return Math.toIntExact(this.getConnectTimeout().toMillis());
    }

    public boolean isUseSsl() {
        return this.useSsl;
    }

    public void setUseSsl(boolean useSsl) {
        this.useSsl = useSsl;
    }

    public SSLSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }

    public void setSslSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
    }

    public SSLParameters getSslParameters() {
        return this.sslParameters;
    }

    public void setSslParameters(SSLParameters sslParameters) {
        this.sslParameters = sslParameters;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    public Optional<BatchOptions> getBatchOptions() {
        return this.batchOptions;
    }

    @Override
    public void setBatchOptions(BatchOptions options) {
        this.batchOptions = Optional.ofNullable(options);
    }

    @Override
    public RedisConnection getConnection() {
        if (this.isRedisClusterAware()) {
            return this.getClusterConnection();
        }
        Jedis jedis = this.fetchJedisConnection();
        return new JedisConnection(jedis, this.batchOptions.orElse(BatchOptions.defaulted));
    }

    public JedisClusterConnection getClusterConnection() {
        if (!this.isRedisClusterAware()) {
            throw new InvocationException("Cluster is not configured.");
        }
        return new JedisClusterConnection(this.getCluster(), this.batchOptions.orElse(BatchOptions.defaulted));
    }

    public boolean isRedisSentinelAware() {
        return RedisConfiguration.isSentinelConfiguration(this.configuration);
    }

    public boolean isRedisClusterAware() {
        return RedisConfiguration.isClusterConfiguration(this.configuration);
    }

    protected Jedis fetchJedisConnection() {
        return (Jedis)this.getPool().getResource();
    }

    private Pool<Jedis> createPool() {
        if (this.isRedisSentinelAware()) {
            return this.createRedisSentinelPool((RedisSentinelConfiguration)this.configuration);
        }
        return this.createRedisStandalonePool((RedisStandaloneConfiguration)this.configuration);
    }

    protected Pool<Jedis> createRedisStandalonePool(RedisStandaloneConfiguration config) {
        Utils.assertNotNull(config, "RedisStandaloneConfiguration must not be null.");
        return new JedisPool(this.getPoolConfig(), config.getHost(), config.getPort(), this.getConnectionTimeoutAsMillis(), this.getSoTimeoutAsMillis(), config.getPassword(), config.getDatabase(), this.getClientName(), this.isUseSsl(), this.getSslSocketFactory(), this.getSslParameters(), this.getHostnameVerifier());
    }

    protected Pool<Jedis> createRedisSentinelPool(RedisSentinelConfiguration config) {
        Utils.assertNotNull(config, "RedisSentinelConfiguration must not be null.");
        return new JedisSentinelPool(config.getMasterName(), config.getTextSentinels(), this.getPoolConfig(), this.getConnectionTimeoutAsMillis(), this.getSoTimeoutAsMillis(), config.getPassword(), config.getDatabase(), this.getClientName());
    }

    private JedisCluster createCluster() {
        return this.createRedisCluster((RedisClusterConfiguration)this.configuration);
    }

    protected JedisCluster createRedisCluster(RedisClusterConfiguration config) {
        Utils.assertNotNull(config, "RedisClusterConfiguration must not be null.");
        HashSet<HostAndPort> clusterNodes = new HashSet<HostAndPort>();
        for (HostPortPair node : config.getClusterNodes()) {
            clusterNodes.add(new HostAndPort(node.getHost(), node.getPort()));
        }
        return new JedisCluster(clusterNodes, this.getConnectionTimeoutAsMillis(), this.getSoTimeoutAsMillis(), config.getMaxAttempts(), config.getPassword(), this.getClientName(), this.getPoolConfig(), this.isUseSsl(), this.getSslSocketFactory(), this.getSslParameters(), this.getHostnameVerifier(), null);
    }

    @Override
    public void init() throws Exception {
        if (!this.isRedisClusterAware() && this.pool == null) {
            this.pool = this.createPool();
        }
        if (this.isRedisClusterAware() && this.cluster == null) {
            this.cluster = this.createCluster();
        }
    }

    @Override
    public void destroy() throws Exception {
        try {
            if (this.pool != null) {
                this.pool.close();
            }
            if (this.cluster != null) {
                this.cluster.close();
            }
        }
        finally {
            this.pool = null;
            this.cluster = null;
        }
    }
}

